<?php
//$split=1;

    include "fst/food-security/header.php";
    //----------------------------------------------------------
    //banner images
    $index_banner = array(
        "<img src=\"$page->base images/food_security/banner1.jpg\" width=\"300\" height=\"250\" alt=\"Food Security\" />",
        "<img src=\"$page->base images/food_security/banner2.jpg\" width=\"300\" height=\"250\" alt=\"Food Security\" />",
        "<img src=\"$page->base images/food_security/banner3.jpg\" width=\"300\" height=\"250\" alt=\"Food Security\" />",
        "<img src=\"$page->base images/food_security/banner4.jpg\" width=\"300\" height=\"250\" alt=\"Food Security\" />",
        "<img src=\"$page->base images/food_security/banner5.jpg\" width=\"300\" height=\"250\" alt=\"Food Security\" />",
        
    );
    shuffle($index_banner);
?>


<div id="top" class="ug_courses_header">
    <h2>Food Security in the 21st century</h2>
</div>

<div class="item">
    <p>With the world's population fast approaching seven billion, one of the main challenges facing the human race is how to feed its people. It's estimated that a rise in food production of at least 50% will be needed by 2030 to meet increasing food demands, against a backdrop of accelerating climate change and increasingly unpredictable weather extremes.</p>
    <p>While the effects of expanding constraints on food supplies will be felt by all, the impact will inevitably fall first on those countries in the developing world with the fewest resources. Today around one billion people regularly go hungry - a situation that can only worsen without urgent, collective action.</p>
    <div class="embed-container">
        <iframe src="https://www.youtube.com/embed/2NTT_5M0FWo" frameborder="0" allowfullscreen></iframe>
    </div>
    <p>And food production itself is only part of the problem. Food security isn't just about exploiting scientific and technological advances to increase crop yields, it's also about addressing the associated economic, social and environmental factors to enable the people of our planet to have uninterrupted access to sufficient, safe and nutritious food. There are no simple answers.</p>
    <div class="image_box" style="width:300px; height:250px;">
        <div id="banner" class="slideshow_fast">
            <?php
            //write all banner images
            foreach($index_banner as $value){
                echo $value."\n";
            }
            ?>
        </div>
    </div>
    <p>Here at Lancaster University we're at the forefront of research into global food security. For example, a group of Biologists from the Lancaster Environment Centre is currently helping farmers in some of the driest regions of the world cope more successfully with drought. It's a project that has earned the university the prestigious Queen's Anniversary Prize for Higher and Further Education.</p>
    <p>The work we do is contributing to improving food security for some of the world's most vulnerable societies in more than 30 countries. But we urgently need your help to expand and extend these essential programmes. Perhaps we could benefit from your professional expertise, or maybe your company could support a specific research project. How about funding a deserving student from the developing world to gain skills to help their country? Or simply backing our dedicated team by helping to provide the resources they need to grow...</p>
    <p>It's more than a gift of time, expertise or money - it's your chance to help us change the world!</p>
</div>

<div class="item">
<h3>MSc in Sustainable Agriculture and Food Security</h3>
<p>LEC is launching a new Master's course in association with colleagues from other institutions and faculties across the University. The course comprises 6 months of specialised course work, followed by an individual piece of research, leading to an M Sc. (A two year option comprising a 12 months overseas research placement leading to an M Sc Research is also available)</p>
<ul class="links">
    <li><a href="<?php echo $page->base ?>docs/msc_sustainable_agriculture_food_security.pdf">MSc Sustainable Agriculture and Food Security</a></li>
</ul>

</div>

<div class="item">
<h3>Some Food Security-related expertise at Lancaster</h3>
<div class="clear">
    <h4>Food Utilisation</h4>
    <ul class="links">
        <li><a href="http://www.research.lancs.ac.uk/portal/en/people/peter-diggle%28811d7fc3-047a-40d2-89e6-c85d14a97fb8%29.html">Peter Diggle - Environmental and tropical disease epidemiology</a></li>
        <li><a href="the-lancaster-contribution#forero">Oscar Forero - Foodways: Food systems and food cultures</a></li>
        <li><a href="the-lancaster-contribution#jones">Kevin Jones - Pesticides and the use of wastes in agriculture</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/hong-li">Hong Li - Chemicals and agriculture in China</a></li>
        <li><a href="http://www.lancaster.ac.uk/fhm/about-us/people/bob-lauder">Bob Lauder - Vitamin/nutritional supplements</a></li>
        <li><a href="the-lancaster-contribution#pickup">Roger Pickup - Environment and health</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/mike-pidd/">Mike Pidd - Food standards</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/kirk-semple">Kirk Semple - Contaminated soils</a></li>
    </ul>
</div>
    
<div class="clear">
    <h4>Food Access</h4>
    <ul class="links">
        <li>V.N. Balasubramanian - Development economics and international trade</li>
        <li><a href="the-lancaster-contribution#browne">Alison Browne - UK water resources</a></li>
        <li>Amanda Cahill - Right to water</li>
        <li><a href="the-lancaster-contribution#eglese">Richard Eglese - Food distribution systems</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/gillian-hopkinson/">Gill Hopkinson - Globalisation of retail</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/alasdair-macbean/">Alasdair MacBean - Environmental economics</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/judi-marshall/">Judi Marshall - Sustainability</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/richard-meek/">Richard Meek - Agricultural economics and marketing</a></li>
        <li><a href="http://www.lancaster.ac.uk/fass/sociology/profiles/Bronislaw-Szerszynski/">Bronislaw Szerszynski - The GM crops controversy; Local food systems</a></li>
        <li><a href="http://www.lancaster.ac.uk/lums/people/all/ian-walker/">Ian Walker - Applied microeconomics; Markets</a></li>
    </ul>
</div>
    
<div class="clear">
    <h4>Environmental Issues</h4>
    <ul class="links">
        <li><a href="the-lancaster-contribution#aller">Maria-Fernander Aller - Waste to energy; Biochar</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/jos-barlow">Jos Barlow - Land use issues</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/keith-beven">Keith Beven - Modelling</a></li>
        <li><a href="http://www.comp.lancs.ac.uk/department/staff.php?name=gordon">Gordon Blair - Environmental sensing</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/william-davison">Bill Davison - Chemicals in the environment</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/philip-haygarth">Phil Haygarth - Diffuse pollution</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/louise-heathwaite">Louise Heathwaite - Water quality</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/nick-hewitt">Nick Hewitt - Biosphere: atmosphere interactions</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/rosa-menendez-martinez">Rosa Menendez - Insects and climate change</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/john-quinton">John Quinton - Soils and water management</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/felix-wackers">Felix Wackers - Functional biodiversity</a></li>
        <li><a href="the-lancaster-contribution#whittle">Rebecca Whittle - Alternative food systems</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/andy-wilby">Andy Wilby - Functional biodiversity</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/oliver-wild">Oliver Wild - Atmospheric composition</a></li>
        <li><a href="the-lancaster-contribution#wilson">Ken Wilson - Agro ecology; Biological control of insect pests</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/hao-zhang">Hao Zhang - Chemicals in the environment</a></li>
    </ul>
</div>
    
<div class="clear">
    <h4>Food Availability</h4>
    <ul class="links">
        <li><a href="http://www.sw-consulting.co.uk/people/">Mike Berners-Lee - Footprinting</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/alan-blackburn">Alan Blackburn - GIS</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/lin-chen">Lin Chen - Root biology</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/bill-davies">Bill Davies - Plant production and sustainable use of resources</a></li>
        <li><a href="the-lancaster-contribution#dodd">Ian Dodd - Crop water use efficiency &amp; irrigation</a></li>
        <li><a href="the-lancaster-contribution#forde">Brian Forde - Sustainable use of nutrients</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/david-ingram">David Ingram - Plant pathology</a></li>
        <li><a href="the-lancaster-contribution#jarvis">Andy Jarvis - Climate change effects</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/ian-marshall">Ian Marshall - Informatics</a></li>
        <li><a href="the-lancaster-contribution#may">Chris May - IPR</a></li>
        <li><a href="the-lancaster-contribution#mcainsh">Martin McAinsh - Plants and water</a></li>
        <li><a href="http://www.rothamsted.ac.uk/people/parrym">Martin Parry - Crop yield improvement</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/nigel-paul">Nigel Paul - Sustainable pest and disease management</a></li>
        <li><a href="the-lancaster-contribution#roberts">Mike Roberts - Sustainable pest and disease management</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/jane-taylor">Jane Taylor - Sustainable pest and disease management</a></li>
        <li><a href="the-lancaster-contribution#wilkinson">Sally Wilkinson - Ozone stress</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/dawn-worrall">Dawn Worrall - Systemic signalling</a></li>
    </ul>
</div>
    
<div class="clear">
    <h4>Social Issues</h4>
    <ul class="links">
        <li><a href="http://www.lancaster.ac.uk/fass/lica/people/Rachel-Cooper/">Rachel Cooper - Urban sustainability; Design</a></li>
        <li>Mason Minnitt - School farms</li>
        <li><a href="the-lancaster-contribution#saunders">Murray Saunders - Evaluation; School farms; Sensitization</a></li>
        <li><a href="the-lancaster-contribution#twine">Richard Twine - Political economy of animal biotechnology</a></li>
        <li><a href="http://www.lancaster.ac.uk/fass/sociology/profiles/David-Tyfield/">David Tyfield - Low carbon society</a></li>
        <li><a href="http://www.lancaster.ac.uk/lec/saskia-vermeylen">Saskia Vermeylen - Land rights</a></li>
        <li><a href="http://www.lancaster.ac.uk/fass/sociology/profiles/Claire-Waterton/">Claire Waterton - Science and society</a></li>
        <li><a href="http://www.lancaster.ac.uk/fass/sociology/profiles/Brian-Wynne">Brian Wynne - Science and society</a></li>
    </ul>
</div>

</div>

<div style="display:none;" id="expertise">
<p>Some Food Security-related expertise at Lancaster</p><img src="<?php echo $page->base; ?>images/foodsecurity/expertise_large.jpg" alt="expertise" />
</div>


<?php
//----------------------------------------------------------
include "fst/universal/jquery_slideshow.php";
include "fst/universal/jquery_effects.php";
include "fst/universal/jquery_forms.php";
include "fst/universal/jquery_facebox.php";
include "fst/food-security/footer.php";
?>