<?php
	//$split=1;
	
	include "fst/food-security/header.php";
	//----------------------------------------------------------
?>

<h2>The Lancaster contribution</h2>

<div class="item">
	<div class="clear">
		<a name="dodd"></a>
		<h3>Urban agriculture in Singapore</h3>
		<h4>Ian Dodd - Lancaster Environment Centre</h4>
		<a href="#urban" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/singapore.jpg" alt="Urban agriculture in Singapore" width="220" height="98" /></a>
		<p>Cities have massive food needs to sustain their populations, and usually rely on surrounding rural areas to provide. However, city nations such as Singapore depend largely on imports from beyond their national border, making food prices vulnerable to external factors. Lancaster researchers are working with Nanyang Technological University to increase the potential of urban agriculture using aeroponics - growing plants with their root systems suspended in air and spraying the root systems with nutrient solutions.</p>
		<p>Our research has shown that regulating nutrient solution temperature is critical for proper crop growth. We are evaluating management techniques and genetic variation in crop responses to root temperature to minimise the energy inputs required to maintain the optimum temperature for root growth.</p>
	</div>

	<div class="clear">
		<a name="dodd2"></a>
		<h3>Saving irrigation water in agriculture and horticulture within the Mediterranean basin</h3>
		<h4>Ian Dodd - Lancaster Environment Centre</h4>
		<a href="#irrigation_water" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/irrigation_water.jpg" alt="Urban agriculture in Singapore" width="220" height="98" /></a>
		<p>Mediterranean irrigated agricultural systems are already suffering acute water shortages due to climate change. Lancaster researchers, in collaboration with 14 partner organisations within this region, aim to improve crop water use efficiency via Integrated Irrigation Management at farm, irrigation district and watershed scales. On the farm, more efficient and precise irrigation techniques using soil and plant sensors will be integrated with suitable crop husbandry. At the district scale, data bases and management tools (decision support systems) will develop an integrated policy of water allocation. At the watershed scale, strategies and policies will promote responsible use of irrigation water in participation with stakeholders (farmers, associations of irrigation users, and the water authorities).</p>
	</div>

	<div class="clear">
		<a name="dodd3"></a>
		<h3>Understanding the drought sensitivity of new wheat genotypes in Mexico</h3>
		<h4>Ian Dodd - Lancaster Environment Centre</h4>
		<a href="#mexico" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/mexico.jpg" alt="mexico" width="220" height="98" /></a>
		<p>New wheat genotypes have been developed at CIMMYT (Mexico) by wide crossing with members of the Triticae tribe to broaden the wheat gene pool, transgenic approaches, and physiological and molecular breeding to strategically combine complementary traits and identify elite lines. Lancaster researchers are working with these genotypes to gain a better understanding of the processes that determine floret abortion (that limits wheat grain yield). Particular emphasis has been placed on genotypes that show more vigorous root growth allowing water capture from deeper in the soil profile. This may minimise floret abortion, allowing a greater partitioning of photosynthetic assimilates to developing wheat grains, thus raising yield.   </p>
	</div>

	<div class="clear">
		<a name="wilson"></a>
		<h3>Food Security in Africa</h3>
		<h4>Ken Wilson - Lancaster Environment Centre</h4>
		<a href="#armyworm" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/armyworm.jpg" alt="Spodoptera exempta" width="220" height="98" /></a>
		<p>African armyworm (Spodoptera exempta) is a devastating crop pest throughout the eastern half of Africa, especially, Kenya and Tanzania, as well as parts of West Africa. As a migrant pest, much like locusts, outbreaks of this insect are difficult to predict and traditional control using imported chemical insecticides is expensive and damaging to human health, livestock, beneficial insects and the wider environment. </p>
		<p>In collaboration with colleagues in Tanzania, the UK and Canada, Dr Kenneth Wilson has been developing a novel biological control agent against armyworms - a natural disease of this insect called SpexNPV. This pathogen is much safer to use than chemical pesticides, because it is harmful only to armyworms, and it can be produced cheaply and sustainably in Africa itself. </p>
		<p>With funding from the Biotechnology and Biological Sciences Research Council (BBSRC) and the Department for International Development (DFID), Wilson and colleagues are not only trying to develop cheap and efficient ways of producing SpexNPV in Tanzania, but are also conducting fundamental research into the molecular ecology of the pathogen. In so doing, they hope to be able to gain a better understanding of how this natural disease agent can be exploited as a strategic biological control agent across the whole of Africa.</p>
		<h4>Reference:</h4>
		<p>Grzywacz, D., Mushobozi, W.L., Parnell, M., Jolliffe, F. & WILSON, K. (2008) Evaluation of Spodoptera exempta nucleopolyhedrovirus (SpexNPV) for the field control of African armyworm (Spodoptera exempta) in Tanzania. Crop Protection 27 (1): 17-24.</p>
		<h4>Associated links</h4>
		<div class="link">
			<p><a href="http://www.lancaster.ac.uk/armyworm/">Armyweb</a> - A web resource for African armyworm.</p>
		</div>
	</div>


	<div class="clear">
		<a name="wilkinson"></a>
		<h3>The involvement of chemical signals in the plant's competitive responses to neighbours in Russia</h3>
		<h4>Sally Wilkinson - Lancaster Environment Centre</h4>
		<a href="#russia" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/russia.jpg" alt="Russia" width="220" height="98" /></a>
		<p>Competition for space and various limiting resources is probably the most important biotic stress for plants. In addition to depletion of resources, plants can profoundly affect one another by releasing chemicals into the soil or into the air that can be detected by neighbours. Studying these plant-to-plant signals will allow us to predict plant behaviour in natural communities and to improve agronomic performance at increased planting density. Lancaster researchers collaborating with colleagues from Ufa University in Russia have found that the ability of plants to respond to the presence (or absence) of neighbours is linked to the plasticity of changes in the regulation of gas exchange and water loss by leaves. The plant hormones abscisic acid and ethylene modify and/or control the response. Detection of the absence of neighbours and corresponding increases in stomatal conductance and carbon acquisition may be important for faster growth and space occupancy during crop establishment.</p>
	</div>

	<div class="clear">
		<a name="roberts"></a>
		<h3>Seed Treatments Against Pests and Diseases</h3>
		<h4>Mike Roberts - Lancaster Environment Centre</h4>
		<a href="#iowa" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/iowa.jpg" alt="iowa" width="220" height="98" /></a>
		<p>Damage by pests and pathogens can have significant impacts on crop yield and quality. In recent decades, chemical pesticides have been relied upon as the main method for crop protection. However, attention is increasingly turning to ways of enhancing natural plant defence mechanisms. At Lancaster, we have pioneered a seed treatment method that promotes long-term increases in pest and disease resistance. Because the treatments use natural plant compounds, they are environmentally-friendly and compatible with the use of biological control agents. The first <a href="http://www.beckerunderwood.com/en/newsreleases/060809pbl">commercial products</a> based on our technology will be brought to market in the very near future.</p>
	</div>

	<div class="clear">
		<a name="forde"></a>
		<h3>Nutrient-use efficiency</h3>
		<h4>Brian Forde - Lancaster Environment Centre</h4>
		<a href="#nutrient_use" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/nutrient_use.jpg" alt="iowa" width="220" height="98" /></a>
		<p>It is estimated that, globally, only 30-50% of the nitrogen fertilizer and 45% of the phosphorus fertilizer applied by farmers is taken up by crops. The resulting losses from the agricultural system not only represent enormous economic wastage, they also make a major contribution to greenhouse gas emissions and to the diffuse pollution of rivers and seas. We previously identified a gene (ANR1) that plays a major role in the regulation of root development and the aim of this project is to apply molecular genetic approaches to improve root architecture and nutrient-use efficiency in cereals.</p>
		<h4>Associated links</h4>
		<ul class="links">
			<li><a href="http://www.cab.zju.edu.cn/cabnx/faculty/ganyb/English.htm">Prof Yinbo Gan (Zhejiang University)</a></li>
		</ul>
		<h4>Recent papers:</h4>
		<ul class="links">
			<li><a href="http://www.ncbi.nlm.nih.gov/pubmed/19143987">Nitrate and glutamate as environmental cues for behavioural responses in plant roots.</a></li>
			<li><a href="http://www.ncbi.nlm.nih.gov/pubmed/18266918">Nitrate signalling mediated by the NRT1.1 nitrate transporter antagonises L-glutamate-induced changes in root architecture.</a></li>
			<li><a href="http://www.ncbi.nlm.nih.gov/pubmed/16816406">Evidence that L-glutamate can act as an exogenous signal to modulate root growth and branching in Arabidopsis thaliana.</a></li>
			<li><a href="http://www.pnas.org/content/103/50/19206.abstract">The Arabidopsis NRT1.1 transporter participates in the signalling pathway triggering root colonization of nitrate-rich patches </a></li>
		</ul>
	</div>
	
	<div class="clear">
		<a name="forero"></a>
		<h3>Working with peasant and Indigenous Peoples in Chile and Peru for improving management of natural resources (NR) and sustainable agro-forestry practices.</h3>
		<h4>Oscar Forero - Centre for Economic and Social Aspects of Genomics, Lancaster University</h4>
		<a href="#peru" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/peru.jpg" alt="peru" width="220" height="98" /></a>
		<h4>Peru</h4>
		<p>In coordination with Foundation Andes and the Potato Park we organised a series of events in Cusco- Peru to advance the agenda of developing best practice in research involving translation and archiving of traditional knowledge related to NR management and of agro-forestry practices. In coordination with the Peruvian Society for Environmental Rights we are developing new proposals to work in the NR management plan of the Vilcanota spiritual Park.</p>
		<a href="#chile" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/chile.jpg" alt="chile" width="220" height="98" /></a>
		<h4>Chile</h4>
		<p>We have worked together with the Mapuche - Pehuenche peoples in Chile developing a NR management plan of their traditional territory (60,000 hectares), much of which has been designated as Protected Area by the Chilean government as well. Through participatory action methodologies indigenous leaders have been trained to and then laboured in mapping the entire area of the Maichin river basin and a large part of the Trancura river basin as well. Specific projects for the management of the waters, soils-agriculture and forestry are integral to a NR plan sanctioned by community in a general assembly that was followed by ritual celebrations in accordance to Mapuche cultural and religious traditions. </p>
		<h4>Associated links</h4>
		<ul class="links">
			<li><a href="http://darwin.defra.gov.uk/project/15028/">Community Resource Management Planning in the Maichin River Valley</a></li>
		</ul>
	</div>
	
	<div class="clear">
		<a name="malik"></a>
		<h3>Freshwater monitoring techniques applied to case studies in Pakistan</h3>
		<h4>Riffat Malik - Lancaster Environment Centre</h4>
		<a href="#pakistan_1" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/pakistan_1.jpg" alt="pakistan" width="220" height="98" /></a>
		<p>Urban, agricultural and industrial activities have intensified water use and contribute to water pollution throughout the world. In recent years, degradation of rivers and streams in Pakistan has prompted the introduction of various systems to assess the health of freshwater ecosystems.</p>
		<a href="#pakistan_2" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/pakistan_2.jpg" alt="pakistan" width="220" height="98" /></a>
		<p>The focus of the research involves the use of an integrated approach based on water and sediment quality, and biological and physical characteristics to assess the ecological integrity of fresh water ecosystems.</p>
		<p>Monitoring of environmental pollution is of special concern. Persistent Organic Pollutants (POPs) have turned out to be a "particularly significant problem in Asia" and there are reports that Pakistan has stockpiles of POPs.</p>
		<a href="#pakistan_3" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/pakistan_3.jpg" alt="pakistan" width="220" height="98" /></a>
		<p>More recently, monitoring of POPs in fresh water ecosystems has been added as part of an ongoing research focus to assess their occurrence, spatial and temporal trends, and source identification. </p>
	</div>

	<div class="clear">
		<a name="jones"></a>
		<h3>Healthy soils for healthy food in China</h3>
		<h4>Kevin Jones - Lancaster Environment Centre</h4>
		<a href="#food_china" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/food_china.jpg" alt="Healthy food in China" width="220" height="98" /></a>
		<p>A key aspect of food security relates to environmental quality and health. Are soils contaminated, compromising the quality and yields of crops? Lancaster and its Chinese partners are investigating soil-crop transfers of heavy metals, nutrients and organic contaminants, focusing on methods to assess chemical bioavailability, and the significance of diffuse transfers from the re-use of biosolids and anaerobically digested organic wastes to agricultural land.  Water quality and its impacts on marine foodstuffs (aquaculture) is also a key part of research in China - seeking to assess the sources and impacts of organic contaminants such as antibiotics and oestrogens.</p>
		<h4>Associated links</h4>
		<ul class="links"><li><a href="http://www.lec.lancs.ac.uk/research/chemicals_management/international_collaborators.php">International Collaborators</a></li></ul>
	</div>
	
	<div class="clear">
		<a name="jones2"></a>
		<h3>A "soil up" approach to improving the quality of Chinese rice</h3>
		<h4>Kevin Jones - Lancaster Environment Centre</h4>
		<a href="#soilup1" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/dgt.jpg" alt="DGT" width="220" height="98" /></a>
		<p>Rice paddies, being intermediates between terrestrial and aquatic systems, exhibit distinctive and difficult to characterise biogeochemical signatures arising from periodic submergence and drainage events.</p>
		<a href="#soilup2" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/rice_field.jpg" alt="Rice Field" width="220" height="98" /></a>
		<p>By utilising DGT (diffusive gradients in thin-films), a holistic monitoring technique developed here at Lancaster, we have been able to take a fresh approach to understanding element solubility, rates of replenishment from the soil solid phase and bioavailability in Chinese rice paddy soils.</p>
		<a href="#soilup3" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/rice_field2.jpg" alt="Rice Field" width="220" height="98" /></a>
		<p>This research allows us not only to help tailor rice cultivation practices to bolster in planta levels of essential nutrients such as Zn, Fe and Se, but also to palliate the accumulation of As and Cd in grains.</p>
		<h4>Associated links</h4>
		<ul class="links"><li><a href="http://www.dgtresearch.com/">DGT Research</a></li></ul>
	</div>

	<div class="clear">
		<a name="browne"></a>
		<h3>Adaptation and Resilience in a Changing Climate: Water Resources in the United Kingdom</h3>
		<h4>Alison Browne - Lancaster Environment Centre</h4>
		<p>Lancaster University is working with a network of other leading UK universities and companies to assess the vulnerability of the south and south east of England to extreme events due to climate change. The ARCC (Adaptation and Resilience in a Changing Climate) - Water project will evaluate the vulnerability of current and projected UK water supply infrastructure systems to climate change uncertainties such as changing rainfall patterns, drought, and water demand, and suggest a range of more robust climate change adaptation alternatives. As part of this, Lancaster University is leading the development of a more comprehensive approach to water demand for the UK, to ensure that the forecasting of water demand accurately reflects the complexity and diversity of household water use, and identifies how cultural and sociotechnical changes may influence water use in the future.</p>
		<h4>Associated links</h4>
		<ul class="links">
			<li><a href="http://www.lec.lancs.ac.uk/research/research_news.php?article_id=883">Water Resources Management in a Changing Climate</a></li>
		</ul>
	</div>

	<div class="clear">
		<a name="jarvis"></a>
		<h3>Hydrology from Space</h3>
		<h4>Andrew Jarvis - Lancaster Environment Centre</h4>
		<a href="#saturation" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/saturation.jpg" alt="saturation from AMSR-E" width="220" height="98" /></a>
		<p>The spectre of increasing global surface temperatures mean our ability to both monitor and predict changes in the activity of the water cycle becomes critical if we are to develop the adaptive capability in agriculture needed to manage food production given this change. Satellites provide an attractive source of monitoring data providing what is being sensed can be translated into useful metrics for decision makers. Working in collaboration with the Indian Space Research Organisation, Dr. Andrew Jarvis and Dr Kaniska Mallick are developing methods to translate visible, infrared and microwave satellite retrievals into measurements of central components of the water cycle. These include rates of evaporation and surface moisture content, parameters that are critical to irrigation scheduling in India.</p>
		<p>Mallick K, Jarvis AJ, Wohlfahrt G, Kiely G, Hirano T, Miyata A. (2010) Components of near-surface energy balance derived from satellite soundings: ii. Latent heat flux, Atmospheric Chemistry and Physics Discussions (in press)</p>
	</div>

	<div class="clear">
		<a name="may"></a>
		<h3>The food system and intellectual property rights</h3>
		<h4>Chris May - Centre for Law and Society, Lancaster University</h4>
		<p>As industrial intervention in food production has moved from the organisational and managerial innovations to opportunities based on scientific manipulation of the genetic make-up of crops and livestock, so the issue of the ownership of intellectual property in such innovations has become an increasingly fraught political issue. From the terminator gene to the control of high-yield, disease resistant breeds of farm animal, farmers across the world have seen control of vital resources move from the farm to the boardroom.</p>
		<p>Christopher May's work has sought to uncover the political economy of IPRs and reveal the political processes behind seemingly technical legal changes in the legal regime that now underpins knowledge management in the food system. </p>
	</div>

	<div class="clear">
		<a name="whittle"></a>
		<h3>Exploring local and alternative food systems</h3>
		<h4>Rebecca Whittle - Lancaster Environment Centre</h4>
		<a href="#food_systems" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/food_systems.jpg" alt="Exploring local and alternative food systems" width="220" height="98" /></a>
		<p>Food security and sustainability are also important issues in developed world economies, such as the UK. Research conducted in LEC has been looking at the growth of alternative food economies - such as those involving local and organic foodstuffs, for example. This research has focused on social science aspects of these alternative food networks, such as the symbolic links that exist between food and place, the affordability of different food products and the different values (for example, economic, environmental, social, political) that such foods hold for producers and consumers throughout the food chain. </p>
		<h4>Associated links</h4>
		<ul class="links">
			<li><a href="http://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6VD9-4XBWW5V-1&_user=196517&_coverDate=04%2F30%2F2010&_rdoc=1&_fmt=high&_orig=search&_origin=search&_sort=d&_docanchor=&view=c&_searchStrId=1495101353&_rerunOrigin=scholar.google&_acct=C000013818&_version=1&_urlVersion=0&_userid=196517&md5=c06f07f7fdc32bd38d9689cf342b3d51&searchtype=a">Article from the Journal of Rural Studies</a></li>
		</ul>
		</div>

	<div class="clear">
		<a name="eglese"></a>
		<h3>Distribution systems</h3>
		<h4>Richard Eglese - Lancaster University Management School</h4>
		<p>Modelling and designing efficient and effective distribution systems for freight, including food is an area of expertise within Management Science. For example, past research has involved the design of a vehicle routing and scheduling system for a U.K. supermarket (Eglese et al. 2005).</p>
		<p>More recently participation in the EPSRC sponsored <a href=2http://www.greenlogistics.org/">Green Logistics</a> research consortium has led to further research into environmentally sustainable ways of distribution. In particular, at Lancaster we have been examining the use of traffic information to plan vehicle routes that avoid congestion and reduce greenhouse gas emissions (Eglese et al. 2006 and Maden et al. 2010). Current research includes evaluating further case studies involving food distribution from Spitalfields market in London and distribution for Booths supermarkets. Further research in this area is part of the research conducted within the EPSRC sponsored LANCS Initiative.</p>
		<h4>References</h4>
		<ul class="links">
			<li>Eglese R.W., Mercer A. and Sohrabi B. (2005) The grocery superstore vehicle scheduling problem. J. Opl Res. Soc. Vol. 56, pp 902-911.</li>
			<li>Eglese R.W., Maden W. and Slater A. (2006) A Road Timetable to aid vehicle routing and scheduling. Computers & OR. Vol. 33, pp 3508-3519.</li>
			<li>Maden W., Eglese R. and Black D. (2010) Vehicle routing and scheduling with time-varying data: A case study. Journal of the Operational Research Society, Vol. 61(3), pp 515-522.</li>
		</ul>
	</div>

	<div class="clear">
		<a name="twine"></a>
		<h3>Molecular breeding techniques within the livestock industry</h3>
		<h4>Richard Twine - Centre for Economic and Social Aspects of Genomics, Lancaster University</h4>
		<p>My research interest focuses on the development of molecular breeding techniques within the livestock industry.  In my book Animals as Biotechnology - Ethics, Sustainability and Critical Animal Studies (Earthscan, 2010) I show that molecular techniques are being turned to as potential strategies for dealing with various social crises of meat and dairy production referring in the main to public health, ecology and animal welfare.</p>
		<p>Focusing in the main on the climate change impact of meat and dairy production and drawing upon Tim Jackson's distinction between relative and absolute decoupling I argue that such framings of sustainability effectively reduced to efficiency will be overridden by overall forecasted growth in production and consumption.  My research interests continue to map the uptake of molecular breeding techniques by livestock genetics companies but also are now beginning to explore sociological dimensions of changing dominant eating habits. </p>
		<h4>Associated links</h4>
		<ul class="links">
			<li><a href="http://www.richardtwine.com">www.richardtwine.com</a></li>
		</ul>
	</div>

	<div class="clear">
		<a name="mcainsh"></a>
		<h3>Predicting the effects of environmental change on crops and crop production</h3>
		<h4>Martin R McAinsh - Lancaster Environment Centre</h4>
		<a href="#environmental_change" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/environmental_change.jpg" alt="Predicting the effects of environmental change on crops and crop production" width="220" height="98" /></a>
		<p>Shortage of rainfall and other sources of water for irrigation of farmland pose a serious constraint on agricultural productivity. It should however be possible to reduce this through a better understanding of the way in which crops manage their water relations. We already have a good understanding of the mechanisms underlying stomatal regulation in non-crop plants.</p>
		<p>Our current research aims to translate this general understanding into quantified morphological, physiological and biochemical traits attributed to distinct crop groups in order to accurately predict the impacts of climate change on agricultural productivity. This research will enable the refinement of current models predicting the effects of environmental change on crop production and contribute to the mitigation of these effects through the generation of crop cultivars adapted to future climate conditions.</p>
	</div>

	<div class="clear">
		<a name="aller"></a>
		<h3>Sustainable biochar production and use in soil to increase crop production and mitigate climate change</h3>
		<h4>Maria-Fernanda Aller - Lancaster Environment Centre</h4>
		<a href="#biochar" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/biochar.jpg" alt="Biochar" width="220" height="98" /></a>
		<p>Agricultural waste production and disposal has been considered a source of environmental contamination. There are now several different alternatives for reducing negative contaminant effects, such as anaerobic treatment, whilst other contaminants can actually be used for energy production.  Biochar is a carbon rich by-product generated when biomass is heated in the absence of oxygen, in a process called thermal treatment.  Biochar production from agricultural biomass could have a double positive effect in the environment by reducing the contaminant impact of agriculture, but some studies have also suggested that storage of biochar in soils can mitigate climate change by sequestering carbon in the soils at the same time as improving crop performance.</p>
	</div>

	<div class="clear">
		<a name="pickup"></a>
		<h3>Food security and human health</h3>
		<h4>Roger Pickup - School of Health &amp; Medicine, Lancaster University</h4>
		<a href="#human_health" rel="facebox"><img class="noborder" src="<?php echo $base; ?>images/food_security/human_health.jpg" alt="human health" width="220" height="98" /></a>
		<p>Current and future food production methods potentially introduce microbial pathogens into the food chain with subsequent impacts on human health.  Water, in particular, may have a significant influence as it is a medium where pathogens persist, evolve and are transported yet it is impacted by land use and agricultural practices at a local, catchment and nation scale.</p>
		<p>Lancaster researchers have expertise in assessing the potential pathogenic impact of microbial pathogens, particularly those that are classed as zoonotic, on human health. Through links with both national and international groups, we focus research on 'Environment and human health' but in particular non-tubercular mycobacteria and the link between environment and human health, disease management and role of environment in the emergence and spread of antibiotic resistance.</p>
	</div>

	<div class="clear">
		<a name="saunders"></a>
		<h3>The Living Classroom School Farms in the UK: a mapping survey</h3>
		<h4>Murray Saunders - Dept of Educational Research, Lancaster University</h4>
		<p>This is a collaborative inquiry undertaken by a team from the Centre for the Study of Education and Training in the Educational Research Department, Lancaster University and the School Farms Network.  While focusing specifically on the educational and social benefits of school farms, the issues it addresses concerning food sources, healthy eating and sensitising young people to food security and sustainability are also of wider relevance. </p>
		<p>The evaluative research is focused on the practices associated with farms that are based within, or associated with school spaces.  This is the preliminary stage of a larger comparative project with potential partners in South Africa, Tanzania and Kenya. We argue that several factors have converged to explain this resurgence and will form the basis of some overarching propositions to be explored in the research:</p>
		<ul class="links">
			<li>There is a worldwide interest in sustainable futures in food production. This is in the context of both long term concerns about the distribution of food resources globally and, more recently, in the way climate change might influence how and where food is produced.  These concerns have been brought together under the generic term 'food security'</li>
			<li>There is increasing understanding and interest in the way in which working in 'practice clusters' associated with wider communities (farming, food producers, other working environments) enrich and embed learning effectively in comparison with solely 'text based' or 'de-contextualized' learning in classrooms. </li>
			<li>There is an interest in healthy eating (Healthy Schools) as part of a brief to encourage broadly, more healthy lifestyles.  </li>
			<li>The emerging practices of integrating or embedding social and personal development within 'general learning' processes rather than as a separate category of study, is in line with the support for emotional and social development gains often associated with working and learning with plants and animals.</li>
			<li>Introduction and development of a cadre of young knowledge workers associated with relevant disciplines</li>
		</ul>
	</div>

</div> <!-- end item -->

<?php
//----------------------------------------------------------
include "fst/universal/jquery_forms.php";
include "fst/universal/jquery_facebox.php";
include "fst/food-security/footer.php";
?>