////////////////////////////////////////////////////////////////////////////////////////
// class CDBFFile
#include "stdafx.h"
#include "dbffld.h"
#include "dbfhead.h"
#include "cdbffile.h"
#include "\geophys\utilclas\general.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  
IMPLEMENT_DYNCREATE(CDBFFile,CDBFHead)           
#define new DEBUG_NEW
// constructor, destructor
CDBFFile::CDBFFile(CFile *file)
{  // the CFile object should be opened when passed to this constructor
InitialiseDBFFile(file);
}  
CDBFFile::CDBFFile(CFile *file, CDBFHead& head)
{ // used for opening empty files. File structure should be
// contained in head
 // the CFile object should be opened when passed to this constructor
Duplicate(head);  // copies details of header into this object
WriteDBFHead(file);// writes the header details
// must create space for record when first initialse this object
recptr= new DBFRECORD [ GetRecLength()+1];
memset(recptr, 0, GetRecLength() +1);
m_DataWrite=FALSE; 
m_lfirstrec= GetFirstRecOff();
m_llastrec=GetLastRecOff();
m_lfoffset=-1;
m_file=file;
} 
CDBFFile::CDBFFile()
{  
m_InitFailure=FALSE;
recptr=NULL;
 }   

CDBFFile::~CDBFFile()
{ // clear up the allocated memory
UpdateRecord(); // write any previous modified record to file
// write terminating characters
 recptr[0]=0x1a;
TRY
	{// write out 2 bytes indicating number of records
	if( m_DataWrite) m_file->Write( recptr,1);
	}
	CATCH(CFileException, e)
	{
	DisplayCFileErr(e->m_cause,ERR_BOX);// displaye message to user
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
	if(recptr !=NULL) delete [] recptr; 
	AfxThrowUserException();return;
	}
	END_CATCH
if(recptr !=NULL) delete [] recptr; 
} 

void CDBFFile::InitialiseDBFFile(CFile *file)
{
m_file=file;
// decode the header info from the file  
TRY
	 {
	if(ReadDBFHead(file) == FALSE)
		{ // error in converting header 
		m_InitFailure=TRUE;
		}  
		else
		{     // appears to be ok
		m_InitFailure=FALSE;
		#ifdef _DEBUG
			 CDBFHead::AssertValid();              // make sure CDBFHEad thinks it ok
	 	#endif
	 	}
	}
	CATCH(CUserException,e)
		{    // already displayed a message
		TRACE0(" User exception detected by CDBFFile::Initailise\n");
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		THROW_LAST();
		}
		AND_CATCH(CFileException,e)
		{// we let possible recover from this exception occur
		DisplayCFileErr(e->m_cause,ERR_BOX);// displaye message to user
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		}
		AND_CATCH(CMemoryException, me)
		{
		TRACE0(" memory exception detected by CDBFFile\n");
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		THROW_LAST();
		}
		AND_CATCH(CException, e)
		{
		AfxMessageBox(" Unexpected memory exception detected by CDBFFile\n");
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		THROW_LAST();
	}
	END_CATCH
if(m_InitFailure) // only makes it here if ok or recoverable error
	{ AfxThrowUserException();return;}
// all ok ,so create the buffer for the record 
TRY {recptr= new DBFRECORD [ GetRecLength()+1]; }
CATCH(CMemoryException,e)
	{
	TRACE0("Out of memory in CDBFFile::InitialiseDBFFile\n");
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
	THROW_LAST();
	}
	END_CATCH
ASSERT(recptr !=NULL); 
// now calc the record offsets for this file
m_lfirstrec= GetFirstRecOff();
m_llastrec=GetLastRecOff();
m_DataWrite=FALSE;
TRY
	{Goto(1);} // read in first record
	CATCH(CUserException,e)
	{
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		delete []recptr;
		THROW_LAST();
	}
	AND_CATCH(CFileException,e)
	{
	TRACE0(" InitialiseDBFHead- detected exception from Goto\n");
		DisplayCFileErr(e->m_cause,ERR_BOX);// displaye message to user
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
		EraseFlds(); //make sure empty
		m_InitFailure=TRUE;
		delete []recptr;
		THROW_LAST();
	}
	END_CATCH
#ifdef _DEBUG
	AssertValid();
#endif
}
//++++++++++++++++++++++++++++++++++++++++++++++++
// the following routines do the reading and writing to the record
/* the m_lfoffset value is where the current record starts in the file
which is that one recorded in the buffer, upon any movement to another
record poiner the buffer is always read in, and check is made first
 to see if any values have been written to the record, if so then this is outiput
 to the dbf file before movement
 */
///-------------------------------------------- 
 UINT CDBFFile::Goto(UINT recno)
 { /* repositions the record pointer,
  RETURNS recno if ok
  		 if error,throw a CFileException  : for reading/writing error
  		 							CUserException: invalid record no
  */
if(recno <=0 && recno > (UINT) GetNumRecords() )
 	{
		TRACE0(" Out of range Record number supplied to CDBFFile::Goto");
		AfxThrowUserException();
	}
#ifdef _DEBUG
	CMemoryState oldstate,newstate, diff;
	oldstate.Checkpoint();
#endif
UpdateRecord(); 
m_lfoffset=GetOffset(recno);// calc the new offset
ASSERT(m_lfoffset <=m_llastrec);
 // reposition to the new record
m_file->Seek( m_lfoffset,CFile::begin);
 // read the record at this position
ASSERT(recptr !=NULL);
m_file->Read( recptr, GetRecLength()); 
#ifdef _DEBUG
	newstate.Checkpoint(); //check the memory state
	if(diff.Difference(oldstate,newstate))
		{
		TRACE("memory leak ! in SaveFld\n");
		diff.DumpStatistics();
		AfxThrowMemoryException();
		}
#endif
return recno;
} 
void CDBFFile::UpdateRecord(void)
{    // copies any unsaved record to file
if(! m_DataWrite) return;
 // write, the current buffer (if altered)
ASSERT(recptr !=NULL);
ASSERT(m_file->IsKindOf(RUNTIME_CLASS(CFile)));
recptr[GetRecLength()]=0x20;// terminating space to record
TRY
	{
	m_file->Seek(m_lfoffset, CFile::begin);
	m_file->Write( recptr,GetRecLength()+1);
	}
	CATCH(CFileException, e)
	{
	DisplayCFileErr(e->m_cause,ERR_BOX);// displaye message to user
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
	AfxThrowUserException();return;
	}
	END_CATCH
m_DataWrite=FALSE;
}
UINT CDBFFile::AppendRecord(void)
{// adds a new blank record to the file
// returns the number of the record added
#ifdef _DEBUG
	CMemoryState oldstate,newstate, diff;
	oldstate.Checkpoint();
#endif
UpdateRecord(); // write any previous modified record to file
ASSERT(recptr !=NULL);
memset(recptr, 0, GetRecLength());// set to zero
// now write to the file
m_lfoffset=GetOffset( (UINT) GetNumRecords()+1);// new last record
m_DataWrite=TRUE;
UpdateRecord();	
m_NumRecords++;
//ASSERT(m_lfoffset == GetLastRecOff());
m_llastrec=GetLastRecOff();
// now put the number of record into file
DBFRECORD *bptr=new DBFRECORD[4];
ldiv_t nl=ldiv(m_NumRecords, 256);
bptr[0]=(BYTE) nl.rem; bptr[1]=(BYTE) nl.quot; // number of records
TRY
	{// write out 2 bytes indicating number of records
	m_file->Seek(4, CFile::begin);
	m_file->Write( bptr,2);
	}
	CATCH(CFileException, e)
	{
	DisplayCFileErr(e->m_cause,ERR_BOX);// displaye message to user
		#ifdef _DEBUG
			Dump(afxDump);// dump details
		#endif
	AfxThrowUserException();return(0);
	}
	END_CATCH
delete [] bptr;
#ifdef _DEBUG
	newstate.Checkpoint(); //check the memory state
	if(diff.Difference(oldstate,newstate))
		{
		TRACE("memory leak ! in AppendRecord\n");
		diff.DumpStatistics();
		AfxThrowMemoryException();
		}
#endif
return ((UINT) m_NumRecords);
}
//++++++++++++++++++++++++++++++++++++++++++++++++  
// following routines retrieve the values from the record  
CString CDBFFile::GetStoredValue(const char *FldName)
{
CDBFFld *fld=GetFldPtr(FldName);
return fld->LoadFld(recptr);
}

CString CDBFFile::GetField(const char * FldName)  
{ // converter for a character field   
CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type 
ASSERT( fld->GetFldType() == CHAR_FIELD );
return fld->GetFldValue(recptr);
}

double CDBFFile::GetField(const char * FldName, double *val)   
{ // converts for a numeric field
CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type
ASSERT( fld->GetFldType() == NUM_FIELD );
fld->GetFldValue(recptr,val);
return *val;
}
float CDBFFile::GetField(const char * FldName, float *val)   
{ // converts for a numeric field
double dval=(double) *val;
*val=(float) GetField(FldName, &dval);
return *val;
}

 int CDBFFile::GetField(const char *FldName, int *val)  
{ // converts for an integer field
// check that is correct fld type
CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type
ASSERT( fld->GetFldType() == INT_FIELD );
fld->GetFldValue(recptr,val); 
return *val;
} 
 //+++++++++++++++++++++++++++++++++++++++++++++++++++++++
 // the following rouitines write values to the fields in the record
 BOOL CDBFFile::UpDateFld (const char * FldName, const char *pszchar)
 {  
 CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type
if( fld->GetFldType() != CHAR_FIELD )
	{
	 TRACE2("Wrong 2nd Parameter Supplied to UpDateFld: Fld=%s, char par=%s\n",FldName, pszchar);
	return(FALSE);
	}
fld->PutFldValue(recptr,pszchar);   
m_DataWrite=TRUE;
return(TRUE);
}

BOOL CDBFFile::UpDateFld (const char * FldName, double val)
 {
CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type
if ( fld->GetFldType() != NUM_FIELD )
	{
	 TRACE2("Wrong 2nd Parameter Supplied to UpDateFld: Fld=%s, num par=%f\n",FldName, val);
	return(FALSE);
	}
fld->PutFldValue(recptr, val);   
m_DataWrite=TRUE;
return(TRUE);
} 
BOOL CDBFFile::UpDateFld (const char * FldName, float val)
 {
 double dval=val;
 return(UpDateFld(FldName, dval));
 }

BOOL CDBFFile::UpDateFld (const char * FldName, int val)
 {
 long int lval=val;
 return(UpDateFld(FldName, lval));
 } 
 
 BOOL CDBFFile::UpDateFld (const char * FldName, long int val)
 {
CDBFFld *fld=GetFldPtr(FldName);
// check that is correct fld type
if( fld->GetFldType() != INT_FIELD )
	{
	 TRACE2("Wrong 2nd Parameter Supplied to UpDateFld: Fld=%s, int par=%d\n",FldName, val);
	return(FALSE);
	}
fld->PutFldValue(recptr, val);   
m_DataWrite=TRUE;
return(TRUE);
}
//++++++++++++++++++++++++++++++++++++++++++
UINT CDBFFile::GetFldType(const char   *FldName) const
{
CDBFFld *fld=GetFldPtr(FldName);
return fld->GetFldType();
}

#ifdef _DEBUG
void CDBFFile :: AssertValid()  const
{
	CDBFHead::AssertValid(); // call inherited assertvalid
	ASSERT(m_InitFailure == FALSE);
	ASSERT(m_lfirstrec >0 && m_llastrec >=m_lfirstrec);
	ASSERT(recptr !=NULL);
	DWORD i=m_file->GetLength();
	ASSERT(m_llastrec <m_file->GetLength());
}
void CDBFFile:: Dump(CDumpContext& dc)  const
{
	CDBFHead::Dump(dc);

	dc <<"m_lfirstrec= " << m_lfirstrec <<"\n"
	<<" m_llastrec= "<< m_llastrec<<"\n"
	<< " m_lfoffset= "<<m_lfoffset<<"\n";
	CString str=(char *)recptr;
	dc<<"record= "<<str<<"\n";
}
#endif
         