  class CDBFFile : public CDBFHead
// is the object that manages the information of the  dbf file
// this class is derived from CDBFHead so has access to its member funtions
// 
{
DECLARE_DYNCREATE(CDBFFile)

private:
	size_t m_lfirstrec; // offset into file of first record
	size_t m_llastrec; // the offset into file of last record
	size_t m_lfoffset; // the current offset into the file of start
	DBFRECORD  *recptr; // pointer to the buffer which contains the record
	CFile *m_file;// ptr to CFile (file operated on) 
	BOOL m_DataWrite; // is TRUE if record needs writing into file    
	BOOL m_InitFailure;  // true if failed to read property       
	
public: 
	CDBFFile();
	CDBFFile(CFile *file); // constructor for the CDBFfile object-passed open file   
	CDBFFile(CFile *file, CDBFHead& head); // when initiliasing a new file
	~CDBFFile();
	void InitialiseDBFFile(CFile *file);
	 
	CString GetStoredValue(const char *FldName);// returns string directly from dbffile
	// returns  character fld
	CString GetField(const char *FldName);
	// retuns ptr to float fld
	double GetField(const char *FldName, double *val);
	float GetField(const char *FldName, float *val);
	// retuns ptr to integer fld
	int GetField(const char *FldName, int *val);
	
	 // replaces character variable in fld with newvalue
	BOOL UpDateFld(const char *FldName, const char *pszchar);
	 // replaces numeric variable in fld with val
	BOOL UpDateFld(const char *FldName, double val);
	BOOL UpDateFld(const char *FldName, float val);
	// replaces integer variable infld with val
	BOOL UpDateFld(const char *FldName, int val); 
	BOOL UpDateFld(const char *FldName, long int val); 
// to do with location repositioning position in file
	UINT AppendRecord(); // adds a new blank record at end of file
	UINT Goto(UINT recno); // goes to recno in file, returns this rec no
	UINT Locate(const char *FldName, const char *pzchar ); // locates rec matching characters
	UINT Locate(const char *FldName, double num);// locates rec matching number
	UINT Locate(const char *FldName, int inum ); // locates rec matching integer     
	
	UINT GetFldType(const char *FldName) const;
	protected:
	size_t GetOffset(UINT recno) {// calc the offset into file of record
			return( m_lfirstrec+(recno-1)*GetRecLength());};
	void UpdateRecord();// writes any altered record to file
	public:
	
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
};

