#include "stdafx.h"
//#include "exam1.h"  
#include "dbffld.h" 
#include "\geophys\utilclas\general.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  
IMPLEMENT_DYNCREATE(CDBFFld, CObject) 
#define new DEBUG_NEW
///////////////////////////////////////////////////////////////////////////////
CDBFFld::CDBFFld()
{}

CDBFFld::CDBFFld( size_t fwidth,UINT DecPlaces,UINT type, size_t offset)
{ // construction through this routine
m_FldWidth=fwidth;
m_boffset=offset; 
m_FldType=type;
m_DecPlaces=DecPlaces; 
#ifdef _DEBUG
		if(type == CHAR_FIELD && DecPlaces !=0) ASSERT(FALSE);
		if(type == INT_FIELD && DecPlaces !=0) ASSERT(FALSE);
#endif
}  

CString CDBFFld::LoadFld(DBFRECORD *rec) const
{  
ASSERT(rec !=NULL);
CString buf; 
char* str=buf.GetBuffer(m_FldWidth+2);
ASSERT(m_boffset >=0);
memcpy(str, rec+m_boffset ,m_FldWidth);
buf.ReleaseBuffer(m_FldWidth); 
return  buf;  
}

 BOOL CDBFFld::SaveFld(DBFRECORD *rec, const char *pszval, const int pad)  
 { // put the string in str into the field at the offset
// copy string into the record, padding to left if a numeric
 // and padding to right if a character field
ASSERT(rec !=NULL);
ASSERT( pad == PAD_LEFT || pad == PAD_RIGHT);
CString str=pszval;                                          
CString final;
int npadding=m_FldWidth- str.GetLength();
if( npadding <=0)
	{// ie too long for field
	final=str.Left(m_FldWidth);
	npadding=0;
	}
	else
	{  // string is short, so pad it 
		CString strpad;
		char* buf=strpad.GetBuffer(npadding);
		memset(buf,32, npadding); // set to space
		strpad.ReleaseBuffer(); // blank space buffer is now made
 		if(pad == PAD_LEFT)		final=strpad+str;
 		else	 // pad right (ie strings)
 		 final=str+strpad;
	}
ASSERT(final.GetLength() == (int) m_FldWidth);  
// now copy the string into the record
 memcpy(rec+m_boffset,final,m_FldWidth); 
 return TRUE;
 }
//-------------------------------------------------------------------------------------------
CString CDBFFld::ConvertValue( double val)
{     // converts double val into string
 	CString numbuf; 
 	char *str=numbuf.GetBuffer(33);
 	if(  ftoadS(val,str,m_DecPlaces ) > 0) 
 			{ TRACE0( " Unable to convert number to ascii : in CNUmFld:PutFldValue ");
 			AfxThrowUserException();
 			}
	TrimTails(str);// remove spaces
 	// number is right justified in field
	numbuf.ReleaseBuffer();
	// catch case when value is -0.0
	int pos=numbuf.Find("-0.0");
	if(pos !=-1)
		// found it so remove it
		numbuf=numbuf.Right(numbuf.GetLength()-1);
 	 return numbuf; 
 }  
 //-----------------------------------------------------------------------------------------
CString CDBFFld::ConvertValue( const  long int val)
{     // converts integer into string
 	CString numbuf;
 	char *str=numbuf.GetBuffer(17);
 	ltoa(val,str,10);   
 	// number is right justified in field 
  	numbuf.ReleaseBuffer();
 	 return numbuf; 
 }
