// readdbf.h interface                                      
/* this header defines the structures and classses associated with the 
CLASS CDBFFile which is the gateway to a dbf file
This class performs all access to the DBF file with appropriate member funtions
which can interogate the dbf file, read /write data to the dbf file
and open and close the dbf file

At any one time the only data which is stored is the a) header information
b) the current record and c) a pointer to the current record in the file
*/
// error codes returned by routines
#define	INVALID_FIELD_NAME		-100 
#define CHAR_FIELD			0x43
#define INT_FIELD				0x49
#define NUM_FIELD			0x4E
#define PAD_LEFT	-1
#define PAD_RIGHT	-2

typedef BYTE  DBFRECORD;             
class CDBFFile; // forward delarartion
////////////////////////////////////////////////////////////////////////
class CDBFFld: public CObject
{ // the base class for the field
DECLARE_DYNCREATE(CDBFFld)
public:
	CDBFFld();
	CDBFFld(size_t fwidth,UINT decplaces,UINT type, size_t offset); // constructor  
// retrieving field attributes
	UINT GetFldDecimal() const {return m_DecPlaces;};
	size_t GetFldWidth() const {return m_FldWidth;}; 
	UINT GetFldType() const { return m_FldType;};
// functions to do with retrieving value from record
	CString GetFldValue(DBFRECORD *rec)  // load string
				{return LoadFld(rec);};
	void GetFldValue( DBFRECORD *rec, double *val)  // load double
				{double lval=ConvertStr2Doub(LoadFld(rec)); *val=lval;};
	void GetFldValue( DBFRECORD *rec, int *val)   // load int
				{int lval=ConvertStr2Int(LoadFld(rec)); *val=lval;}; 
// functions to do with puting new values into record	
	void PutFldValue( DBFRECORD *rec, const char *val) // save string
				{SaveFld(rec,val,PAD_RIGHT);};
	void PutFldValue( DBFRECORD *rec, const double val)  // save float numeric
				{SaveFld(rec,ConvertValue(val), PAD_LEFT);};
	void PutFldValue( DBFRECORD *rec, const long int val)
				{SaveFld(rec,ConvertValue(val),PAD_LEFT);}; 
private:
	int ConvertStr2Int(const char *str) const          // converts to integer
				{  	ASSERT(str !=NULL); return atoi(str);};
	CString ConvertValue(const long int val); // convert value to string
	double ConvertStr2Doub(const char *str) const	// convert to double
					{ASSERT(str !=NULL);return atof(str);}; 
	CString ConvertValue( double val);  // converts val into string form

friend CDBFFile;
protected:
	CString LoadFld(DBFRECORD *rec) const; // returns the null terminated field string
	BOOL SaveFld(DBFRECORD *rec, const char* str,const int pad);// puts values into field
private:
	UINT m_FldType;
	UINT m_DecPlaces;
	size_t m_FldWidth;// the field width in bytes
	size_t m_boffset	;// the offset into record of start of field
};
	