/////////////////////////////////////////////////////////////////////////////////////////
//++++++++++++++++++++++++++++++++++++++++++++++++
// class CHeadDBF stores the info about the dbf header etc   
// Returns FALSE if an error occurs    
#include "stdafx.h"
//#include "exam1.h" 
#include "dbffld.h" 
#include "dbfhead.h" 
#include "\geophys\utilclas\general.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  
IMPLEMENT_DYNCREATE(CDBFHead,CObject)
#define new DEBUG_NEW

CDBFHead::CDBFHead()
{ 
 	m_RecLength=0; // we set values to zero so clearly no data
	m_NumFlds=0;
	m_NumRecords=0;
	m_NewOffset=0;
	CurrentDate(m_Date.GetBuffer(50));// set the date
	m_Date.ReleaseBuffer();
}
CDBFHead::~CDBFHead()
{ 
EraseFlds();                                                       
 }
void CDBFHead::EraseFlds(void)
{   // erase the objects stored in the map and clears the map of string keys
CObject *fld;
CString str;
for (POSITION pos=m_Flds.GetStartPosition(); pos !=NULL;)
	{
	m_Flds.GetNextAssoc(pos,str,fld);
	delete (CDBFFld *) fld;
	}
m_Flds.RemoveAll();  
	m_RecLength=0; // we set values to zero so clearly no data
	m_NumFlds=0;
	m_NumRecords=0;
	m_NewOffset=0;
}
BOOL CDBFHead::WriteDBFHead(CFile *file)
{// this writes a complete new dbf header to the start of the file
// it makes no check for overwriting the records which may be contained within it
// this should be done elsewhere
 DBFRECORD  *bptr ;
 TRY
   		{// alocate the memory to hold each block
		bptr = new DBFRECORD[sizeof(DBFRECORD) *BLK_SIZE];
		}
		CATCH(CMemoryException, e)
		{
		TRACE0("out of memory in WriteDBFHead\n");
		THROW_LAST();
		}
END_CATCH
ASSERT(bptr !=NULL);
memset(bptr, 0, BLK_SIZE);
// the first header block
int num;
bptr[0]=0x03;// dbase 3
num=atoi(m_Date.Right(2));bptr[1]=(BYTE) num;// the year
num=atoi(m_Date.Mid(3,2));bptr[2]=(BYTE) num;// month
num=atoi(m_Date.Left(2));bptr[3]=(BYTE) num;// day
ldiv_t nl=ldiv(m_NumRecords, 256);
bptr[4]=(BYTE) nl.rem; bptr[5]=(BYTE) nl.quot; // number of records
nl=ldiv(GetHeadEnd(), 256);
bptr[8]=(BYTE) nl.rem;bptr[9]=(BYTE) nl.quot;// the header end offset
nl=ldiv(m_RecLength, 256);
bptr[0x0a]=(BYTE) nl.rem;bptr[0x0b]=(BYTE) nl.quot;// the length of record in bytes
// now do the writing
file->SeekToBegin();
file->Write(bptr,BLK_SIZE);
// now the rest of header, each field block at a time
CString fldname;
CDBFFld *fld;
for(UINT i=0; i<m_NumFlds; i++)
	{
	memset(bptr, 0, BLK_SIZE);
	fld=GetFldPtr(i);// get field object
	fldname=id2FldName(i);// the field name
	memcpy(bptr,fldname, fldname.GetLength()); // copy field name
	bptr[0x10]=(BYTE) fld->GetFldWidth();
	bptr[0x11]=(BYTE) fld->GetFldDecimal();
	if( fld->GetFldType() == INT_FIELD || fld->GetFldType() == NUM_FIELD) 
		bptr[0x0b]=(BYTE) NUM_FIELD;
		else
		bptr[0x0b]=(BYTE) fld->GetFldType();
	bptr[0x0e]=(BYTE) 0x24;// unknown 2 bytes
	bptr[0x0f]=(BYTE) 0x46;
	file->Write(bptr, BLK_SIZE);// write it out
	}
bptr[0]=0x0d; bptr[1]=0x20;file->Write(bptr, 2);// write out terminating 0D 
//file->Flush();
delete [] bptr;
return (TRUE);
}                
//-------------------------------------------------------------------------
BOOL CDBFHead::ReadDBFHead(CFile *file)
/* This reads the header details on the dbf, and constructs CDBFFld 's to
 hold the field details
returns: TRUE if read in ok
throws user exceptions if an error occurs, if a CFileexception, or a memory exception
		no message is printed
		UserException: message has been displayed to the screen
*/
{
 	
	ASSERT(file->GetLength() >0);
   	DBFRECORD  *bptr ;
	CDBFHead* dummy=new CDBFHead;//do not want this object to contain info to create a new one which contains the info from header
 	/* Allocate memory for  bytes of header blocks 	 - memory exception
   	may be thrown*/
   	TRY
   		{
		bptr = new DBFRECORD[sizeof(DBFRECORD) *BLK_SIZE];
		}
		CATCH(CMemoryException, e)
		{
		TRACE0("out of memory in ReadDBFHead\n");
		THROW_LAST();
		}
	END_CATCH
	ASSERT(bptr != NULL);
	/*    Go read the bytes BLK_SIZE at a time*/
	TRY
		{file->SeekToBegin();}
	CATCH(CFileException,e)
		{
		delete []bptr;
		DisplayCFileErr(e->m_cause, ERR_BOX);
		THROW_LAST();
		}
		END_CATCH
	TRY
		{
		if (file->Read(bptr, BLK_SIZE) != BLK_SIZE )
			{   
	/* only gets here if reached the end of the end of the header without reading data*/
			AfxMessageBox("Truncated DBF Header found \n");
			delete [] bptr;
			AfxThrowUserException();
			return FALSE;
			} 
		}
	CATCH(CFileException, e)
		{
		TRACE0("Error in readinf fisrt dbf header block\n");
		DisplayCFileErr(e->m_cause, ERR_BOX);
		delete []bptr;
		THROW_LAST();
		}
		END_CATCH
     // makes sure header is dbf header and converts
   	size_t reclength;// use these for checking internal working
     TRY
     		{	
     		dummy->ConvertNumRecords(bptr);			
     		reclength=dummy->m_RecLength;
     		}
			CATCH(CUserException,e)
			{ delete []bptr; // a possible user exception
			TRACE0("Exception detected in CDBFHead::ReadDBFHead()\n");
			THROW_LAST();
			}
			END_CATCH
	// goto start of field names
	TRY {file->Seek(BLK_SIZE,CFile::begin);}
	CATCH(CFileException,e)
		{
		delete []bptr;
		DisplayCFileErr(e->m_cause, ERR_BOX);
		THROW_LAST();
		}
		END_CATCH
	// now get the information about each field
     char fldname[MAX_FLD_LEN+1];
     UINT fieldwidth,dec,fldtype;                            
     m_NewOffset=0; // initialise the offset pointer to field position
//   TRACE0("ReadDBFHead: Starting to read Field Names\n"); 
	for(UINT k=0; k<dummy->m_NumFlds; k++)
		{
		TRY
			{
			if (file->Read( bptr, BLK_SIZE) != BLK_SIZE )
				{// error in reading
				AfxMessageBox(" Error in Reading  DBF header block");
				delete [] bptr;   
				EraseFlds();
				AfxThrowUserException();;
				}
			}
		CATCH(CFileException, e)
			{
			delete []bptr;
			EraseFlds();
			DisplayCFileErr(e->m_cause, ERR_BOX);
 			THROW_LAST();
			}
		END_CATCH
	      // copy the field name into local buffer
		memcpy(fldname, bptr,MAX_FLD_LEN);
	     ASSERT(fldname[0] !='\x20'); // first character should not be space
	      // now add null after last character
	      for(int i=MAX_FLD_LEN-1; i>=0; i--)
			if(fldname[i] !='\x20') { fldname[i+1]='\x0';break;}
	      fieldwidth=(UINT) *(bptr+0x10);    // now the field widths etc
	      dec=(UINT) *(bptr+0x11);// now the places of decimals
	     fldtype=*(bptr+0x0B); // now the field type 
	     TRACE1("ReadDBFHead: FieldName=%s, ",fldname);
	     TRACE1("FieldWidth=%d, ",fieldwidth);
	     TRACE1("Decimnal places=%d",   dec);
	     TRY
	    	{   
			AddField(fldtype, fldname, fieldwidth, dec);
			}
     		CATCH(CUserException,e)
     		{// exception trhown by CDBFFld-or addfield internal error
			delete[]  bptr; 
			EraseFlds(); // clean up allocated mem
     		THROW_LAST();
     		}	
     		AND_CATCH(CMemoryException, e)
     		{
     		delete[]  bptr; 
 			EraseFlds(); // clean up allocated mem
     		THROW_LAST();
     		}
		END_CATCH
	     }  //end of for loop
ASSERT(reclength == m_RecLength);	     
delete[]  bptr; 
m_NumRecords=dummy->m_NumRecords;
delete dummy;
TRACE0("ReadDBFHead: Sucess in reading in header details\n");
return TRUE;   
}   

void CDBFHead::AddField(UINT fldtype, const char* fldname, 
				UINT fieldwidth, UINT dec)
{ // adds a new field to the header block, 
ASSERT(m_NumRecords ==0); // only currently do if empty
if( strlen(fldname) > MAX_FLD_LEN)  // check is not larger than req
	{
	TRACE1(" Maximum field name length excedded in AddField: Name=%s\n",fldname);
	AfxThrowUserException();
	}
CDBFFld *fld; 
 switch  (fldtype) 
  		{
   		case CHAR_FIELD: // character   
   		TRACE1(" Char field type, name=%s\n", fldname);
   		 fld=  new CDBFFld(fieldwidth,dec,CHAR_FIELD,m_NewOffset);
   		 break;
   		case NUM_FIELD: // number
   		TRACE1("  Num field type, name=%s\n", fldname);
   		ASSERT(dec >=0);
     	 if(dec>0) fld=  new CDBFFld(fieldwidth,dec,NUM_FIELD,m_NewOffset); 
			else fld=  new CDBFFld(fieldwidth,dec,INT_FIELD,m_NewOffset); //when dec=0 use int_gield flag
   		 break;
   		case INT_FIELD:
		 // integer   
   		TRACE1("  Int  field type, name=%s\n", fldname);
   		ASSERT(dec ==0);
   		 fld= new CDBFFld(fieldwidth,0,INT_FIELD,m_NewOffset);
   		break;
	     		
   		default:
/* only gets here if error in decoding fld type*/
		AfxMessageBox(" Field name format incorrect/unknown in  DBF header block");
  		AfxThrowUserException();
     		}		// end of switch
TRACE1("ReadDBFHead: field data at Offset=%X \n",m_NewOffset);
ASSERT (fld !=NULL);
// places new name into array
m_FldNames.Add(fldname);
m_Flds[fldname]=fld;  // add the field to the map
m_NewOffset+=fieldwidth;// update the offset
m_NumFlds++; // increment number of fields
SetRecLength(); // update record length
}

void CDBFHead::SetRecLength(void)
{// calculates the record length, is always atleast 1
const CDBFFld *fld;
m_RecLength=1;
if(m_NumFlds ==0)
	{
	TRACE0(" attempt to set record length with NumFlds=0\n");
	AfxThrowUserException();
	return;
	}
for(UINT i=0; i<m_NumFlds; i++)
	{
	fld=GetFldPtr(i);
	m_RecLength+=fld->GetFldWidth();
	}
}
//////////////////////////////////////////////////////////////
BOOL CDBFHead::ConvertNumRecords( DBFRECORD *bptr)
{ //converts the num records and checks fisrt header line
// returns FALSE if not db header
ASSERT(bptr !=NULL);
ASSERT(AfxIsValidAddress(bptr, m_RecLength,TRUE) !=0);
if (*bptr != 0x03 )           
	{
	AfxMessageBox ("This is not recognised as \n a DBase iii file");  
	AfxThrowUserException();
	}
m_NumRecords= (long) (*(bptr+4) + *(bptr+5)*256) ;// get number of records
size_t HeadEnd=(size_t) (*(bptr+8) + *(bptr+9)*256); // the end of header offset  
ASSERT(HeadEnd > BLK_SIZE);
m_RecLength= (*(bptr+0x0A) +*(bptr+0x0B)*256);// length of data record
m_NumFlds=(UINT) ((HeadEnd-BLK_SIZE-2)/BLK_SIZE) +1;
ASSERT(m_RecLength >0);  
// now the date
char numbuf[FTOA_BUFFER];
m_Date.Empty();
UINT i=*(bptr+3); // the day
itoa(i,numbuf,10);   
m_Date=strcat(numbuf,"/");
i=*(bptr+2);itoa(i,numbuf,10);
m_Date=m_Date+strcat(numbuf,"/");
i=*(bptr+1);itoa(i,numbuf,10);
m_Date=m_Date+numbuf;
TRACE1("OK ConvertNumRecords:  numrecords=%ld, ",m_NumRecords);
TRACE1("  HeadEnd= %d ,",HeadEnd);
TRACE1("reclength=%d \n", m_RecLength);
TRACE1("File date: %s\n",m_Date);
return TRUE;
}  
void CDBFHead::Duplicate(CDBFHead& head)
{// duplicates the supplied obj into this one
EraseFlds(); // clean the currently stored values
//m_NewOffset=head.m_NewOffset;
//m_NumFlds=head.GetNumFields();
//m_NumRecords=head.GetNumRecords();
//m_RecLength=head.GetRecLength();
m_Date=head.m_Date;
CDBFFld *fld;
UINT FldType, DecPlaces;
size_t FldWidth;
CString fldname;
for( UINT i=0; i<head.GetNumFields(); i++)
	{   // now get the field details and duplicate into this object
	fld=head.GetFldPtr(i);
	fldname=head.id2FldName(i);
	FldType=fld->GetFldType();
	DecPlaces=fld->GetFldDecimal();
	FldWidth=fld->GetFldWidth();
	AddField(FldType, fldname, FldWidth, DecPlaces);
	}
ASSERT(m_NewOffset == head.m_NewOffset);
ASSERT(m_NumFlds == head.m_NumFlds);
ASSERT(m_NumRecords== head.GetNumRecords());
ASSERT(m_RecLength== head.GetRecLength());
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CString  CDBFHead:: id2FldName(UINT fld_id)  const
// converts fld_id into name  returning a pointer
// to a static space which contains the field name
{
	CheckFldid(fld_id)  ; // runs check on fld_id
	return (m_FldNames.GetAt(fld_id));// returns  to string
}      
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++    
UINT CDBFHead::FldName2id(const char* fld)  const
{ // converts the fiel;d name in its id umber, returns INVALID_FIELD_NAME
// if name not known . The Stored field names always end on the last character
UINT  i;
ASSERT( strlen(fld) <= MAX_FLD_LEN);  // check is not larger than req
CString f=fld;
for ( i=0; i< m_NumFlds; i++)
	{
	// compare strings ignoring case
	if((f.CompareNoCase( m_FldNames.GetAt(i) )) ==0)
			{
			CheckFldid(i);
			return (i); // found identical string
			}
	}
return (INVALID_FIELD_NAME);
} 
// ++++++++++++++++++++++++++++++++++++++++++++++++++++
BOOL  CDBFHead::CheckFldid(UINT fld_id)  const
{ // checks the field id to see if valid
// if one of errors then prints message on screen and returns FALSE
if(fld_id == INVALID_FIELD_NAME)
		{
		AfxMessageBox(" Unknown Field Name Supplied as argument to CDBFHead");
		return FALSE;
		}
ASSERT(fld_id >=0 && fld_id <m_NumFlds );
return TRUE;
} 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
CDBFFld *CDBFHead::GetFldPtr(UINT fld_id)  const
{
CObject* fld;
VERIFY(m_Flds.Lookup(m_FldNames[fld_id],fld));
ASSERT(fld->IsKindOf(RUNTIME_CLASS(CDBFFld)));
return (CDBFFld *) fld;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
CDBFFld *CDBFHead::GetFldPtr(const char *fldstr) const
{
CObject* fld;
ASSERT(fldstr[0] !=0);
VERIFY(m_Flds.Lookup(fldstr,fld));
ASSERT(fld->IsKindOf(RUNTIME_CLASS(CDBFFld)));
return (CDBFFld *) fld; 
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifdef _DEBUG
void CDBFHead:: AssertValid() const
{
	CObject::AssertValid(); // call inherited assertvalid
	m_Flds.AssertValid(); 
	m_FldNames.AssertValid();
	ASSERT(m_RecLength >0);
	ASSERT(m_NumFlds >0);
	ASSERT(m_NumFlds == (UINT) m_FldNames.GetSize());
	ASSERT(m_NumFlds == (UINT) m_Flds.GetCount());
}
void CDBFHead:: Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
	dc << "m_NumRecords= " << m_NumRecords << "\n"
	<< "m_RecLength =" << m_RecLength
	<< "m_NumFlds = " << m_NumFlds;
	dc.SetDepth(1);
	dc << "m_FldNames= " << m_FldNames << "\n";
	dc << "Map : "<<m_Flds<<"\n";
}
#endif   
