////////////////////////////////////////////////////////////////////////////////
#define BLK_SIZE	32
#define MAX_FLD_LEN	10

class CDBFHead : public CObject                                  

{ // contains the information in the header the DBF       
DECLARE_DYNCREATE(CDBFHead)
protected:
//	size_t m_HeadEnd; // the last byte-offset  in the header record
	size_t m_NewOffset;// byte offset marking start of potential new field position
	UINT m_NumFlds; // the number of db fields
	long m_NumRecords;  // number of records in file
	size_t m_RecLength; // the length of each record with data in bytes
	CString m_Date; // the date in the file header block
/* since the field objects canot be referenced by an id number directly
we use the fldNames as reference pointers to the the field objects in m_Flds
ie. m_FldNames are in consistent order */
	CMapStringToOb m_Flds; // hold pointers to  fields, and maps fieldnames to field objects 
	CStringArray m_FldNames; // holds field names
private: 
 	BOOL  CheckFldid(UINT fld_id) const;
	BOOL ConvertNumRecords(DBFRECORD *ptr);// checks/decodes first line of header
	void SetRecLength(void);// calculates the record length
public:
	CDBFHead();  
	~CDBFHead();
	BOOL WriteDBFHead(CFile *file);
	BOOL ReadDBFHead(CFile *file); // reads the header and put data into arrays, returns no of
									// records in the file. Leaves pointer at start of data      
	// functions dealing with size etc of db file
	UINT GetNumFields(void) const {return m_NumFlds;};
	long GetNumRecords(void) const { return m_NumRecords;};
	size_t GetRecLength(void) const {return m_RecLength;};
	size_t GetFirstRecOff( void) const {return ((size_t) GetHeadEnd()+1);};
	size_t GetLastRecOff(void) const {return( GetFirstRecOff()+ 
				(m_RecLength*( (size_t) m_NumRecords-1)));};
	size_t GetHeadEnd(void) const { 
				return (size_t) (((m_NumFlds+1)*BLK_SIZE) +1);};
	// functions dealing with field details
	size_t GetFldWidth(UINT fld_id) const { CheckFldid(fld_id); 
					return GetFldPtr( fld_id)->GetFldWidth();};
	UINT FldName2id(const char *FldName) const ; // converts fldname into field id number	
	// Editing the fields
	void AddField(UINT fldtype, const char* fldname, 
				UINT fldwidth, UINT dec); // adds new field
	void Duplicate(CDBFHead& head); // makes this object a duplicate of supplied object
	protected:
	void EraseFlds(void);
	 CDBFFld *GetFldPtr(UINT fld_id) const;
	 CDBFFld *GetFldPtr(const char *fld) const;
	// functions dealing with fld names, ids 
	CString  id2FldName(UINT fld_id) const; 		// converts fld_id into name     

#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
};
/////////////////////////////////////////////////////////////////////////////////////////////////////
 
