// xrddoc.cpp : implementation of the CRefDoc class
//

#include "stdafx.h"
#include "exam1.h"

#include "xrddoc.h" 

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRefDoc

IMPLEMENT_DYNCREATE(CRefDoc, CDocument)

BEGIN_MESSAGE_MAP(CRefDoc, CDocument)
	//{{AFX_MSG_MAP(CRefDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRefDoc construction/destruction

CRefDoc::CRefDoc()
{
	 // the member variable for the handle to file
}

CRefDoc::~CRefDoc()
{
	//clear the memory used by the document
}

BOOL CRefDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	// does nothing
	// (SDI documents will reuse this document)
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CRefDoc diagnostics

#ifdef _DEBUG
void CRefDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CRefDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG
////////////////////////////////////////////////
// OnOpenDocument
BOOL CRefDoc :: OnOpenDocument(const char* pszPathName)
{
	return InitDocument(pszPathName);
}

/////////////////////////////////////////////////////////////////////////////
// CRefDoc commands

BOOL CRefDoc::InitDocument(const char* pszPathName)
{
	CFile file;
	CFileException fe;
	CDBFHead dbfhead;
	CMapStringToOb* data;
	CStringArray studentnames;
	unsigned short numrecs;
	if (!file.Open(pszPathName, CFile::modeRead | CFile::shareDenyWrite, &fe))
	{
		ReportSaveLoadException(pszPathName, &fe, FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
	}      
	
	DeleteContents();    // delets contnts of document
	BeginWaitCursor();  // places hour glass cursor to indicate busy loading data
	
	TRY     // try to catch exception thrown by reading error 
	{
		numrecs=dbfhead.ReadDBFHead(file);
	}
	CATCH  (CFileException, eLoad)   
		{
		file.Abort();     
		EndWaitCursor();
		ReportSaveLoadException(pszPathName, eLoad,FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
		}
	END_CATCH
	TRY     // try to catch exception thrown by reading error 
	{
		data=ReadDBFFile(file,dbfhead,studentnames);
	}
	CATCH  (CFileException, eLoad)   
		{
		file.Abort();     
		EndWaitCursor();
		ReportSaveLoadException(pszPathName, eLoad,0, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
		}
	END_CATCH
	
	EndWaitCursor();
	
	if (numrecs == 0)
		{ // error returned from ReadDBFFile()
		MessageBox(NULL," Couldn't Load DBF data: no data Records",
					NULL,MB_ICONINFORMATION |MB_OK);
		return FALSE;
		}
	SetPathName(pszPathName);  // remember the file name as the default
	SetModifiedFlag(FALSE); // file will not be modified   
	return TRUE;
	
}
/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CStdDoc

IMPLEMENT_DYNCREATE(CStdDoc, CDocument)

BEGIN_MESSAGE_MAP(CStdDoc, CDocument)
	//{{AFX_MSG_MAP(CStdDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStdDoc construction/destruction

CStdDoc::CStdDoc()
{
	 // the member variable for the handle to file
}

CStdDoc::~CStdDoc()
{
	//clear the memory used by the document
}

BOOL CStdDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	// does nothing
	// (SDI documents will reuse this document)
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CStdDoc diagnostics

#ifdef _DEBUG
void CStdDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CStdDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG
////////////////////////////////////////////////
// OnOpenDocument
BOOL CStdDoc :: OnOpenDocument(const char* pszPathName)
{
	return InitDocument(pszPathName);
}

/////////////////////////////////////////////////////////////////////////////
// CStdDoc commands

BOOL CStdDoc::InitDocument(const char* pszPathName)
{
	CFile file;
	CFileException fe;
	CDBFHead dbfhead;
	CMapStringToOb* data;
	CStringArray studentnames;
	unsigned short numrecs;
	if (!file.Open(pszPathName, CFile::modeRead | CFile::shareDenyWrite, &fe))
	{
		ReportSaveLoadException(pszPathName, &fe, FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
	}      
	
	DeleteContents();    // delets contnts of document
	BeginWaitCursor();  // places hour glass cursor to indicate busy loading data
	
	TRY     // try to catch exception thrown by reading error 
	{
		numrecs=dbfhead.ReadDBFHead(file);
	}
	CATCH  (CFileException, eLoad)   
		{
		file.Abort();     
		EndWaitCursor();
		ReportSaveLoadException(pszPathName, eLoad,FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
		}
	END_CATCH
	TRY     // try to catch exception thrown by reading error 
	{
		data=ReadDBFFile(file,dbfhead,studentnames);
	}
	CATCH  (CFileException, eLoad)   
		{
		file.Abort();     
		EndWaitCursor();
		ReportSaveLoadException(pszPathName, eLoad,0, AFX_IDP_FAILED_TO_OPEN_DOC);
		return FALSE;
		}
	END_CATCH
	
	EndWaitCursor();
	
	if (numrecs == 0)
		{ // error returned from ReadDBFFile()
		MessageBox(NULL," Couldn't Load DBF data: no data Records",
					NULL,MB_ICONINFORMATION |MB_OK);
		return FALSE;
		}
	SetPathName(pszPathName);  // remember the file name as the default
	SetModifiedFlag(FALSE); // file will not be modified   
	return TRUE;
	
}
				