// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "readdbf.h"
#include "mineral.h"
#include "exam1.h"

#include "mainfrm.h" 
#include "xrdref.h" 
#include "xrdstds.h" 
#include "xrdfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_REFMINERALS, OnViewRefminerals)
	ON_COMMAND(ID_VIEW_STANDARDS, OnViewStandards)
	ON_COMMAND(ID_FILE_OPEN_CALDBF, OnFileOpenCaldbf)
	ON_COMMAND(ID_FILE_OPEN_REFDBF, OnFileOpenRefDBF)
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN_CALDBF, OnUpdateFileOpenCaldbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN_REFDBF, OnUpdateFileOpenRefbf)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REFMINERALS, OnUpdateViewRefminerals)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STANDARDS, OnUpdateViewStandards)
	ON_COMMAND(ID_FILE_CLOSE_CALDBF, OnFileCloseCaldbf)
	ON_COMMAND(ID_FILE_CLOSE_REFDBF, OnFileCloseRefdbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_CALDBF, OnUpdateFileCloseCaldbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_REFDBF, OnUpdateFileCloseRefdbf)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;		// fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;		// fail to create
	}

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
 /*
void CMainFrame::OnFileOpenCalib()
{
 
	CString strFileName;
	if (!(CWinApp::DoPromptFileName(strFileName, IDS_OPEN_CALIB,
			OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, NULL)))
		return;

   int i=10;
	// Open the file now .
	CMinCalibration* pDoc = (CMinCalibration*)CWinApp::OpenDocumentFile(strFileName);
	if (pDoc == NULL)
	{
		CString strMessage;
		AfxFormatString1(strMessage, IDS_CANNOT_OPEN_CALIB, 
			strFileName);
		AfxMessageBox(strMessage);
		return ;
	}   
	return ; 
	
}

void CMainFrame::OnFileOpenRef()
{
	// CWinApp::OpenDocmentFile creates the first MDI child window
	// for the notepad view.  This override creates the second MDI child
	// window for the reference form view.  Then it tiles the two MDI children
	// windows.
 
	CString strFileName;
	if (!(DoPromptFileName(strFileName, IDS_OPEN_REF,
			OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, NULL)))
		return;


	CMinData* pDoc = (CMinData*)CWinApp::OpenDocumentFile(strFileName);
	if (pDoc == NULL)
	{
		CString strMessage;
		AfxFormatString1(strMessage, IDS_CANNOT_OPEN_REF, 
			strFileName);
		AfxMessageBox(strMessage);
		return;
	}   
	return ; 
}  
 */
 CMDIChildWnd *CMainFrame::GetFrame(CRuntimeClass *pFrame)
 {   // returns a pointer to the one accurance of this frame type passed
 // as parameter pFrame
 	CMDIChildWnd* pMDIActive = MDIGetActive();
	ASSERT(pMDIActive != NULL);
	if( pMDIActive->IsKindOf(pFrame))
				return pMDIActive; 
	CDocument *pDoc=pMDIActive->GetActiveDocument();  
	ASSERT(pDoc !=NULL);
	CMDIChildWnd *pLastActive=pMDIActive;
	// use pDoc as means of telling when get back to this start again
	MDINext();
	pMDIActive=MDIGetActive();
	ASSERT(pMDIActive != NULL);
	while(pMDIActive->GetActiveDocument() !=pDoc)
		{
		if( pMDIActive->IsKindOf(pFrame))
			goto OK;
		MDINext();
         pMDIActive=MDIGetActive();
		ASSERT(pMDIActive != NULL);
		}
// not found
TRACE(" MainFrame::GetFrame,=expected frame type not found\n");
return NULL;
OK:
MDIActivate(pLastActive);
return pMDIActive;
}

void CMainFrame::OnViewRefminerals()
{
	CMDIChildWnd* pMDIActive = 
			GetFrame(RUNTIME_CLASS(CXRDFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	MDIActivate(pMDIActive); //activate it
	BOOL maximized;
	 MDIGetActive(&maximized);// find if maximised
	if(!maximized)
				pMDIActive->MDIRestore(); // if not maximise it
}

void CMainFrame::OnViewStandards()
{  
	CMDIChildWnd* pMDIActive = 
			GetFrame(RUNTIME_CLASS(CXRDStdFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	MDIActivate(pMDIActive); //activate it
	BOOL maximized;
	 MDIGetActive(&maximized);// find if maximised
	if(!maximized)
				pMDIActive->MDIRestore(); // if not maximise it
}
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::OnFileOpenCaldbf()
{
theApp.OpenFileCal();
}

void CMainFrame::OnFileOpenRefDBF()
{
	theApp.OpenFileRef();
}

void CMainFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default
AfxMessageBox(" abount to close window\n");	
	CMDIFrameWnd::OnClose();
}
// menu update handlers
void CMainFrame::OnUpdateFileOpenCaldbf(CCmdUI* pCmdUI)
{
	if(theApp.GetStdDocStatus()) pCmdUI->Enable(	FALSE);
			else pCmdUI->Enable(TRUE);
}
void CMainFrame::OnUpdateFileOpenRefbf(CCmdUI* pCmdUI)
{
	if(theApp.GetRefDocStatus()) pCmdUI->Enable(	FALSE);
			else pCmdUI->Enable(TRUE);
}
void CMainFrame::OnUpdateViewRefminerals(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetRefDocStatus());
}
void CMainFrame::OnUpdateViewStandards(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetStdDocStatus());
}

void CMainFrame::OnFileCloseCaldbf()
{
	CXRDStdFrame* pMDIActive = (CXRDStdFrame *)
			GetFrame(RUNTIME_CLASS(CXRDStdFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	 pMDIActive->OnCloseDoc();
	 theApp.m_bStdDoc=FALSE;
	 theApp.UpdateIniFileWithCalibPath("");
}

void CMainFrame::OnFileCloseRefdbf()
{
	CXRDFrame* pMDIActive = (CXRDFrame *)
			GetFrame(RUNTIME_CLASS(CXRDFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	 pMDIActive->OnCloseDoc();
	 theApp.m_bRefDoc=FALSE;
	 theApp.UpdateIniFileWithRefPath("");
}

void CMainFrame::OnUpdateFileCloseCaldbf(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetStdDocStatus());
}

void CMainFrame::OnUpdateFileCloseRefdbf(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetRefDocStatus());
}
