// mineral.cpp : implementation file
//
#define QNTXRD
#include "stdafx.h"
#include "readdbf.h"
#include "cdbffile.h"
#include "mineral.h"  
#ifdef QNTXRD
	#include "..\qntxrd\qxrdDoc.h"
	#include "..\qntxrd\qntxrd.h"
#else
	#include "exam1.h"
#endif
#include "\geophys\utilclas\general.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
 static char HKL_STRINGS[][MAX_PEAKS]= {	"PK1_HKL","PK2_HKL","PK3_HKL",
											"PK4_HKL","PK5_HKL","PK6_HKL",
											"PK7_HKL","PK8_HKL","PK9_HKL","PK10_HKL"};
static char D_SPACE[][MAX_PEAKS]={	"PK1_D","PK2_D","PK3_D","PK4_D",
											"PK5_D","PK6_D","PK7_D","PK8_D",
											"PK9_D","PK10_D"};
static char* PROP= {"PROPORTION"};  
static char* RUN={"RUN_NO"};
static char PKAREA[][MAX_PEAKS]= {	"PK1","PK2","PK3",
											"PK4","PK5","PK6", 	"PK7","PK8","PK9","PK10"};
CString INT_STD; // global external standard instance

void TrimBlankTails(CString &str)
{
char FAR* lpStr=str.GetBuffer(str.GetLength());
TrimTails(lpStr);
str.ReleaseBuffer();
}

/////////////////////////////////////////////////////////////////////////////
// CMinData

IMPLEMENT_DYNCREATE(CMinData, CDocument )
IMPLEMENT_DYNCREATE(CMinCalibration, CDocument )
#define new DEBUG_NEW

CMinData::CMinData()
{ 
m_pdbf=NULL;// sets to null to indicate not initialised
m_NumStds=0;
}

CMinData::~CMinData()
{
if( m_pdbf !=NULL) delete m_pdbf;
}


BEGIN_MESSAGE_MAP(CMinData, CDocument)
	//{{AFX_MSG_MAP(CMinData)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMinData commands                                                       
BOOL CMinData::OnOpenDocument(const char *pszPathname)
{   // returns 0 if error in loading document
CFile m_file; // dbf file is keept open until data read
CFileException e;
if( !CDocument::OnOpenDocument(pszPathname) )
		return (0);
ASSERT(m_file.m_hFile == CFile::hFileNull);
if (!m_file.Open(pszPathname, CFile::modeRead |CFile::shareExclusive, &e) )
	{  
	DisplayCFileErr(e.m_cause,ERR_BOX);
	return (0);                   
	}
if(m_file.GetLength() == 0L)
	{// file is empty
	AfxMessageBox("No Data in Minerals reference data base");
	m_file.Close();
	return (0);
	}
// this reads the header and positions on first record  
TRY {m_pdbf= new CDBFFile(&m_file);  }
CATCH (CUserException, e)
		{
		TRACE0("CUserException detected in CMINData:OnOpenDocument\n");
		return(0);
		}
		AND_CATCH(CFileException, fe);
		{
		DisplayCFileErr(fe->m_cause,ERR_BOX);
		return(0);
		}
		AND_CATCH(CException, me)
		{
		TRACE0("CExeption detected in CMinData:OnOpenDocument\n");
		}
		END_CATCH
ASSERT(m_pdbf !=NULL);
// need to check if error in reading
if(m_pdbf->GetNumFields() == 0 && m_pdbf->GetNumRecords() ==0)  
	{
	TRACE0(" CMinData:OnOpenDocument : ERROR in CDBFFile constuction\n");
	m_file.Close();
	delete m_pdbf;m_pdbf=NULL;
	return (0);
	}
if(CheckFieldDetails() == FALSE)
	{
	AfxMessageBox(" Field Name(s) in DBF file do not correspond with expected detail");
	m_file.Close();
	delete m_pdbf;m_pdbf=NULL;
	return (0);
	}
if(ReadMinData() ==TRUE)
		{     // sucess in reading in data
		TRACE0("CMinData:OnOpenDocument : Data sucessfully loaded\n");
		m_file.Close(); // closes the file when read in
		return (-1);
		}
		else
		{// could not load the data
		TRACE0("CMinData:OnOpenDocument : ERROR in loading data\n");
		m_file.Close(); // closes the file when read in 
		 DeleteContents();  // deletes the possible empty contents
		return (0);
		}
}
//----------------------------------------------------------------------------------------
BOOL CMinData::CheckFieldDetails(void)
{ // makes sure the field deatils/names match the expected names
if(m_pdbf->FldName2id(B_STD) ==INVALID_FIELD_NAME) return FALSE;
if(m_pdbf->FldName2id(MIN) ==INVALID_FIELD_NAME) return FALSE;
for(int i=0; i<MAX_PEAKS; i++)
	{
	if(m_pdbf->FldName2id(HKL_STRINGS[i]) ==INVALID_FIELD_NAME) 
				return FALSE;
	if(m_pdbf->FldName2id(D_SPACE[i]) ==INVALID_FIELD_NAME) 
				return FALSE;
	}
return TRUE;
}

//--------------------------------------------------------------------------------------------
BOOL CMinData::ReadMinData(void)
{ 
/* returns TRUE if data read in succesfully, and FALSE overwise
*/
UINT stdtype; //  indicates type of record read in first
BOOL err; 
m_NumStds=(UINT) (m_pdbf->GetNumRecords() /2.0L);
BINARYREF *stds; // pointer to dynamically created structure to hold data
CString b_str,m_str, test_str;
for(UINT rec=1; rec<=(m_NumStds*2);rec=rec+2)
	{
	stds=new BINARYREF;
	ASSERT(stds !=NULL);
	m_pdbf->Goto(rec);// goto record 1
	b_str= m_pdbf->GetField(B_STD);
	TrimBlankTails(b_str);
//	b_str=TrimBlankTails(m_pdbf->GetField(B_STD));// binary std, trimming size
//	b_str=StrLtrim(b_str);// trim left also
	ASSERT(b_str.GetLength() >0);
	m_str=m_pdbf->GetField(MIN);
	TrimBlankTails(m_str);
//m_strTrimBlankTails(m_pdbf->GetField(MIN)); // gets mineral name, trimming right
//	 m_str=StrLtrim(m_str); // trim left also
	ASSERT(m_str.GetLength() >0);
	 if (m_str. CompareNoCase(INT_STD) == 0)  // check if is internal std
			{err=RetrieveStd(stds,stdtype=INTERNAL_STD);}// gets the internal	
			else
			{err=RetrieveStd(stds,stdtype=UNKNOWN);} // retrieve std  
	if(err==FALSE)
		{ //error occured in retrieve routines
			delete stds; 
			DeleteContents();// deletes any read in data
			return (m_DataCaptured=FALSE);
		}
	m_pdbf->Goto(rec+1); // goto next record  
	// run some checks on this next record to see if ok/ as expected
	test_str=m_pdbf->GetField(B_STD);TrimBlankTails(test_str);
	if( b_str.CompareNoCase(test_str ) !=0) 
			{	// check that is for same binary standard
			AfxMessageBox("Bimary Standard name Out of Order \n in Mineral Reference database");
			delete stds; 
			DeleteContents();// deletes any read in data
			return (m_DataCaptured=FALSE);
			}
	test_str=m_pdbf->GetField(MIN);TrimBlankTails(test_str);
	if(m_str.CompareNoCase(test_str   )==0)
		{ // two adjecent minerals of same name
			AfxMessageBox("Two adjecent mineral of same name\n in Mineral Reference database");
			delete stds; 
			DeleteContents();// deletes any read in data
			return (m_DataCaptured=FALSE);     
		}
	if(stdtype== UNKNOWN) err=RetrieveStd(stds,INTERNAL_STD);
			else err=RetrieveStd(stds,UNKNOWN);
	if(err==FALSE)
		{ //error occured in retrieve routines
			delete stds; 
			DeleteContents();// deletes any read in data
			return (m_DataCaptured=FALSE);
		}    
		// now copy ptr into m_Data
		stds->B_Standard=b_str; // binary standard name   
		m_Data[b_str]=stds; // adds map, and strcuture
		 m_Runs.Add(b_str);
	}
return(m_DataCaptured=TRUE);
}	
//-------------------------------------------------------------------------------------------
void CMinData::DeleteContents(void)
{     // override of CDocument fucntion
CString str; 
void *stds;
m_Runs.RemoveAll();
for(POSITION  i=m_Data.GetStartPosition(); i != NULL; )
	{
	m_Data.GetNextAssoc(i, str,stds); 
	ASSERT(stds !=NULL);
	delete (BINARYREF *) stds;                     
	}
m_Data.RemoveAll();                                
if( m_pdbf !=NULL)
	{ // may be called if empty
	ASSERT(m_pdbf ->IsKindOf(RUNTIME_CLASS(CDBFFile)) ); 
	// delete the CDBFFile class constructed
		delete m_pdbf; 
		m_pdbf=NULL;
	}
}	                                             
//------------------------------------------------------------------------------------
BOOL CMinData::RetrieveStd(BINARYREF *stds,UINT stdtype)
{  
double val;
CString str;
if(stdtype== INTERNAL_STD ) 
		{ // internal std
		str=m_pdbf->GetField(MIN); TrimBlankTails(str);
		stds->IntStd.Mineral=str;
		TRACE1("Int Std = %s\n [HKL]: d,",stds->IntStd.Mineral);
		}
	else 
		{ 
		str=m_pdbf->GetField(MIN); TrimBlankTails(str);
		stds->Unknown.Mineral=str;
		TRACE1("Unknown = %s\n [HKL]: d,",stds->Unknown.Mineral);
		}
for(int i=0; i<MAX_PEAKS; i++)
	{
	str=m_pdbf->GetField(HKL_STRINGS[i]);// hkl string
	TrimBlankTails(str);  
	if(str.GetLength() >0)         // do not add if no hkl values-assume end of data 
			{ 
			TRACE1("[%s]:",str);// prints HKL value
			if(stdtype == INTERNAL_STD)
				{     // internal std
				stds->IntStd.Hkl.Add(str);
				stds->IntStd.Ds[i]=(float) m_pdbf->GetField(D_SPACE[i], &val);// d-spacing
				TRACE1(" ,%5.2f, ",stds->IntStd.Ds[i]);
				}
				else
				{   // unknown
				stds->Unknown.Hkl.Add(str);
				stds->Unknown.Ds[i]=(float) m_pdbf->GetField(D_SPACE[i], &val);// d-spacing
				TRACE1(" ,%5.2f,",stds->Unknown.Ds[i]);
				}
			}
			else 
			{// no hkl values, but need to set d-sapcing to zeros
			if(stdtype ==INTERNAL_STD)
					stds->IntStd.Ds[i]=0.0;
					else
					stds->Unknown.Ds[i]=0.0;
			}
	}
TRACE0(" \n");
return TRUE;
}
//-------------------------------------------------------------------------------------------
BINARYREF *CMinData::GetBinaryRef(const char *B_name)
{/* passed a valid name of a binary mix in B_name it retuns
a pointer to the BINARYREF structure which holds the data for
the two minerals used in the calibration run
RETURNS: NULL if error (B_name not exist)
			ptr if ok
*/
void *ptr;  
if( m_Data.Lookup(B_name,ptr) == FALSE)
	return NULL;
	else
	{
	ASSERT(ptr !=NULL);
	return (BINARYREF *) ptr; }
}
//-----------------------------------------------------------------------------------
int CMinData::GetIndexToHKL(const char *b_std, const char *hkl, int type)
{ // returns the position in the list of hkl values that hkl is stored
// type is either INTERNAL_STD or UNKNOWN
// b_std is thebinary name
// returns: 0 if hkl not found
BINARYREF  *pRef=GetBinaryRef(b_std);
if( pRef ==NULL) return(0);
ASSERT(type == INTERNAL_STD || type == UNKNOWN);
CString str;
if(type ==INTERNAL_STD)
	{
	 for(int i=0; i<=pRef->IntStd.Hkl.GetUpperBound(); i++)
	 	       {
	 	       str=pRef->IntStd.Hkl[i];
	 	       if(str.CompareNoCase(hkl) ==0) return(i);
	 	       }
	}
	else
	{
	 for(int i=0; i<=pRef->Unknown.Hkl.GetUpperBound(); i++)
	 	       {
	 	       str=pRef->Unknown.Hkl[i];
	 	       if(str.CompareNoCase(hkl) ==0) return(i);
	 	       }
	}
return (0);
}
/////////////////////////////////////////////////////////////////////////////
// CMinCalibration


CMinCalibration::CMinCalibration()
{
m_NumStds=0;m_pdbf=NULL;m_DataCaptured=FALSE;
}

CMinCalibration::~CMinCalibration()
{
if(m_pdbf !=NULL) delete m_pdbf;
}
BEGIN_MESSAGE_MAP(CMinCalibration, CDocument)
	//{{AFX_MSG_MAP(CMinCalibration)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMinCalibration commands
 BOOL CMinCalibration::OnOpenDocument(const char *pszPathname)
{ 
CFile m_file; // dbf file is keept open until data read
if( !CDocument::OnOpenDocument(pszPathname) )
		return (0);
ASSERT(m_file.m_hFile == CFile::hFileNull);
if (!m_file.Open(pszPathname, CFile::modeRead |CFile::shareExclusive))
	{
	return (0);
	}
if(m_file.GetLength() == 0L)
	{// file is empty
	CString str="No Data in Calibration data base: \n";
	str=str+pszPathname;
	AfxMessageBox(str);
	return (0);
	}                                                              
// this reads the header and positions on first record
m_pdbf= new CDBFFile(&m_file); 
ASSERT(m_pdbf !=NULL);
if(m_pdbf->GetNumFields() == 0 && m_pdbf->GetNumRecords() ==0)  
	{
	TRACE0(" CMinCalibration:OnOpenDocument : ERROR in CDBFFile constuction\n");
	m_file.Close();
	delete m_pdbf;m_pdbf=NULL;
	return (0);
	}
if(CheckFieldDetails() == FALSE)
	{
	AfxMessageBox(" Field Name(s) in DBF file \n do not correspond with expected details");
	m_file.Close();
	delete m_pdbf;m_pdbf=NULL;
	return (0);
	}
if(ReadCalibData() ==TRUE)
		{
		TRACE0("CMinCalibration::OnOpenDocument, sucdessfully read-in data\n");
		//m_file.Close(); 
		delete m_pdbf;
		m_pdbf=NULL;// closes the file when read in
		 // adds binary name to m_BMixes, gets from m_BinMap
		if(AddBinaryNames() ==FALSE)
				{ DeleteContents();
				AfxMessageBox(" Problem in assigning binary name memory");
				return (0);
				}
		return (-1);
		}
		else
		{// could not load the data
		TRACE0("CMinCalibration:: OnOpenDocument, ERRor in loading the data\n");
		m_file.Close(); // closes the file when read in
		DeleteContents(); 
		return (0);
		}
}
//-----------------------------------------------------------------------
 void CMinCalibration::DeleteContents(void)
{     // override of CDocument fucntion
WORD key;
CObject *runs;  
CMapWordToPtr *runmap;
CString str;
void *calib;
POSITION data;
m_BMixes.RemoveAll();
for(POSITION  i=m_BinMap.GetStartPosition(); i != NULL; )
	{
	m_BinMap.GetNextAssoc(i, str,runs);// get the ptr to wordtoptr
	ASSERT(runs !=NULL);
	runmap=(CMapWordToPtr *) runs;
	for (data=runmap-> GetStartPosition(); data !=NULL;)
		{ // get the ptr to the CALIBRATION struct, for each run consequetively
		runmap->GetNextAssoc(data, key,calib);  
		ASSERT(calib !=NULL);
		delete (CALIBRATION *) calib; // delete this structure
		}
		// delete the allocated CMapWordToPtr object
	runmap->RemoveAll();// delete words/ptrs
	delete runmap;
	}
m_BinMap.RemoveAll(); // delete strings/pts to runmaps
if( m_pdbf !=NULL)
	{ // may be called if empty
	ASSERT(m_pdbf ->IsKindOf(RUNTIME_CLASS(CDBFFile)) ); 
	// delete the CDBFFile class constructed in OnOpenDocument()
		delete m_pdbf; m_pdbf=NULL;
	}  
m_NumStds=0;
}	                                             
//---------------------------------------------------------------------------------------
BOOL CMinCalibration::CheckFieldDetails(void)
{ // makes sure the field deatils/names match the expected names
if(m_pdbf->FldName2id(B_STD) ==INVALID_FIELD_NAME) return FALSE;
if(m_pdbf->FldName2id(MIN) ==INVALID_FIELD_NAME) return FALSE;
if(m_pdbf->FldName2id(PROP) ==INVALID_FIELD_NAME) return FALSE; 
if(m_pdbf->FldName2id(RUN) == INVALID_FIELD_NAME) return FALSE;
for(int i=0; i<MAX_PEAKS; i++)
	{
	if(m_pdbf->FldName2id(PKAREA[i]) ==INVALID_FIELD_NAME) 
				return FALSE;
	}
return TRUE;
}
//-------------------------------------------------------------------------------------------
BOOL CMinCalibration::ReadCalibData(void)
{ 
/* returns TRUE if data read in succesfully, and FALSE overwise
*/
BOOL err; 
int run;// the run number
CALIBRATION *calib; // pointer to dynamically created structure to hold data
CString b_str,m_str; 
ASSERT(m_pdbf!=NULL);
for(UINT i=1; i<=(UINT) m_pdbf->GetNumRecords() ;i++)
	{
	m_pdbf->Goto(i);// goto new record 
	// get the binary standard name
	b_str=m_pdbf->GetField(B_STD);
	TrimBlankTails(b_str);
	ASSERT(b_str.GetLength() >0);// should be not blanks
	 // now get the run number
	 run=m_pdbf->GetField(RUN,&run);// the run number
	 // we now get a pointer to the structure which will contain the
	 // info for this line, but this may already exist so we leave
	 // this decision to the GetCalibPtr routine, which does all the dynamic
	 // creatiion and updatin the m_BinMap object
	 calib=GetCalibPtr(b_str,run);
	 ASSERT(calib !=NULL);
	 // now check which type of mineral this record is
	 m_str=m_pdbf->GetField(MIN);
	 TrimBlankTails(m_str); // gets mineral name
	 TRACE1("Binary std: [%s],",b_str); 
	 TRACE1("run number [%d], ",run);
	 TRACE1("mineral=[%s]\n",m_str);
	 TRACE1("address of CALIBRATION holding data %p\n",calib);
	ASSERT(m_str.GetLength() >0);
	 if (m_str. CompareNoCase(INT_STD) == 0)  // check if is internal std
			{err=RetrieveCalib(calib,INTERNAL_STD);}// gets the internal	
			else
			{err=RetrieveCalib(calib,UNKNOWN);} // retrieve std  
	if(err==FALSE)
		{ //error occured in retrieve routines
			DeleteContents();// deletes any read in data
			return (m_DataCaptured=FALSE);
		} 
	}
return(m_DataCaptured=TRUE);
}	
//-------------------------------------------------------------------------------------------------------
CALIBRATION *CMinCalibration::GetCalibPtr(const char *mix, int run)
{
/*this routine returns a valid pointer to a calibration structure
it must check 1) If a map to a mix of this name already exists
								if so then use this  CMapWordToPtr
						2) If a run number already exists in this object
						then it should return this ptr
						3) if neither of these two are valid then it creates
						a new CALIBRATION structure, and either
						adds it to one of the existing wordtoptr maps
						or creates a new one
*/
CObject *obj;
CALIBRATION *calib;
CMapWordToPtr *prun_map;  
void *ptr;
ASSERT(run >=0);
if(m_BinMap.Lookup(mix,obj))
		{// has found a mapped CMapWordToPtr object
		ASSERT(obj !=NULL);
		prun_map=(CMapWordToPtr *) obj; // convert to ptr to map object
		// lets see if this run exists
		if(prun_map->Lookup((WORD) run,ptr))
			{// ie found this run element 
			ASSERT(ptr !=NULL);
			calib=(CALIBRATION *) ptr;// convert to correct ptr type
			}
			else
			{  //CALIBRATION struc holding this run not found
			calib=CreateNewCALIB();
			ASSERT(calib !=NULL);
			prun_map->SetAt((WORD) run, calib);// add new run to map
			}
		}
		else
		{// NOT found a mapped CMapWordToPtr object- so lets create one
		calib=CreateNewCALIB();
		ASSERT(calib !=NULL);
		prun_map=CreateNewWordMap(run,calib); // make new CMap
		m_BinMap[mix]=prun_map;  // place ptr to runmap
		}
return calib; // return pointer to new or existing structure
}  
//---------------------------------------------------------------------
CALIBRATION* CMinCalibration::CreateNewCALIB(void)
{// creats a new calibration structure
CALIBRATION *ptr=new CALIBRATION;
ASSERT(ptr !=NULL);
return ptr;
}
//----------------------------------------------------------------------------------
CMapWordToPtr* CMinCalibration::
				CreateNewWordMap( int run, CALIBRATION *ptr)
{// create a new CMapWordToPtr object for holding runs
CMapWordToPtr *runmap=new CMapWordToPtr();
ASSERT(runmap !=NULL);
runmap->SetAt((WORD) run, ptr);
return runmap;
}
//--------------------------------------------------------------------------------------------
BOOL CMinCalibration::RetrieveCalib(CALIBRATION *calib,UINT stdtype)
{  
double val;
ASSERT(calib !=NULL);
ASSERT(stdtype == INTERNAL_STD || stdtype == UNKNOWN);
CString str;
if(stdtype== INTERNAL_STD) 
	{
	str=m_pdbf->GetField(MIN);TrimBlankTails(str);
	calib->IntStd.Mineral=str;
	calib->IntStd.Proportion=(float) m_pdbf->GetField(PROP,&val);
	}
	else
	{
	str=m_pdbf->GetField(MIN);TrimBlankTails(str);
	calib->Unknown.Mineral=str;
	calib->Unknown.Proportion=(float)m_pdbf->GetField(PROP,&val);
	}
for(int i=0; i<MAX_PEAKS; i++)
	{
	if(stdtype == INTERNAL_STD)
				  // internal std
				calib->IntStd.pkarea[i]=(float) m_pdbf->GetField(PKAREA[i], &val);// area
				else
				// unknown
				calib->Unknown.pkarea[i]=(float) m_pdbf->GetField(PKAREA[i], &val);//  area
		}
return TRUE;
}
//---------------------------------------------------------------------------
BOOL CMinCalibration::AddBinaryNames(void)
{// returns FALSE if an error detected   
CString key;
CObject *obj;
for(POSITION pos=m_BinMap.GetStartPosition();pos !=NULL;)
	{
	m_BinMap.GetNextAssoc(pos, key, obj);
	m_BMixes.Add(key);
	}
return TRUE;
}
//-------------------------------------------------------------------------
const CMapWordToPtr* CMinCalibration::GetMixMap(const char *B_mix)
{ // returns ptr to map holding data ptrs to this binary mix name
	// returns NULL if not found
CObject *ptr;
ASSERT(strlen(B_mix) >0);
if(m_BinMap.Lookup(B_mix,ptr) == FALSE)
	{// not found this mix
	CString str="Binary mix not found in calibration data base: ";
	str=str+B_mix;
	AfxMessageBox(str);
	return NULL;
	}                                                                                                                                                       
	else
	{ASSERT(ptr !=NULL);
	return (CMapWordToPtr *) ptr;
	}
}
//-----------------------------------------------------------------------------------------------   
UINT CMinCalibration::GetNumRuns(const CMapWordToPtr *runmap)  const
{
ASSERT(runmap !=NULL);
ASSERT(runmap->IsKindOf(RUNTIME_CLASS(CMapWordToPtr)));
return runmap->GetCount();
}
//----------------------------------------------------------     
CALIBRATION *CMinCalibration::GetData( const CMapWordToPtr *runmap, 
					int run, CALIBRATION *data)
 /* Passed a map object, which is valid, and not empty
the routine fills the passed CALIBRATION structure with the data corresponding
to the run number which is also passed. The data structure must be allocated
memory prior to this call , which is filled on return
return values: NULL if error, and data if ok
*/
{
void *ptr;
CALIBRATION *dmap;
ASSERT(runmap !=NULL);
ASSERT(runmap->IsKindOf(RUNTIME_CLASS(CMapWordToPtr)));
ASSERT(data !=NULL);
if(runmap->Lookup((WORD) run,ptr) == FALSE)
	{// not found this run 
	char buf[100];
	wsprintf(buf,"Run number %d \n not found in binary mix",run);
	CString str=buf;
	AfxMessageBox(str);
	return NULL;
	}
	else
	{
	 dmap=(CALIBRATION *) ptr;// find data in this class
     data->IntStd.Mineral=dmap->IntStd.Mineral;
     data->IntStd.Proportion=dmap->IntStd.Proportion;
     data->Unknown.Mineral=dmap->Unknown.Mineral;
     data->Unknown.Proportion=dmap->Unknown.Proportion;  
     for(int i=0;i<MAX_PEAKS;i++)
     	{
     	data->IntStd.pkarea[i]=dmap->IntStd.pkarea[i];
     	data->Unknown.pkarea[i]=dmap->Unknown.pkarea[i];
     	}
     }
 return data;
}
//--------------------------------------------------------------------------------------
WORD *CMinCalibration::GetRunNumbers(const char *B_mix)
{/* returns a pointer to a static array which holds
the run numbers for this particualr binary mix named in B_mix
retuns null if error
*/
const CMapWordToPtr *run=GetMixMap(B_mix) ;
if( run  == NULL)		return NULL; 
for(int i=0;i<MAX_RUNS; i++) RunNos[i]=0;// zeros array
void *ptr; i=0;
for(POSITION pos=run->GetStartPosition(); pos !=NULL;)
	{
	run->GetNextAssoc(pos,RunNos[i],ptr);
	i++;
	}
return  &RunNos[0];
}
//------------------------------------------------------------------------------------
CString CMinCalibration::GenerateBinName(const char *pMin)
{// returns the binary name occording to the unknwon mineral supplied
// and the current internal standard set
CString bin=INT_STD;
bin=bin+"/"; bin=bin+pMin;
return bin;
}
//------------------------------------------------------------------------------------------------
int CMinCalibration::GetNumCalibrationPoints(const char *pMin)
{// return the number of calibration points for this mineral
CString bin=GenerateBinName(pMin);
const CMapWordToPtr *map=GetMixMap(bin);
ASSERT(map !=NULL);
return (map->GetCount());
}
//----------------------------------------------------------------------------------------
float CMinCalibration::GetCalRatio(CStringArray &qtz, CStringArray &unk,
				const char *pMin, int runno)
{
/* returns the calibration ratio for a particular runnumber (ie calibration point)
this routine sums the peaks areas for particular hkl peaks, from the internal
standard and the unknown, and returns this ratio ie. unknown/qtz
qtz contains a series of hkl strings which identify which peaks sum for the internal std
unk contains the hkl peaks to sum for the unknown
pMin is the unknwon mineral
runno is the calibration point/run no to do this for

return : -1 if error, a values >0 if data good
*/
// we do some checking first that data supplied is ok
if( qtz.GetSize() ==0)
	{TRACE0(" GetCalRatio: no values in supplied internal std hkl array\n");
	 return(-1.0);}
if(unk.GetSize() ==0) 
	{TRACE0(" GetCalRatio: no values in supplied Unknown hkl array\n");
	return(-1.0);}
if(strlen(pMin) ==0)
	{TRACE0(" GetCalRatio: supplied mineral name has zero length \n");
	return (-1.0); }
CString bin=GenerateBinName(pMin);
const CMapWordToPtr *runmap=GetMixMap(bin);
if(runmap ==NULL)
	{TRACE1(" GetCalRatio: supplied mineral name [%s] is invalid \n",pMin);
	return (-1.0);}
// mineral name, is ok
if( !CheckValidRunNo(runmap, runno))
	return (-1.0); // error in run number      
// now lets try summing the peak areas
CALIBRATION calib;
if (GetData(runmap, runno, &calib) ==NULL) return (-1.0); // error detected
// valid data retireved, sum the peak areas for inter std
CMinData *pRef=theApp.GetRefDocPtr();
float qtz_pk={0.0};
int index; // this will index which pkarea to use
for(int i =0; i<=qtz.GetUpperBound(); i++)
	{
	// we must find which index in the pkarea array in CALIBRATION contains
	// the data for the hkl in question, we get this from ref doc
	index=pRef->GetIndexToHKL(bin, qtz.GetAt(i),INTERNAL_STD);// 
	if(index >=0)
		{// found hkl in the int std data
		qtz_pk=qtz_pk+calib.IntStd.pkarea[index];
		}
		else
		TRACE1("GetCalRatio: internal std Hkl [%s] not found \n",qtz.GetAt(i));
	}
if( qtz_pk <0.01) 
	{
	CString str="Peak area for internal standard, using indicated HKL\n peaks is zero !!\n";
	str=str+"Check Calibration databases\n";
	AfxMessageBox(str);
	return (-1.0);
	}
// now do the same for the unknwon
float unk_pk={0.0};
for( i =0; i<=unk.GetUpperBound(); i++)
	{
	// we must find which index in the pkarea array in CALIBRATION contains
	// the data for the hkl in question, we get this from ref doc
	index=pRef->GetIndexToHKL(bin, unk.GetAt(i),UNKNOWN);// 
	if(index >=0)
		{// found hkl in the int std data
		unk_pk=unk_pk+calib.Unknown.pkarea[index];
		}
		else
		TRACE1("GetCalRatio: unknown  Hkl [%s] not found \n",unk.GetAt(i));
	}
if( unk_pk <0.01) 
	{
	CString str="Peak area for ";
	str=str+pMin;str=str+"  standard, using indicated HKL\n peaks is zero !!\n";
	str=str+"Check Calibration databases\n";
	AfxMessageBox(str);
	return (-1.0);
	}
// all ok
return (unk_pk/qtz_pk);
}
//--------------------------------------------------------
BOOL CMinCalibration::CheckValidRunNo(const CMapWordToPtr *runmap, int runno)
{// see if runo is valid for this runmap, returns TRUE if ok , False if not
int vr;
if( runno <1 || runno >(vr=GetNumRuns(runmap)) )
	{TRACE1(" GetCalRatio: invalid runno [%d]",runno);
	TRACE1("  Valid numbers from 0 to %d\n", vr);
	return FALSE;
	}
	else return TRUE;
}

void CMinCalibration::OnFileSave()
{
	AfxMessageBox(" About to Save Calibration data ??");
	
}

void CMinData::OnFileSave()
{    
	AfxMessageBox(" About to Save Minerals data ??");
	
}
CString CMinCalibration::GetPropStrings(const char *b_std, WORD run)
{// contsructs the string which is displayed in the proportion combo
CALIBRATION calib;
const CMapWordToPtr *Map=GetMixMap(b_std);
ASSERT(Map !=NULL);
ASSERT(run >=0 && run <=GetNumRuns(Map));
VERIFY( GetData(Map, run,&calib) !=NULL); 
double propi= calib.IntStd.Proportion;
double propu=calib.Unknown.Proportion;
char buf[FTOA_BUFFER];
VERIFY(ftoadS(propi,buf,3) <0);
CString str=buf ; // copy into string
str=str+" / ";
VERIFY(ftoadS(propu,buf,3) <0);
str=str+buf; // append unknown proportion
TRACE1("CMinCalibration::GetPropStrings [%s]\n",str);
return str;
}
//----------------------------------------------------------------------------------
float CMinCalibration::GetProportionRatio(const char *b_std, WORD run)
{// returns the ratio of the internal std wt%/ unknown wt%
CALIBRATION calib;
const CMapWordToPtr *Map=GetMixMap(b_std);
ASSERT(Map !=NULL);
ASSERT(run >=0 && run <=GetNumRuns(Map));
VERIFY( GetData(Map, run,&calib) !=NULL); 
float propi= calib.IntStd.Proportion;
float propu=calib.Unknown.Proportion;
return( propu/propi);
}