// minerl.h
// head file for mineral.cpp
// classes CMinData and CMinCalibration

 #define MAX_PEAKS	10 
 #define MAX_RUNS	MAX_PEAKS*2
 #define INTERNAL_STD	1
 #define UNKNOWN	2
 // used by CMindata
 struct REFMINERAL
	{ // contains the reference minerl hkl lines, d-spacings
		CString Mineral;
		CStringArray  Hkl;    // also records number of values entered
		float Ds[MAX_PEAKS]; 
	};
struct BINARYREF
	{ // contains the info about the binary std mix
		CString B_Standard; // name defining the binary standard mix
		REFMINERAL IntStd; // ie quartz
		REFMINERAL Unknown; // ie magneteit
	};     
extern CString INT_STD;// the internal standard, set by menu or main
static char *B_STD={"B_STANDARD"};
static char *MIN=		{"MINERAL"};
void TrimBlankTails(CString &str);

//////////////////////////////////////////
// CMinData document

class CMinData : public CDocument
{   
protected:
	DECLARE_DYNCREATE(CMinData)
	CMinData();			// protected constructor used by dynamic creation 
private:
// the field names in the db reference file
	UINT m_NumStds;        // number of ref minerals stored
	CDBFFile *m_pdbf; // pointer to openened db file
	BOOL m_DataCaptured; // == TRUE if data has been read in
	
	CMapStringToPtr m_Data; // contains a map of the binary mineral string to the BINARYREF data
	CStringArray m_Runs; // the names of binary std mixes

// Attributes
public:

// Operations
private:
BOOL RetrieveStd(BINARYREF *stds,UINT stdtype);	
BOOL ReadMinData(void);		
BOOL CheckFieldDetails(void);
public:      
	

// Implementation
	UINT GetNumberStds(void) {return m_NumStds;};
	CStringArray *GetBinaryNames(void) { return &m_Runs;};
	BINARYREF *GetBinaryRef(const char *B_name);
	int GetIndexToHKL(const char *b_std, const char *hkl, int type);
// overrides of document functions
	virtual BOOL OnOpenDocument(const char *pszPathname);
	virtual void DeleteContents() ;
//	virtual BOOL InitDocument(const char* pszPathName);
protected:
	virtual ~CMinData();

	// Generated message map functions
protected:
	//{{AFX_MSG(CMinData)
	afx_msg void OnFileSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};   
///////////////////////////////////////////////////////////////////////////////////////////
// used by CMinCalibration	
struct  PKAREA
	{// contains the peak area for a mineral
	CString Mineral;
	float Proportion; // the amount of this mineral
	float pkarea[MAX_PEAKS]; 
	};
struct CALIBRATION
	{    // contains all the pk area data for a single slide
	PKAREA IntStd; // ie qtz
	PKAREA Unknown; // ie magnteit
	};

/////////////////////////////////////////////////////////////////////////////
// CMinCalibration document

class CMinCalibration : public CDocument
{
	DECLARE_DYNCREATE(CMinCalibration) 
private:

protected:
	CMinCalibration();			// protected constructor used by dynamic creation  
private:
	CStringArray m_BMixes; // the names of binary mixes
	// maps mix names to dynmaically created CMapWordToPtr objects holdng runs
	// m_BMixes can be used to retieve the CMapWordToPtr object
	CMapStringToOb m_BinMap; 
	// maps run no to CALIBRATION struc holding data, this is dynamically created
	// when data read in so this is a temp pointer used by various routines
//	CMapWordToPtr *m_RunMap; 
	
	UINT m_NumStds; // number of binary mix stds
	CDBFFile *m_pdbf; // pointer to openened db file
	BOOL m_DataCaptured; // == TRUE if data has been read in
	 WORD RunNos[MAX_RUNS]; // holds temp run numbers

// Attributes
public:

// Operations
private:
// all to do with reading the data into internal structures
BOOL ReadCalibData(void);
BOOL AddBinaryNames(void);
CALIBRATION *GetCalibPtr(const char *mix, int run);
CALIBRATION* CreateNewCALIB(void);
CMapWordToPtr* 	CreateNewWordMap( int run, CALIBRATION *ptr);
BOOL RetrieveCalib(CALIBRATION *calib,UINT stdtype);
BOOL CheckFieldDetails(void);
BOOL CheckValidRunNo(const CMapWordToPtr *runmap, int runno);

// Implementation
protected:
	virtual ~CMinCalibration();
	virtual BOOL OnOpenDocument(const char *pszPathname);
	virtual void DeleteContents();
public: 
	const CStringArray *GetBinaryNames(void) const {return &m_BMixes;};
	const CMapWordToPtr * GetMixMap(const char *B_name);   
	WORD *GetRunNumbers(const char *B_mix);
	UINT GetNumRuns(const CMapWordToPtr *runmap) const;
	UINT GetNumBinarys(void) const {return m_NumStds;};
	CALIBRATION *GetData(const CMapWordToPtr *map, int run, CALIBRATION *data);
	int GetNumCalibrationPoints(const char *pMineral);
	float GetCalRatio(CStringArray &qtz, CStringArray &unk,
				const char *pMin, int runno);
	float GetProportionRatio(const char *b_std, WORD run);
	CString GenerateBinName(const char *pMineral);
	CString GetPropStrings(const char *b_std, WORD run);
	

	// Generated message map functions
protected:
	//{{AFX_MSG(CMinCalibration)
	afx_msg void OnFileSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

