#include "stdafx.h"
//#include "exam1.h"  
#include "readdbf.h" 
#include "\geophys\utilclas\general.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  
IMPLEMENT_DYNCREATE(CDBFFld, CObject) 
IMPLEMENT_DYNCREATE(CDBFHead,CObject)
#define new DEBUG_NEW
///////////////////////////////////////////////////////////////////////////////
CDBFFld::CDBFFld()
{}

CDBFFld::CDBFFld( size_t fwidth,UINT DecPlaces,UINT type, size_t offset)
{ // construction through this routine
m_FldWidth=fwidth;
m_boffset=offset; 
m_FldType=type;
m_DecPlaces=DecPlaces; 
#ifdef _DEBUG
		if(type == CHAR_FIELD && DecPlaces !=0) ASSERT(FALSE);
		if(type == INT_FIELD && DecPlaces !=0) ASSERT(FALSE);
#endif
}  

CString CDBFFld::LoadFld(DBFRECORD *rec) const
{  
ASSERT(rec !=NULL) ;
char *buf= new char [m_FldWidth+2]; // could throw memory exception	
ASSERT(buf !=NULL);
memcpy(buf,rec+m_boffset ,m_FldWidth); 
buf[m_FldWidth]='\0';// add null                                                              
CString str(buf);
delete [] buf;
return  str;  
}

 BOOL CDBFFld::SaveFld(DBFRECORD *rec, const char *pszval, const int pad)  
 { // put the string in str into the field at the offset
// copy string into the record, padding to left if a numeric
 // and padding to right if a character field
#ifdef _DEBUG
	CMemoryState oldstate,newstate, diff;
	oldstate.Checkpoint();
#endif
ASSERT(rec !=NULL);
ASSERT( pad == PAD_LEFT || pad == PAD_RIGHT);
ASSERT(strlen(pszval) <=m_FldWidth);
CString buf(' ',m_FldWidth+1); // make CString buffer to construct string into

 if(pad == PAD_LEFT)
 	{ 
 	int j=strlen(pszval);
 	for( size_t i=m_FldWidth; i>=m_FldWidth-strlen(pszval); i--, j--)
 		buf.SetAt(i,pszval[j-1]); // replace characters in buf from trailing end
 	}
 	else
 	{    // pad right (ie strings)
 	buf=pszval;// copy supplied string into dest buf
	if(m_FldWidth > strlen(pszval))
			{// append blanks if not fwidth in length
			for(size_t i=strlen(pszval); i<m_FldWidth; i++) buf.SetAt(i,' ');
			}
	}  
// now copy the string into the record
 memcpy(rec+m_boffset,buf,m_FldWidth); 
#ifdef _DEBUG
	newstate.Checkpoint(); //check the memory state
	if(diff.Difference(oldstate,newstate))
		{
		TRACE("memory leak ! in SaveFld\n");
		diff.DumpStatistics();
		diff.DumpAllObjectsSince();
		AfxThrowMemoryException();
		}
#endif
 return TRUE;
  }
//-------------------------------------------------------------------------------------------
CString CDBFFld::ConvertValue( double val)
{     // converts double val into string
 	char numbuf[FTOA_BUFFER]; 
 	if(  ftoa(val,numbuf,m_DecPlaces ) > 0) 
 			{ TRACE0( " Unable to convert number to ascii : in CNUmFld:PutFldValue ");
 			AfxThrowUserException();
 			}
 	// number is right justified in field
 	CString str(numbuf); 
 	 return str; 
 }  
 //-----------------------------------------------------------------------------------------
CString CDBFFld::ConvertValue( const  int val)
{     // converts integer into string
 	char numbuf[FTOA_BUFFER];
 	itoa(val,numbuf,10);   
 	// number is right justified in field 
  	CString str(numbuf); 
 	 return str; 
 }
/////////////////////////////////////////////////////////////////////////////////////////
//++++++++++++++++++++++++++++++++++++++++++++++++
// class CHeadDBF stores the info about the dbf header etc   
// Returns FALSE if an error occurs    
#define BLK_SIZE	32
#define MAX_FLD_LEN	10
CDBFHead::CDBFHead()
{ 
 	m_RecLength=0; // we set values to zero so clearly no data
	m_NumFlds=0;
	m_HeadEnd=0;
	m_NumRecords=0;
}
CDBFHead::~CDBFHead()
{ 
EraseFlds();
 }
void CDBFHead::EraseFlds(void)
{   // erase the objects stored in the map and clears the map of string keys
CObject *fld;
CString str;
for (POSITION pos=m_Flds.GetStartPosition(); pos !=NULL;)
	{
	m_Flds.GetNextAssoc(pos,str,fld);
	delete (CDBFFld *) fld;
	}
m_Flds.RemoveAll();  
	m_RecLength=0; // we set values to zero so clearly no data
	m_NumFlds=0;
	m_HeadEnd=0;
	m_NumRecords=0;
}                ;
//-------------------------------------------------------------------------
BOOL CDBFHead::ReadDBFHead(CFile *file)
/* This reads the header details on the dbf, and constructs CDBFFld 's to
 hold the field details
returns: TRUE if read in ok
throws user exceptions if an error occurs, if a CFileexception, or a memory exception
		no message is printed
		UserException: message has been displayed to the screen
*/
{
 	
	ASSERT(file->GetLength() >0);
   	DBFRECORD  *bptr ;
   		/* Allocate memory for  bytes of header blocks 	 - memory exception
   	may be thrown*/
   	TRY
   		{
		bptr = new DBFRECORD[sizeof(DBFRECORD) *BLK_SIZE];
		}
		CATCH(CMemoryException, e)
		{
		TRACE0("out of memory in ReadDBFHead\n");
		THROW_LAST();
		}
		END_CATCH
	ASSERT(bptr != NULL);
	/*    Go read the bytes BLK_SIZE at a time*/
	TRY
		{file->SeekToBegin();}
	CATCH(CFileException,e)
		{
		delete []bptr;
		THROW_LAST();
		}
		END_CATCH
	TRY
		{
		if (file->Read(bptr, BLK_SIZE) != BLK_SIZE )
			{   
	/* only gets here if reached the end of the end of the header without reading data*/
			AfxMessageBox("Truncated DBF Header found \n");
			delete [] bptr;
			AfxThrowUserException();
			return FALSE;
			} 
		}
	CATCH(CFileException, e)
		{
		TRACE0("Error in readinf fisrt dbf header block\n");
		delete []bptr;
		THROW_LAST();
		}
		END_CATCH
     // makes sure header is dbf header and converts
     TRY
     		{	ConvertNumRecords(bptr);			}
			CATCH(CUserException,e)
			{ delete []bptr; // a possible user exception
			TRACE0("Exception detected in CDBFHead::ReadDBFHead()\n");
			THROW_LAST();
			}
			END_CATCH
	// goto start of field names
	TRY {file->Seek(BLK_SIZE,CFile::begin);}
	CATCH(CFileException,e)
		{
		delete []bptr;
		THROW_LAST();
		}
		END_CATCH
	m_NumFlds=(UINT) ((m_HeadEnd-BLK_SIZE-2)/BLK_SIZE) +1;
	// now get the information about each field
     char fldname[MAX_FLD_LEN+1];
     UINT fieldwidth,dec,fldtype;                            
     size_t offset={0};
     CDBFFld *fld; // the pointer to the dynamically created field object 
//   TRACE0("ReadDBFHead: Starting to read Field Names\n"); 
	for(UINT i=0; i<m_NumFlds; i++)
		{
		TRY
			{
			if (file->Read( bptr, BLK_SIZE) != BLK_SIZE )
				{// error in reading
				AfxMessageBox(" Error in Reading  DBF header block");
				delete [] bptr;   
				EraseFlds();
				AfxThrowUserException();;
				}
			}
		CATCH(CFileException, e)
			{
			delete []bptr;
			EraseFlds();
 			THROW_LAST();
			}
		END_CATCH
	      // copy the field name into local buffer
		memcpy(fldname, bptr,MAX_FLD_LEN);
	      ASSERT(fldname[0] !='\x20'); // first character should not be space
	      // now add null after last character
	      for(int i=MAX_FLD_LEN-1; i>=0; i--)
			if(fldname[i] !='\x20') { fldname[i+1]='\x0';break;}
	      fieldwidth=(UINT) *(bptr+0x10);    // now the field widths etc
	      dec=(UINT) *(bptr+0x11);// now the places of decimals
	     fldtype=*(bptr+0x0B); // now the field type 
	     TRACE1("ReadDBFHead: FieldName=%s, ",fldname);
	     TRACE1("FieldWidth=%d, ",fieldwidth);
	     TRACE1("Decimnal places=%d",   dec);   
	     TRY
	     {
	     switch  (fldtype) 
	     		{
	     		case CHAR_FIELD: // character   
	     		TRACE0(" Char field type\n");
	     		 fld=  new CDBFFld(fieldwidth,dec,CHAR_FIELD,offset);
	     		 break;
	     		 
	     		case NUM_FIELD: // number
	     		TRACE0("  Num field type\n");
	     		if( dec ==0)
	     			 // integer   
		     		 fld= new CDBFFld(fieldwidth,dec,INT_FIELD,offset);
	     			  else  //fp
	     			  fld=  new CDBFFld(fieldwidth,dec,NUM_FIELD,offset); 
	     		break;
	     		
	     		default:
			/* only gets here if error in decoding fld type*/
			AfxMessageBox(" Field name format incorrect/unknown in  DBF header block");
				delete [] bptr; 
				EraseFlds(); // clean up allocated mem
	     		AfxThrowUserException();
	     		}		// end of switch
	     	}// end of try
	     	CATCH(CUserException,e)
	     		{// exception trhown by CDBFFld-internal error
				delete [] bptr; 
				EraseFlds(); // clean up allocated mem
	     		THROW_LAST();
	     		}	
	     	AND_CATCH(CException,e)
	     		{
	     		AfxMessageBox("Exception detected in ReadDBFHead- from CDBFFld");
				delete [] bptr; 
				EraseFlds(); // clean up allocated mem
	     		THROW_LAST();
	     		}
		END_CATCH
	     TRACE1("ReadDBFHead: field data at Offset=%X \n",offset);
		ASSERT (fld !=NULL);
			// places new name into array
         m_FldNames.Add(fldname);
		m_Flds[fldname]=fld;  // add the field to the map
       	offset=offset+fieldwidth;// calc offset for next field
	     }  //end of for loop
delete[]  bptr; 
TRACE0("ReadDBFHead: Sucess in reading in header details\n");
return TRUE;   
}   
//////////////////////////////////////////////////////////////
BOOL CDBFHead::ConvertNumRecords( DBFRECORD *bptr)
{ //converts the num records and checks fisrt header line
// returns FALSE if not db header
ASSERT(bptr !=NULL);
if (*bptr != 0x03 )           
	{
	AfxMessageBox ("This is not recognised as \n a DBase iii file");  
	AfxThrowUserException();
	}
m_NumRecords= (long) (*(bptr+4) + *(bptr+5)*256) ;// get number of records
m_HeadEnd=(size_t) (*(bptr+8) + *(bptr+9)*256); // the end of header offset  
ASSERT(m_HeadEnd > BLK_SIZE);
m_RecLength= (*(bptr+0x0A) +*(bptr+0x0B)*256);// length of data record
ASSERT(m_RecLength >0);  
// now the date
char numbuf[FTOA_BUFFER];
m_Date.Empty();
UINT i=*(bptr+3); // the day
itoa(i,numbuf,10);   
m_Date=strcat(numbuf,"/");
i=*(bptr+2);itoa(i,numbuf,10);
m_Date=m_Date+strcat(numbuf,"/");
i=*(bptr+1);itoa(i,numbuf,10);
m_Date=m_Date+numbuf;
TRACE1("OK ConvertNumRecords:  numrecords=%ld, ",m_NumRecords);
TRACE1("  HeadEnd= %d ,",m_HeadEnd);
TRACE1("reclength=%d \n", m_RecLength);
TRACE1("File date: %s\n",m_Date);
return TRUE;
}  

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CString  CDBFHead:: id2FldName(UINT fld_id)  const
// converts fld_id into name  returning a pointer
// to a static space which contains the field name
{
	CheckFldid(fld_id)  ; // runs check on fld_id
	return (m_FldNames.GetAt(fld_id));// returns  to string
}      
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++    
UINT CDBFHead::FldName2id(const char* fld)  const
{ // converts the fiel;d name in its id umber, returns INVALID_FIELD_NAME
// if name not known . The Stored field names always end on the last character
UINT  i;
ASSERT( strlen(fld) <= MAX_FLD_LEN);  // check is not larger than req
CString f=fld;
for ( i=0; i< m_NumFlds; i++)
	{
	// compare strings ignoring case
	if((f.CompareNoCase( m_FldNames.GetAt(i) )) ==0)
			{
			CheckFldid(i);
			return (i); // found identical string
			}
	}
return (INVALID_FIELD_NAME);
} 
// ++++++++++++++++++++++++++++++++++++++++++++++++++++
BOOL  CDBFHead::CheckFldid(UINT fld_id)  const
{ // checks the field id to see if valid
// if one of errors then prints message on screen and returns FALSE
if(fld_id == INVALID_FIELD_NAME)
		{
		AfxMessageBox(" Unknown Field Name Supplied as argument to CDBFHead");
		return FALSE;
		}
ASSERT(fld_id >=0 && fld_id <m_NumFlds );
return TRUE;
} 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
CDBFFld *CDBFHead::GetFldPtr(UINT fld_id)  const
{
CObject* fld;
VERIFY(m_Flds.Lookup(m_FldNames[fld_id],fld));
return (CDBFFld *) fld;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
CDBFFld *CDBFHead::GetFldPtr(const char *fldstr) const
{
CObject* fld;
ASSERT(fldstr[0] !=0);
VERIFY(m_Flds.Lookup(fldstr,fld));
return (CDBFFld *) fld; 
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifdef _DEBUG
void CDBFHead:: AssertValid() const
{
	CObject::AssertValid(); // call inherited assertvalid
	m_Flds.AssertValid(); 
	m_FldNames.AssertValid();
	ASSERT(m_RecLength >0);
	ASSERT(m_NumFlds >0);
	ASSERT(m_HeadEnd >0); 
	ASSERT(m_NumFlds == (UINT) m_FldNames.GetSize());
	ASSERT(m_NumFlds == (UINT) m_Flds.GetCount());
}
void CDBFHead:: Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
	dc << "m_NumRecords= " << m_NumRecords << "\n"
	<< "m_RecLength =" << m_RecLength
	<< "m_NumFlds = " << m_NumFlds
	<< "m_HeadEnd= " << m_HeadEnd ;
	dc.SetDepth(1);
	dc << "m_FldNames= " << m_FldNames << "\n";
	dc << "Map : "<<m_Flds<<"\n";
}
#endif   
