// xrdref.cpp : implementation file
//

#include "stdafx.h"
#include "readdbf.h"
#include "mineral.h"
#include "exam1.h"
#include "xrdref.h" 
#include "xrdfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXRDRefForm

IMPLEMENT_DYNCREATE(CXRDRefForm, CFormView)

CXRDRefForm::CXRDRefForm()
	: CFormView(CXRDRefForm::IDD)
{
	//{{AFX_DATA_INIT(CXRDRefForm)
	m_d1 = 0;
	m_d10 = 0;
	m_d2 = 0;
	m_d3 = 0;
	m_d4 = 0;
	m_d5 = 0;
	m_d6 = 0;
	m_d7 = 0;
	m_d8 = 0;
	m_d9 = 0;
	m_hkl1 = "";
	m_hkl10 = "";
	m_hkl2 = "";
	m_hkl3 = "";
	m_hkl4 = "";
	m_hkl5 = "";
	m_hkl6 = "";
	m_hkl7 = "";
	m_hkl8 = "";
	m_hkl9 = "";
	//}}AFX_DATA_INIT 
	pd_space[0]=&m_d1;
	pd_space[1]=&m_d2 ;
	pd_space[2]=&m_d3 ;
	pd_space[3]=&m_d4 ;
	pd_space[4]=&m_d5 ;
	pd_space[5]=&m_d6 ;
	pd_space[6]=&m_d7 ;
	pd_space[7]=&m_d8 ;
	pd_space[8]=&m_d9 ;   
	pd_space[9]=&m_d10 ;
	m_phkl.SetSize(MAX_PEAKS);
	m_phkl[0]=&m_hkl1 ;
	m_phkl[1]=&m_hkl2 ;
	m_phkl[2]=&m_hkl3 ;
	m_phkl[3]=&m_hkl4 ;
	m_phkl[4]=&m_hkl5 ;
	m_phkl[5]=&m_hkl6 ;
	m_phkl[6]=&m_hkl7 ;
	m_phkl[7]=&m_hkl8 ;
	m_phkl[8]=&m_hkl9 ;
	m_phkl[9]=&m_hkl10 ;
	
}

CXRDRefForm::~CXRDRefForm()
{
}

void CXRDRefForm::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXRDRefForm)
	DDX_Control(pDX, IDC_COMBO_MINERAL, m_ComMineral);
	DDX_Control(pDX, IDC_COMBO_BINSTD, m_ComBinary);
	DDX_Text(pDX, IDC_D_SPACE1, m_d1);
	DDX_Text(pDX, IDC_D_SPACE10, m_d10);
	DDX_Text(pDX, IDC_D_SPACE2, m_d2);
	DDX_Text(pDX, IDC_D_SPACE3, m_d3);
	DDX_Text(pDX, IDC_D_SPACE4, m_d4);
	DDX_Text(pDX, IDC_D_SPACE5, m_d5);
	DDX_Text(pDX, IDC_D_SPACE6, m_d6);
	DDX_Text(pDX, IDC_D_SPACE7, m_d7);
	DDX_Text(pDX, IDC_D_SPACE8, m_d8);
	DDX_Text(pDX, IDC_D_SPACE9, m_d9);
	DDX_Text(pDX, IDC_HKL1, m_hkl1);
	DDX_Text(pDX, IDC_HKL10, m_hkl10);
	DDX_Text(pDX, IDC_HKL2, m_hkl2);
	DDX_Text(pDX, IDC_HKL3, m_hkl3);
	DDX_Text(pDX, IDC_HKL4, m_hkl4);
	DDX_Text(pDX, IDC_HKL5, m_hkl5);
	DDX_Text(pDX, IDC_HKL6, m_hkl6);
	DDX_Text(pDX, IDC_HKL7, m_hkl7);
	DDX_Text(pDX, IDC_HKL8, m_hkl8);
	DDX_Text(pDX, IDC_HKL9, m_hkl9);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXRDRefForm, CFormView)
	//{{AFX_MSG_MAP(CXRDRefForm)
	ON_CBN_CLOSEUP(IDC_COMBO_BINSTD, OnCloseupComboBinstd)
	ON_CBN_CLOSEUP(IDC_COMBO_MINERAL, OnCloseupComboMineral)
	ON_BN_CLICKED(IDCANCEL, OnCloseForm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()                                       


void CXRDRefForm::SetNewMinerals(BINARYREF *ref)
{
int cursel;
// first clear the combo box
	  m_ComMineral.ResetContent(); 
	  // now add the minera;s
	   m_ComMineral.AddString(ref->IntStd.Mineral); // copy to combo box
	   m_ComMineral.AddString(ref->Unknown.Mineral);
	   m_ComMineral.SetCurSel(0); // sets the first one
	   VERIFY( (cursel=m_ComMineral.GetCurSel() ) !=CB_ERR);
	   m_ComMineral.GetLBText(cursel, m_Mineral); // get set name
}

void  CXRDRefForm::OnUpdate(CView *psender, LPARAM lhint, CObject *phint)
{
// lhint parameter =0, and phint=NULL when initially starting
if(lhint ==0 && phint ==NULL)
	{ // ie when box first drawn
	int cursel;
	CStringArray *names=GetDocument()->GetBinaryNames();  
	  for(int i=0; i<= names->GetUpperBound(); i++)
	  	{ // add strings to binary names box
	  	  m_ComBinary.AddString(  names->GetAt(i)); // adds to combo box
	  	  }
	   m_ComBinary.SetCurSel(0); // sets the first item
	   VERIFY( (cursel=m_ComBinary.GetCurSel()) !=CB_ERR);
	   m_ComBinary.GetLBText(cursel, m_BinStd);// gets the sorted string
	   // now set the mineral name
	   BINARYREF *ref=GetDocument()-> GetBinaryRef(m_BinStd);
	   SetNewMinerals(ref);
	   // now set the other details
	SetVariables(); // copy changed variables
	UpdateData(	FALSE); // copy to dialog
	}
	else
	{   // lhint !=0
	SetVariables(); // copy changed variables
	UpdateData(	FALSE); // copy to dialog
	}
}

void CXRDRefForm::OnCloseupComboBinstd()
{   // this is called when the value in the bianry stanrdas box has changed
	// we need to find the value and then call updateForn
int cursel;
CString str;
VERIFY( (cursel=m_ComBinary.GetCurSel() ) !=CB_ERR);
m_ComBinary.GetLBText(cursel, str); // get set name
// if different then redraw box
if(str.CompareNoCase(m_BinStd)  !=0)
	{
// since name in mineral combo box may not be internal std we must set it to be Int std 
	m_BinStd=str;
	BINARYREF *ref=GetDocument()-> GetBinaryRef(m_BinStd);
	SetNewMinerals(ref);
	OnUpdate(this,1,NULL);
	}
}

void CXRDRefForm::OnCloseupComboMineral()
{ // this is called when the value of the mineral has changed	
	// we find what this is and call OnUpdate
int cursel;   
CString str;
VERIFY( (cursel=m_ComMineral.GetCurSel() ) !=CB_ERR);
m_ComMineral.GetLBText(cursel, str); // get set name  
if(str.CompareNoCase(m_Mineral)  !=0)
	{
	m_Mineral=str;
	OnUpdate(this,1,NULL); 
	}
}

void CXRDRefForm::SetVariables()
{ // sets the variables to those specified by the m_BinStd and m_Mineral
float val;
BINARYREF *ref=GetDocument()->GetBinaryRef(m_BinStd);
if( m_Mineral.CompareNoCase(INT_STD)  == 0)
	{ // internal std data
/* have to be aware that there may be no valid data for some of these */  
	TRACE1("setting Internal: [%s] std variables\n",m_Mineral);
	for(int i=0; i<MAX_PEAKS; i++)
		{
		val=*pd_space[i]=ref->IntStd.Ds[i];
		if( ref->IntStd.Ds[i] >0.0 )  
				*((CString *) m_phkl[i])=ref->IntStd.Hkl[i]; 
			else *((CString *) m_phkl[i]) =""; // empty string
		TRACE1("[%s]: ", *((CString *) m_phkl[i]));
		TRACE1(" %5.2f, ",val);
		}
		TRACE0(" \n");
	}
    else
    {   // the unknown    
	TRACE1("Setting Unknown: [%s]  std variables\n",m_Mineral);
	for(int i=0; i<MAX_PEAKS; i++)
		{
		val=*pd_space[i]=ref->Unknown.Ds[i];
		if( ref->Unknown.Ds[i] >0.0 ) 
				*((CString *) m_phkl[i])=ref->Unknown.Hkl[i]; 
			else *((CString *) m_phkl[i]) =""; // empty string
		TRACE1("[%s]: ", *((CString *) m_phkl[i]));
		TRACE1(" %5.2f, ",val);
		}
		TRACE0( "\n");
    }
}

void CXRDRefForm::OnCloseForm()
{                                                                              
//CDocument *pDoc=GetDocument()
//::CloseWindow(CWnd::GetActiveWindow->m_hWnd); 
CXRDFrame *pframe=(CXRDFrame *) GetParentFrame();
if(pframe->IsKindOf(RUNTIME_CLASS(CXRDFrame)))
	pframe->OnCloseDlg();
}
                