// xrdref.h : header file
//
// this is the header file for the diaolog view of the
// xrd reference minerals data
/////////////////////////////////////////////////////////////////////////////
// CXRDRefForm form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CXRDRefForm : public CFormView
{
	DECLARE_DYNCREATE(CXRDRefForm)
protected:
	CXRDRefForm();			// protected constructor used by dynamic creation
	CString m_BinStd; // holds the current binary std
	CString m_Mineral; // holds the current mineral
	CPtrArray m_phkl; // pointer to hkl Cstrings
	float *pd_space[MAX_PEAKS]; // pointers to d-sapcings

// Form Data
public:
	//{{AFX_DATA(CXRDRefForm)
	enum { IDD = IDD_XRDREF_FORM };
	CComboBox	m_ComMineral;
	CComboBox	m_ComBinary;
	float	m_d1;
	float	m_d10;
	float	m_d2;
	float	m_d3;
	float	m_d4;
	float	m_d5;
	float	m_d6;
	float	m_d7;
	float	m_d8;
	float	m_d9;
	CString	m_hkl1;
	CString	m_hkl10;
	CString	m_hkl2;
	CString	m_hkl3;
	CString	m_hkl4;
	CString	m_hkl5;
	CString	m_hkl6;
	CString	m_hkl7;
	CString	m_hkl8;
	CString	m_hkl9;
	//}}AFX_DATA

// Attributes
public:                                                          

// Operations
public:
CMinData * GetDocument(void)
	{ ASSERT( m_pDocument ->IsKindOf(RUNTIME_CLASS(CMinData))) ;
	return (CMinData *) m_pDocument;
     }
// Implementation
protected:
	void SetNewMinerals(BINARYREF *ref) ;
	void SetVariables(void);
    virtual void OnUpdate(CView *psender, LPARAM lhint, CObject *phint);
	virtual ~CXRDRefForm();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	// Generated message map functions
	//{{AFX_MSG(CXRDRefForm)
	afx_msg void OnCloseupComboBinstd();
	afx_msg void OnCloseupComboMineral();
	afx_msg void OnCloseForm();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

