// XRDstds.cpp : implementation file
//

#include "stdafx.h"
#include "readdbf.h"
#include "mineral.h"
#include "exam1.h" 
#include "XRDstds.h"  
#include "\geophys\utilclas\general.h"  
#include "xrdfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXRDStdForm

IMPLEMENT_DYNCREATE(CXRDStdForm, CFormView)

CXRDStdForm::CXRDStdForm()
	: CFormView(CXRDStdForm::IDD)
{
	//{{AFX_DATA_INIT(CXRDStdForm)
	m_area1 = 0;
	m_area10 = 0;
	m_area2 = 0;
	m_area3 = 0;
	m_area4 = 0;
	m_area5 = 0;
	m_area6 = 0;
	m_area7 = 0;
	m_area8 = 0;
	m_area9 = 0;
	m_IntStd = "";
	m_Unknown = "";
	m_area11 = 0;
	m_area12 = 0;
	m_area13 = 0;
	m_area14 = 0;
	m_area15 = 0;
	m_area16 = 0;
	m_area17 = 0;
	m_area18 = 0;
	m_area19 = 0;
	m_area20 = 0;
	//}}AFX_DATA_INIT
	area[0][0]=&m_area1; // internal std
	area[1][0]=&m_area2;
	area[2][0]=&m_area3;
	area[3][0]=&m_area4;
	area[4][0]=&m_area5;
	area[5][0]=&m_area6;
	area[6][0]=&m_area7;
	area[7][0]=&m_area8;
	area[8][0]=&m_area9;
	area[9][0]=&m_area10;
	area[0][1]=&m_area11; // unknowns
	area[1][1]=&m_area12;
	area[2][1]=&m_area13;
	area[3][1]=&m_area14;
	area[4][1]=&m_area15;
	area[5][1]=&m_area16;
	area[6][1]=&m_area17;
	area[7][1]=&m_area18;
	area[8][1]=&m_area19;
	area[9][1]=&m_area20;
	m_CurRun=-1;
}

CXRDStdForm::~CXRDStdForm()
{
}

void CXRDStdForm::OnUpdate(CView *psender, LPARAM lhint, CObject *phint)
{
// lhint =0 , phint ==NULL when initialising the dialog
// lhint=1 when changed the binary std name
// lhint=2 when changed the proportion string 
if(lhint ==0 && phint ==NULL)
	{
	int cursel,err;
	CMinCalibration *pDoc=GetDocument();
	ASSERT(pDoc !=NULL);
	const CStringArray *names=pDoc->GetBinaryNames();  
	ASSERT(names !=NULL);
	m_ComBinary.ResetContent();// makes sure empty
	  for(int i=0; i<= names->GetUpperBound(); i++)
	  	{ // add strings to binary names box
	  	  if( (err=m_ComBinary.AddString(  names->GetAt(i)) )== CB_ERR)
	  	  		TRACE0(" error in asigning string to combo box:CXRDStdForm::OnInitialUpdate\n");
	  	  if(err==CB_ERRSPACE) 
	  	  	TRACE0(" in sufficient memory space in: CXRDStdForm::OnInitialUpdate\n");	
	  	  }
	   m_ComBinary.SetCurSel(0); // sets the first item in the binary names
	   VERIFY( (cursel=m_ComBinary.GetCurSel()) !=CB_ERR);
	   // gets the sorted string
	   m_ComBinary.GetLBText(cursel,  m_BinStd);
	   ASSERT(!m_BinStd.IsEmpty());
	SetProportionStrings();// binary std changed
	SetFormData();	
	VERIFY(UpdateData(FALSE) !=0);
	}
	else
	{
	if(lhint ==1)			SetProportionStrings();// binary std changed
	SetFormData();	
	VERIFY(UpdateData(FALSE) !=0);
	}
}

void CXRDStdForm::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXRDStdForm)
	DDX_Control(pDX, IDC_COMBO_PROP, m_ComProportion);
	DDX_Control(pDX, IDC_COMBO_BINSTD, m_ComBinary);
	DDX_Text(pDX, IDC_PKAREA1, m_area1);
	DDX_Text(pDX, IDC_PKAREA10, m_area10);
	DDX_Text(pDX, IDC_PKAREA2, m_area2);
	DDX_Text(pDX, IDC_PKAREA3, m_area3);
	DDX_Text(pDX, IDC_PKAREA4, m_area4);
	DDX_Text(pDX, IDC_PKAREA5, m_area5);
	DDX_Text(pDX, IDC_PKAREA6, m_area6);
	DDX_Text(pDX, IDC_PKAREA7, m_area7);
	DDX_Text(pDX, IDC_PKAREA8, m_area8);
	DDX_Text(pDX, IDC_PKAREA9, m_area9);
	DDX_Text(pDX, IDC_INT_STD, m_IntStd);
	DDX_Text(pDX, IDC_UNKNOWN, m_Unknown);
	DDX_Text(pDX, IDC_PKAREA11, m_area11);
	DDX_Text(pDX, IDC_PKAREA12, m_area12);
	DDX_Text(pDX, IDC_PKAREA13, m_area13);
	DDX_Text(pDX, IDC_PKAREA14, m_area14);
	DDX_Text(pDX, IDC_PKAREA15, m_area15);
	DDX_Text(pDX, IDC_PKAREA16, m_area16);
	DDX_Text(pDX, IDC_PKAREA17, m_area17);
	DDX_Text(pDX, IDC_PKAREA18, m_area18);
	DDX_Text(pDX, IDC_PKAREA19, m_area19);
	DDX_Text(pDX, IDC_PKAREA20, m_area20);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXRDStdForm, CFormView)
	//{{AFX_MSG_MAP(CXRDStdForm)
	ON_CBN_CLOSEUP(IDC_COMBO_BINSTD, OnCloseupComboBinstd)
	ON_CBN_CLOSEUP(IDC_COMBO_PROP, OnCloseupComboProp)
	ON_BN_CLICKED(IDCANCEL, OnCloseForm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXRDStdForm message handlers

void CXRDStdForm::SetFormData(void)
{ 
// fills m_Calib structure with current displayed data
ASSERT(m_Map !=NULL); // map set by SetProportionStrings
CMinCalibration *pDoc=GetDocument();
// m_CurRun set by SetProportionStrings
ASSERT(m_CurRun >=0 && m_CurRun   <=pDoc->GetNumRuns(m_Map));  
// get the CALIBRATION structure holding data for this run
VERIFY( (pDoc->GetData(
				m_Map, m_Runnos[m_CurRun],&m_Calib)) !=NULL); 
// copy values into dilaog box variables
ASSERT(m_Calib.IntStd.Mineral.IsEmpty() !=TRUE);
m_IntStd=m_Calib.IntStd.Mineral; // copy over int std name
ASSERT(m_Calib.Unknown.Mineral.IsEmpty() !=TRUE);
m_Unknown=m_Calib.Unknown.Mineral;
TRACE1("CXRDStdForm::SetFormData(), int std=[%s]",m_IntStd);
TRACE1("  Unknown=[%s]",m_Unknown);
TRACE1(" run number=%d\n",m_Runnos[m_CurRun]);
SetVariables();
}


void CXRDStdForm::SetProportionStrings(void)
{   /* this sets the combo box which contains the proportions with
strings which show the internal std, unknown values
and also sets the current run=0 displayed: m_CurRun
*/
int i,err;
CMinCalibration *pDoc=GetDocument();  
ASSERT(pDoc !=NULL);
ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CMinCalibration)));
// now get the map which is used to access the calibration data   
ASSERT(m_BinStd.IsEmpty() ==FALSE);
m_Map=(CMapWordToPtr *) pDoc-> GetMixMap(m_BinStd);  
ASSERT(m_Map !=NULL); 
TRACE0("CXRDStdForm::SetPropStrings , poniter to Map set\n");
m_Runnos=pDoc->GetRunNumbers(m_BinStd); // gets array of run nos 
ASSERT(m_Runnos !=NULL);
	   // now add the propoetions to the combo box as an
	   // internal std / unknown pair
// since this can be called repreatedly we should check that
// combo box is empty before starting to add  new strings
if ((i=m_ComProportion.GetCount()) >0)
			m_ComProportion. ResetContent();
// now add the strings
for ( i=0; i<(int) pDoc->GetNumRuns(m_Map); i++)
	   	{
	     VERIFY((err=m_ComProportion.AddString(
	     		pDoc->GetPropStrings(m_BinStd, m_Runnos[i]))) !=CB_ERR); // copy to combo box
	     	ASSERT(err !=CB_ERRSPACE);
	     }
VERIFY(m_ComProportion.SetCurSel(0) !=CB_ERR); // sets the first one
// note strings in combo box should not be sorted, other wise
// could not keep track of which one set
VERIFY( (m_CurRun=m_ComProportion.GetCurSel() ) !=CB_ERR); 
TRACE1("CXRDStdForm::SetProportionStrings, current run=[%d]\n",m_CurRun);
}

void CXRDStdForm::SetVariables(void)
{ // fills the form variables with  areas of the internal std and the unknown
TRACE0(" CXRDStdForm::SetVariables Setting variables\n");
TRACE0("int std: ");
for(int i=0; i<MAX_PEAKS; i++)
	{
	*area[i][0]=m_Calib.IntStd.pkarea[i];
	TRACE1("%7.1f, ",*area[i][0]);
	}
// unknowns
TRACE("\nUnknowns: ");
for( i=0; i<MAX_PEAKS; i++)
	{
	*area[i][1]=m_Calib.Unknown.pkarea[i];
	TRACE1("%7.1f, ",*area[i][1]);
	}
TRACE0(" \n");
}

void CXRDStdForm::OnCloseupComboBinstd()
{
int cursel;
VERIFY( (cursel=m_ComBinary.GetCurSel() ) !=CB_ERR); 
CString newname;
m_ComBinary.GetLBText(cursel, newname); // get possible new name 
ASSERT(!newname.IsEmpty());
// if same as old name then do nothing
if(newname.CompareNoCase(m_BinStd) ==0 ) return; 
m_BinStd=newname;
OnUpdate(this,1,GetDocument());
}

void CXRDStdForm::OnCloseupComboProp()
{
int cursel;
VERIFY( ( cursel=m_ComProportion.GetCurSel() ) !=CB_ERR); 
// if new selection is same as old do nothing
if (cursel == (int) m_CurRun) return;
m_CurRun=cursel;
// copy new values into local CALIBRATION buffer 
OnUpdate(this,2,GetDocument());
}


void CXRDStdForm::OnCloseForm()
{
CXRDFrame *pframe=(CXRDFrame *) GetParentFrame();
if(pframe->IsKindOf(RUNTIME_CLASS(CXRDStdFrame)))
	pframe->OnCloseDlg();
	
}
