// cubiclat.cpp : implementation file
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "..\utilclas\general.h"
#include "qxrddoc.h"
#include "qntxrd.h"
#include "cubiclat.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// CCubicLat dialog

CCubicLat::CCubicLat(CWnd* pParent /*=NULL*/)
	: CDialog(CCubicLat::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCubicLat)
	m_D_Space = 0;
	m_hkl = "";
	m_LatticeDimension = 0;
	m_Radiation = CU;
	m_Units = THETA;
	m_Wavelength = ALPHA1;
	//}}AFX_DATA_INIT
}
BOOL CCubicLat::OnInitDialog()
{
CDialog::OnInitDialog();
m_MeasUnits.SetWindowText("2-Theta:");
return (-1);
}

void CCubicLat::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCubicLat)
	DDX_Control(pDX, IDC_UNITS, m_MeasUnits);
	DDX_Text(pDX, IDC_D_SPACEING, m_D_Space);
	DDV_MinMaxFloat(pDX, m_D_Space, 0., 180.);
	DDX_Text(pDX, IDC_HKL, m_hkl);
	DDV_MaxChars(pDX, m_hkl, 6);
	DDX_Text(pDX, IDC_LAT_SPACE, m_LatticeDimension);
	DDX_Radio(pDX, IDC_RAD1, m_Radiation);
	DDX_Radio(pDX, IDC_UNITS1, m_Units);
	DDX_Radio(pDX, IDC_WAVE1, m_Wavelength);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCubicLat, CDialog)
	//{{AFX_MSG_MAP(CCubicLat)
	ON_BN_CLICKED(IDC_UNITS1, OnClickedUnits)
	ON_BN_CLICKED(IDC_UNITS2, OnClickedUnits)
	ON_EN_KILLFOCUS(IDC_D_SPACEING, OnKillfocusDSpaceing)
	ON_EN_KILLFOCUS(IDC_HKL, OnKillfocusHkl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CCubicLat message handlers

void CCubicLat::OnOK()
{
//	CDialog::OnOK();
	UpdateData(TRUE);
	CalculateCubic();
	UpdateData(FALSE);
}

void CCubicLat::CalculateCubic()
{// calculates the actual lattice dimension, and put into m_LatticeDimension
float lambda[3][3]={1.54186F,1.54060F,1.54439F, //cu
						0.71073F,0.70930F,0.71359F,    //mo
						1.79026F,1.78896F,1.79285F};   //co
float ds,wavel;						
// first do various checks
if(m_Wavelength <ALPHA || m_Wavelength >ALPHA2  || HKL.GetLength() !=3)	
		return;
if(m_Units <THETA || m_Units >D_SPACE) return;
switch (m_Radiation)
	{ // find wavelength of radiation
	case CU:
	wavel=lambda[0][m_Wavelength]	;break;
	case MO:
	wavel=lambda[1][m_Wavelength]	;break;
	case CO:
	wavel=lambda[2][m_Wavelength]	;break;
	default: return;
	}
if(m_Units == THETA)
	{
	ds=wavel/(2.0F* (float) sin(Rad(m_D_Space/2.0F))); // convert to d-spacing
	}
	else ds=m_D_Space;
// now convert hkl into individual indexes
float h=(float) (HKL[0]	-'0');
float k =(float) (HKL[1] -'0');
float l =(float) (HKL[2] -'0');
// now the calc
m_LatticeDimension=(float) sqrt(ds*ds*(h*h+k*k+l*l));
}
void CCubicLat::OnClickedUnits()
{
	UpdateData(TRUE);	
	 if(m_Units == THETA)
	 	m_MeasUnits.SetWindowText("2-Theta:");
	 	else
		m_MeasUnits.SetWindowText("D-Spacing:");
	UpdateData(FALSE);
}

void CCubicLat::OnKillfocusDSpaceing()
{// we need to check if valid hkl value displayed, if so then do calc
UpdateData(TRUE);
if(m_D_Space >1e-3 && m_hkl.GetLength() ==3)
	{ 
	CalculateCubic();
	UpdateData(FALSE);
	}
}

void CCubicLat::OnKillfocusHkl()
{  // we need to check if valid d-spacing, if so then do calc
	HKL.Empty();
	UpdateData(TRUE);
	if(m_hkl.IsEmpty()) return;
	for(int i=0; i<m_hkl.GetLength(); i++)
		{
		if (m_hkl[i] >= '0' && m_hkl[i] <='9') HKL+=m_hkl[i];
		}
if(m_D_Space >1e-3 && HKL.GetLength() ==3)
	{ 
	CalculateCubic();
	UpdateData(FALSE);
	}
}
