// datavw.cpp : implementation file
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "..\utilclas\general.h"
#include "..\utilclas\floatarr.h"
#include  "qxrddoc.h"
#include "qntxrd.h"
#include "datavw.h"
#include <math.h>
#include "ratiodlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#define CHECK_FLAG	'' 	// asci 175

/////////////////////////////////////////////////////////////////////////////
// CDataVw

IMPLEMENT_DYNCREATE(CDataVw, CFormView)
#define new DEBUG_NEW

CDataVw::CDataVw()
	: CFormView(CDataVw::IDD)
{
	//{{AFX_DATA_INIT(CDataVw)
	m_DataName = "";
	m_Comment = "";
	m_PkArea = 0;
	//}}AFX_DATA_INIT
	m_CurMin="";
	m_CurHKL="";
}

CDataVw::~CDataVw()
{
}

void CDataVw::OnUpdate(CView *psender, LPARAM lhint, CObject *phint)
{
if( lhint ==0)
	{
	if( phint ==NULL)
		{
//Sets up the data from the document before it is displayed
		CQntxrdDoc *pDoc=GetDocument();
		ASSERT(pDoc !=NULL);
		m_DataName=pDoc->Getname(); // gets the data name
		m_Comment=pDoc->GetComment(); 
		CStringArray minerals; // will contain all minerals in calibration dbf
		pDoc->GetMineralsFromDBF(minerals);
// add Mineral names to the mineral combo box
		m_Minerals.ResetContent();
		int cursel;
		for(int i=0; i<=minerals.GetUpperBound(); i++) 
			{
			cursel=m_Minerals.AddString(minerals.GetAt(i));
			TRACE1("CDataVw:OnInitialUpdate, combo box selection=%d\n",cursel);
			if(cursel ==CB_ERRSPACE)
				TRACE0("Insuffieceitn memory space for combo\n");
			}
		if( minerals.GetSize() !=m_Minerals.GetCount())
			TRACE1("# combo box strings less than expected= %d\n",m_Minerals.GetCount());
		VERIFY(m_Minerals.SetCurSel(0) !=CB_ERR);// sets first item nb. box is sorted by combo
		VERIFY((cursel=m_Minerals.GetCurSel()) !=CB_ERR);
		m_Minerals.GetLBText(cursel, m_CurMin); // gets first item in sorted list
		ASSERT(!m_CurMin.IsEmpty());
		}
// now set the HKL, d-spacing list
	SetHKLList();
	SetPkarea();
	UpdateData(FALSE);
	}
	else // updating when only peakList selected
	{
	if(lhint ==1) 
			{
			SetPkarea();
			UpdateData(FALSE);
			}
	}
}

void CDataVw::SetHKLList(void)
{// sets details of HKL, d-spacing list given a mineral
// the internal standard is a special case
ASSERT(m_CurMin.GetLength() >0);
CStringArray hkl;// the hkl values
CStringArray ds; // the d-spacings
CQntxrdDoc *pDoc=GetDocument();
pDoc->GetHKLs(m_CurMin, hkl); // gets the hkl strings
pDoc->GetD_Space(m_CurMin, ds); // fills ds with d-spacings
ASSERT(hkl.GetSize() == ds.GetSize()); // should be same size
SortLists(ds,hkl,1); // sorts the list in on ds - ascending

m_PeakList.ResetContent();// deletes all items
CString str;
for(int i=0; i<=hkl.GetUpperBound(); i++)
	{// add items to list box
	m_PeakList.AddString(SetHklString(hkl[i],ds[i]));
	}
// now set the list box to select item 0, and dispaly the pkarea of this
m_PeakList.SetCurSel(0);
VERIFY((m_OldSel= m_PeakList.GetCurSel() ) !=CB_ERR);
// now check that is in correct order- as expected
m_PeakList.GetText(m_OldSel, str);
m_CurHKL=hkl[0];// set first item to currenmt hkl
str=str.Right(ds[0].GetLength()); // extracts right bit from which should match
if( ds[0].Compare(str) !=0)
	   {
	   TRACE0("CDataVw::SetHKLList , CListbox comparison failed\n");
		ASSERT(FALSE);
		} 
// all ok
}
//-----------------------------------------------------------------------------------------------
#define HKL_PAD_LEN   22
CString CDataVw::SetHklString( const char *phkl, const char *pds)
{// constrcuts the string which is displayed in the list box
CString str;
CString blank ="                                                                               ";
PEAK *pdata=GetDocument()->GetPeak(m_CurMin, phkl);
	// but first contsruct the string to diaplay
if(pdata == NULL) str=" ";
		else str=CHECK_FLAG;
str=str+" [";
str=str+phkl+"]  ";// the check and hkl completed
ASSERT(str.GetLength() < HKL_PAD_LEN);
str=str+blank.Left(HKL_PAD_LEN-str.GetLength());// pads to constant length
str=str+pds;// string complete
return str;
}
//---------------------------------------------------------------------------------------------------
void CDataVw::SetPkarea(void)
{
PEAK *pdata; // a pointer to data
CQntxrdDoc *pDoc=GetDocument();
pdata=pDoc->GetPeak(m_CurMin, m_CurHKL);
if(pdata ==NULL) m_PkArea=0.0;
	else m_PkArea=pdata->pkarea;
m_Oldarea=(long) ceil( (double) (m_PkArea*100.0F) );// convert to integer to compare
}

void CDataVw::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDataVw)
	DDX_Control(pDX, IDC_PEAKS_LIST, m_PeakList);
	DDX_Control(pDX, IDC_MINERALS, m_Minerals);
	DDX_Text(pDX, IDC_DATA_NAME, m_DataName);
	DDX_Text(pDX, IDC_COMMENT, m_Comment);
	DDX_Text(pDX, IDC_PEAK_AREA, m_PkArea);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDataVw, CFormView)
	//{{AFX_MSG_MAP(CDataVw)
	ON_BN_CLICKED(ID_CALCULATE, OnClickedCalculate)
	ON_BN_CLICKED(ID_RATIOS, OnClickedRatios)
	ON_LBN_SELCHANGE(IDC_PEAKS_LIST, OnSelchangePeaksList)
	ON_CBN_CLOSEUP(IDC_MINERALS, OnCloseupMinerals)
	ON_EN_KILLFOCUS(IDC_PEAK_AREA, OnKillfocusPeakArea)
	ON_EN_KILLFOCUS(IDC_COMMENT, OnKillfocusComment)
	ON_EN_KILLFOCUS(IDC_DATA_NAME, OnKillfocusDataName)
	ON_CBN_SELCHANGE(IDC_MINERALS, OnSelchangeMinerals)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDataVw message handlers


void CDataVw::OnClickedCalculate()
{
if(!theApp.GetRefDocStatus())  
			{GetDocument()->DisplayDBFError( NO_REF_DBF); return;}
if(!theApp.GetStdDocStatus())  
			{GetDocument()->DisplayDBFError( NO_CAL_DBF); return;}
UpdateData(TRUE);
CQntxrdDoc *pDoc=GetDocument();
if(!pDoc->CheckForValidIntStd()) return ; // check valid data for internal std
// now check that is some real data entered
CMapStringToOb *map=pDoc->GetMineralMap();
if(map->GetCount() <2)  // only internal std data
	{pDoc->DisplayDBFError(INSUF_DATA);return;}
theApp.ActivateResultsView(pDoc); // activates the results view
// we now inform, primarily the results view to display the results, by passing
// a phint of 2, and a pointer to the data map
pDoc->UpdateResultsView(this, 2, (CObject *) map);
}
                                                               
void CDataVw::OnClickedRatios()
{
if(!theApp.GetRefDocStatus())  
			{GetDocument()->DisplayDBFError( NO_REF_DBF); return;}
if(!theApp.GetStdDocStatus())  
			{GetDocument()->DisplayDBFError( NO_CAL_DBF); return;}
UpdateData(TRUE);
// now lets check that has not selected internal std
if(m_CurMin.CompareNoCase(INT_STD) ==0)
	{GetDocument()->DisplayDBFError(HALT_INTSTD);return;}
if(!GetDocument()->CheckForValidIntStd()) return ; // check valid data for internal std
// must check is valid data for this mineral
if(!GetDocument()->IsThisValid(m_CurMin))
	{GetDocument()->DisplayDBFError(NO_DATA_FOR_MINERAL);return;}
		
	
CRatioDlg dlg;
dlg.SetData(GetDocument(), m_CurMin);
dlg.DoModal();	
}

void CDataVw::OnSelchangePeaksList()
{
if(!theApp.GetRefDocStatus())  
			{GetDocument()->DisplayDBFError( NO_REF_DBF); return;}
if(!theApp.GetStdDocStatus())  
			{GetDocument()->DisplayDBFError( NO_CAL_DBF); return;}
UpdateData(TRUE);
int cursel;
VERIFY((cursel=m_PeakList.GetCurSel()) !=CB_ERR);	
if( cursel == m_OldSel) return;
CStringArray hkl, ds;// the hkl values
CQntxrdDoc *pDoc=GetDocument();
pDoc->GetHKLs(m_CurMin, hkl); // gets the hkl strings
pDoc->GetD_Space(m_CurMin, ds); // fills ds with d-spacings
ASSERT(hkl.GetSize() == ds.GetSize()); // should be same size
SortLists(ds,hkl,1); // sorts the list in on ds - ascending
m_CurHKL=hkl[cursel];
m_OldSel=cursel;
OnUpdate(this,1,NULL);
}

void CDataVw::OnCloseupMinerals()
{
if(!theApp.GetRefDocStatus())  
			{GetDocument()->DisplayDBFError( NO_REF_DBF); return;}
if(!theApp.GetStdDocStatus())  
			{GetDocument()->DisplayDBFError( NO_CAL_DBF); return;}
	UpdateData(TRUE);
	int cursel;
	CString str;
	VERIFY(	(cursel=m_Minerals.GetCurSel() ) !=CB_ERR);
	m_Minerals.GetLBText(cursel,str);
	// if different then redraw box
	if( str.Compare(m_CurMin) !=0)
		{// only do anything if str has changed
		m_CurMin=str;
		OnUpdate(this, 0,GetDocument());
		}
}
#define NO_ACTION	0
#define SET_ACTION	1
#define DELETE_ACTION	2
void CDataVw::OnKillfocusPeakArea()
//gets the pk area from the edit box when focus change to another control
{
if(!theApp.GetRefDocStatus())  // check ref dbf
			{GetDocument()->DisplayDBFError( NO_REF_DBF); return;}
if(!theApp.GetStdDocStatus())  // check calibration dbf loaded
			{GetDocument()->DisplayDBFError( NO_CAL_DBF); return;}
UpdateData(TRUE); // get pkarea from dialog box
if( m_PkArea <0)
	 	{ //negative, so display error
	 	AfxMessageBox(" Negative Value for peak area Entered ?\n");
	 	m_PkArea= ((float) m_Oldarea)/100.0F; // put old value back into field
	 	UpdateData(FALSE);
	 	return;
		} 
long area=(long) ceil( (m_PkArea*100.0) );// convert to integer to compare
if (m_Oldarea== area) return; // nothing chenged
	 	else
	 	{ 
	 	int action=NO_ACTION;
		CQntxrdDoc *pDoc=GetDocument();
		if( m_PkArea <1e-5) 
			{	// check if effectively zero, if so then must have reset area to zero
			VERIFY( pDoc->RemovePeak(m_CurMin, m_CurHKL));// so remove it
			action=DELETE_ACTION;
			}
			else
			{         // need to add a new pk or update old one
			if(m_Oldarea==0)		// add the peak to the list, since not set
				{
	 			VERIFY(pDoc->AddPeak(m_CurMin, m_CurHKL, m_PkArea) );
	 			action=SET_ACTION;
	 			}
	 			else
	 			{// new value entered for current value
	 			PEAK *pk;
	 			VERIFY((pk=pDoc->GetPeak(m_CurMin,m_CurHKL)) !=NULL);
	 			pk->pkarea=m_PkArea;// replace value
	 			pDoc->SetModifiedFlag();
	 			}
	 		}
			m_Oldarea=area;// update the value displayed
			// replace the list box string with updated one  ie with tick added etc
			if(action == DELETE_ACTION || action == SET_ACTION)
				{
				CString str;
				m_PeakList.GetText(m_OldSel, str);// gets line from box
				if(action==SET_ACTION) str.SetAt(0,CHECK_FLAG);
						else str.SetAt(0,' ');
				m_PeakList.DeleteString(m_OldSel);
				m_PeakList.InsertString(m_OldSel,str);
				}
			OnUpdate(this,1,pDoc);
	 	}
return;
}

void CDataVw::OnKillfocusComment()
{ // extrcats the comment string from the dialog
UpdateData(TRUE); 
if( m_Comment.GetLength() >0)
		GetDocument()->SetComment(m_Comment);
}

void CDataVw::OnKillfocusDataName()
{// extracts the data name from the dialog box                                                                                    
UpdateData(TRUE); 
if( m_DataName.GetLength() >0)
		GetDocument()->SetName(m_DataName);
}
//---------------------------------------------------
void CDataVw::OnSelchangeMinerals()
{
OnCloseupMinerals();	
}

