// datavw.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDataVw form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CDataVw : public CFormView
{
	DECLARE_DYNCREATE(CDataVw)
protected:
	CDataVw();			// protected constructor used by dynamic creation
	CString m_CurMin; // the curremt mineral displayed in combo box
	CString m_CurHKL;  // the current hkl displayed, selected
	int m_OldSel; // the currently selcected hkl list
	long m_Oldarea; // the peak area with decimal place shifted by two

// Form Data
public:
	//{{AFX_DATA(CDataVw)
	enum { IDD = IDD_DATA_ENTRY };
	CListBox	m_PeakList;
	CComboBox	m_Minerals;
	CString	m_DataName;
	CString	m_Comment;
	float	m_PkArea;
	//}}AFX_DATA

// Attributes
protected:
 void SetPkarea(void);
 void SetHKLList(void);
CString SetHklString( const char *phkl, const char *pdspacing);

// Operations
public:
CQntxrdDoc *GetDocument(void)
	{ ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CQntxrdDoc)));
	return (CQntxrdDoc *) m_pDocument;}

// Implementation
protected:
	virtual ~CDataVw();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnUpdate(CView *psender, LPARAM lhint, CObject *phint);
//	virtual void OnInitialUpdate(void);
	// Generated message map functions
	//{{AFX_MSG(CDataVw)
	afx_msg void OnClickedCalculate();
	afx_msg void OnClickedRatios();
	afx_msg void OnSelchangePeaksList();
	afx_msg void OnCloseupMinerals();
	afx_msg void OnKillfocusPeakArea();
	afx_msg void OnKillfocusComment();
	afx_msg void OnKillfocusDataName();
	afx_msg void OnSelchangeMinerals();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
