// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "qxrddoc.h"
#include "qntxrd.h"

#include "mainfrm.h"
#include "..\dbfutil\xrdref.h" 
#include "..\dbfutil\xrdstds.h" 
#include "..\dbfutil\xrdfrm.h"
#include "datavw.h"
#include "qxrdvw.h"
#include "intstddl.h"
#include "cubiclat.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)
IMPLEMENT_DYNCREATE(CXRDDataFrm, CMDIChildWnd)
#define new DEBUG_NEW

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_REFMINERALS, OnViewRefminerals)
	ON_COMMAND(ID_VIEW_STANDARDS, OnViewStandards)
	ON_COMMAND(ID_FILE_OPEN_CALDBF, OnFileOpenCaldbf)
	ON_COMMAND(ID_FILE_OPEN_REFBF, OnFileOpenRefDBF)
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN_CALDBF, OnUpdateFileOpenCaldbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN_REFBF, OnUpdateFileOpenRefbf)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REFMINERALS, OnUpdateViewRefminerals)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STANDARDS, OnUpdateViewStandards)
	ON_COMMAND(ID_FILE_CLOSE_CALDBF, OnFileCloseCaldbf)
	ON_COMMAND(ID_FILE_CLOSE_REFDBF, OnFileCloseRefdbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_CALDBF, OnUpdateFileCloseCaldbf)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_REFDBF, OnUpdateFileCloseRefdbf)
	ON_COMMAND(ID_SET_INTSTD, OnSetIntstd)
	ON_UPDATE_COMMAND_UI(ID_SET_INTSTD, OnUpdateSetIntstd)
	ON_COMMAND(ID_TOOLS_CUBICLATTICE, OnToolsCubiclattice)
	ON_COMMAND(ID_FILE_CLOSE_DATA, OnFileCloseData)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_DATA, OnUpdateFileCloseData)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN_DATA,
	ID_FILE_SAVE,
		ID_SEPARATOR,                                            
	ID_VIEW_REFMINERALS,
	ID_VIEW_STANDARDS,
		ID_SEPARATOR,
	ID_TOOLS_CUBICLATTICE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME) )
	{
		TRACE0("Failed to create toolbar\n");
		return -1;		// fail to create
	}
  m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY);
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;		// fail to create
	}

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
 CMDIChildWnd *CMainFrame::GetFrame(CRuntimeClass *pFrame)
 {   // returns a pointer to the one accurance of this frame type passed
 // as parameter pFrame
 	CMDIChildWnd* pMDIActive = MDIGetActive();
	ASSERT(pMDIActive != NULL);
	if( pMDIActive->IsKindOf(pFrame))
				return pMDIActive; 
	CDocument *pDoc=pMDIActive->GetActiveDocument();  
	ASSERT(pDoc !=NULL);
	CMDIChildWnd *pLastActive=pMDIActive;
	// use pDoc as means of telling when get back to this start again
	MDINext();
	pMDIActive=MDIGetActive();
	ASSERT(pMDIActive != NULL);
	while(pMDIActive->GetActiveDocument() !=pDoc)
		{
		if( pMDIActive->IsKindOf(pFrame))
			goto OK;
		MDINext();
         pMDIActive=MDIGetActive();
		ASSERT(pMDIActive != NULL);
		}
// not found
TRACE0(" MainFrame::GetFrame,=expected frame type not found\n");
return NULL;
OK:
MDIActivate(pLastActive);
return pMDIActive;
}

void CMainFrame::OnViewRefminerals()
{
	CMDIChildWnd* pMDIActive = 
			GetFrame(RUNTIME_CLASS(CXRDFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	MDIActivate(pMDIActive); //activate it
	BOOL maximized;
	 MDIGetActive(&maximized);// find if maximised
	if(!maximized)
				pMDIActive->MDIRestore(); // if not maximise it
}

void CMainFrame::OnViewStandards()
{  
	CMDIChildWnd* pMDIActive = 
			GetFrame(RUNTIME_CLASS(CXRDStdFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	MDIActivate(pMDIActive); //activate it
	BOOL maximized;
	 MDIGetActive(&maximized);// find if maximised
	if(!maximized)
				pMDIActive->MDIRestore(); // if not maximise it
}
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::OnFileOpenCaldbf()
{
theApp.OpenFileCal();
}

void CMainFrame::OnFileOpenRefDBF()
{
	theApp.OpenFileRef();
}

void CMainFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	// need to make sure that documents have cleaned up memory
	CMDIChildWnd *pFrame;
	CDocument *pDoc;
	while( (pFrame=GetFrame(RUNTIME_CLASS(CXRDDataFrm))) !=NULL)
		{
		pDoc=pFrame->GetActiveDocument();
		if(pDoc !=NULL)
			{
			if(pDoc->IsKindOf(RUNTIME_CLASS(CQntxrdDoc)) )
				pDoc->OnCloseDocument();
			}
		}
	CMDIFrameWnd::OnClose();
}
// menu update handlers
void CMainFrame::OnUpdateFileOpenCaldbf(CCmdUI* pCmdUI)
{
	if(theApp.GetStdDocStatus()) pCmdUI->Enable(	FALSE);
			else pCmdUI->Enable(TRUE);
}
void CMainFrame::OnUpdateFileOpenRefbf(CCmdUI* pCmdUI)
{
	if(theApp.GetRefDocStatus()) pCmdUI->Enable(	FALSE);
			else pCmdUI->Enable(TRUE);
}
void CMainFrame::OnUpdateViewRefminerals(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetRefDocStatus());
}
void CMainFrame::OnUpdateViewStandards(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetStdDocStatus());
}

void CMainFrame::OnFileCloseCaldbf()
{
	CXRDStdFrame* pMDIActive = (CXRDStdFrame *)
			GetFrame(RUNTIME_CLASS(CXRDStdFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	 pMDIActive->OnCloseDoc();
	 theApp.m_bStdDoc=FALSE;
	 theApp.UpdateIniFileWithCalibPath("");
}

void CMainFrame::OnFileCloseRefdbf()
{
	CXRDFrame* pMDIActive = (CXRDFrame *)
			GetFrame(RUNTIME_CLASS(CXRDFrame));// get frame ptr
	ASSERT(pMDIActive != NULL);
	 pMDIActive->OnCloseDoc();
	 theApp.m_bRefDoc=FALSE;
	 theApp.UpdateIniFileWithRefPath("");
}

void CMainFrame::OnUpdateFileCloseCaldbf(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetStdDocStatus());
}

void CMainFrame::OnUpdateFileCloseRefdbf(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	theApp.GetRefDocStatus());
}



void CMainFrame::OnSetIntstd()
{
	CIntStdDlg dlg;
	dlg.m_IntStd=INT_STD;
	if(dlg.DoModal() == IDOK)
		{
		if (!dlg.m_IntStd.IsEmpty()) INT_STD=dlg.m_IntStd;
		}
	theApp.UpdateIniFileWithIntStd(INT_STD);
}

void CMainFrame::OnUpdateSetIntstd(CCmdUI* pCmdUI)
{
	BOOL enable; 
	// only enable this menu option if there is not ref or std databases attached
	if( theApp.GetRefDocStatus() || theApp.GetStdDocStatus() ) enable=FALSE;
		else enable=TRUE;
	pCmdUI->Enable(enable);
}

void CMainFrame::OnToolsCubiclattice()
{
	CCubicLat dlg; 
	theApp.SetDlgBkColor( RGB(255,255,255));
	dlg.DoModal();
	theApp.SetDlgBkColor(RGB(192,192,192));
}

void CMainFrame::OnFileCloseData()
{// this is not used
// first find active frame
CMDIChildWnd *pFrame=MDIGetActive();
ASSERT(pFrame !=NULL);
// if either of the calibration or ref frame active, then ignore
if(pFrame->IsKindOf(RUNTIME_CLASS(CXRDStdFrame))    ||
			pFrame->IsKindOf(RUNTIME_CLASS(CXRDFrame)))
			return;
// is probably the correct frame
CDocument *pDoc=pFrame->GetActiveDocument();
ASSERT(pDoc !=NULL);
ASSERT(pDoc-IsKindOf(RUNTIME_CLASS(CQntxrdDoc)));
// all ok so close the document, and the attached views
pDoc->OnCloseDocument ();
}

void CMainFrame::OnUpdateFileCloseData(CCmdUI* pCmdUI)
{// not used framework does update
// first find active frame
CMDIChildWnd *pFrame=MDIGetActive();
ASSERT(pFrame !=NULL);
// if either of the calibration or ref frame active, then disable
if(pFrame->IsKindOf(RUNTIME_CLASS(CXRDStdFrame))    ||
			pFrame->IsKindOf(RUNTIME_CLASS(CXRDFrame)))
			pCmdUI->Enable(FALSE);
			
			else pCmdUI->Enable(TRUE);
}
/////////////////////////////////////////////////////////////////////////////
// CXRDDataFrm


CXRDDataFrm::CXRDDataFrm()
{
}

CXRDDataFrm::~CXRDDataFrm()
{
}

/* BOOL CXRDDataFrm::PreCreateWindow(CREATESTRUCT& cs)
 {
 cs.style &= ~(LONG) FWS_ADDTOTITLE;
 return CMDIChildWnd::PreCreateWindow(cs);
 }
 */
BEGIN_MESSAGE_MAP(CXRDDataFrm, CMDIChildWnd)
	//{{AFX_MSG_MAP(CXRDDataFrm)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXRDDataFrm message handlers


void CXRDDataFrm::OnClose()
{  // called when closeing frame
// if it is the results frame we just close the frame
// if the dataview frame then close the document
CMDIChildWnd *pFrame=GetMDIFrame()->MDIGetActive();
ASSERT(pFrame !=NULL);
// if either of the calibration or ref frame active, then ignore- bit odf error checking
if(pFrame->IsKindOf(RUNTIME_CLASS(CXRDDataFrm))    )
	{// is probably the correct frame
	CView *pView=pFrame->GetActiveView();
	if(pView->IsKindOf(RUNTIME_CLASS(CDataVw)))
		{ // is the dataview frame and view
		CDocument *pDoc=pFrame->GetActiveDocument();
		ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CQntxrdDoc)));
	// all ok so close the document, and the attached views
		( (CQntxrdDoc *) pDoc )->OnCloseDocument ();
		}
		else
			{// is the results view frame, just close it
			if(pView->IsKindOf(RUNTIME_CLASS(CQntxrdView)))
		        CMDIChildWnd::OnClose();
		        else
		        TRACE0("Unknown view type found in CXRDDataFrm::OnClose()\n");
			}
	}// endof pFrame-> loop
}
