// qntxrd.cpp : Defines the class behaviors for the application.
//
#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "qxrddoc.h" 
#include "qntxrd.h"
#include <io.h>
#include <errno.h>

#include "mainfrm.h"

#include "qxrdvw.h"
#include "..\dbfutil\xrdref.h"
#include "..\dbfutil\xrdstds.h"  
#include "..\dbfutil\xrdfrm.h"   
#include "datavw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#define CALIB_DOC	1
#define REF_DOC	2
#define XRD_DOC	3
#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// CQntxrdApp

BEGIN_MESSAGE_MAP(CQntxrdApp, CWinApp)
	//{{AFX_MSG_MAP(CQntxrdApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN_DATA, OnFileOpenData)
	ON_COMMAND(ID_FILE_CLOSE_DATA, OnFileCloseData)
	//}}AFX_MSG_MAP
	// Standard file based document commands
//	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CWinApp::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CWinApp::OnHelpUsing)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CWinApp::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CWinApp::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQntxrdApp construction

CQntxrdApp::CQntxrdApp()
{
	m_bRefDoc=FALSE;m_bStdDoc=FALSE;
	ResViewActive=FALSE;
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CQntxrdApp object

CQntxrdApp  theApp;

/////////////////////////////////////////////////////////////////////////////
// CQntxrdApp initialization

BOOL CQntxrdApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
			
	// templates for the reference mineral data
    m_pRefViewTemplate=new CMultiDocTemplate(IDR_REFFRAME,
			RUNTIME_CLASS(CMinData),                      // the document
			RUNTIME_CLASS(CXRDFrame),        
			RUNTIME_CLASS(CXRDRefForm));				// the view

// templates for the standrds data			
    m_pStdViewTemplate=new CMultiDocTemplate(IDR_STDFRAME,
			RUNTIME_CLASS(CMinCalibration),
			RUNTIME_CLASS(CXRDStdFrame),        // standard MDI child frame
			RUNTIME_CLASS(CXRDStdForm));
     
	AddDocTemplate(m_pRefViewTemplate);
	AddDocTemplate(m_pStdViewTemplate);
// must put doc template last in list other wise auto selection of dbf type will
// not work on previous two templates
	m_pXrdTemplate=new CMultiDocTemplate(IDR_QNTXRDTYPE,
			RUNTIME_CLASS(CQntxrdDoc),              // the qnt doc template
			RUNTIME_CLASS(CXRDDataFrm),        // standard MDI child frame
			RUNTIME_CLASS(CDataVw));  
	AddDocTemplate(m_pXrdTemplate);
	
	m_pResTemplate=new CMultiDocTemplate(IDR_QNTRESTYPE,
			RUNTIME_CLASS(CQntxrdDoc),              // the qnt doc template
			RUNTIME_CLASS(CXRDDataFrm),        // standard MDI child frame
			RUNTIME_CLASS(CQntxrdView));  
	AddDocTemplate(m_pResTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();
	m_pMainWnd = pMainFrame;

	// enable file manager drag/drop and DDE Execute open
	m_pMainWnd->DragAcceptFiles();
	EnableShellOpen();
	RegisterShellFileTypes();     
	// get internal standard
	INT_STD=GetIntStdFromIniFile();
	
 	// open ref file in ini file
	CString strDoc=GetRefPathFromIniFile();
	if(!strDoc.IsEmpty() && _access(strDoc,0) ==0)
		{// open Ref file if name and path
		 	if(OpenDocumentFile(strDoc, REF_DOC) ==NULL) m_bRefDoc=FALSE;
				else  
				{m_bRefDoc=TRUE;
				CXRDFrame *pRefFrame =(CXRDFrame *)
						 pMainFrame->GetFrame(RUNTIME_CLASS(CXRDFrame));
				pRefFrame->OnCloseDlg(); // minimise this window
				m_LastRefFile=strDoc;				
				}
		}
	// open the last loaded calibration file
	strDoc=GetCalibPathFromIniFile();
 	if(!strDoc.IsEmpty() && _access(strDoc,0)==0)
		{// open Calib file if name and path
		 	if(OpenDocumentFile(strDoc, CALIB_DOC) ==NULL) m_bStdDoc=FALSE;
				else 
				{ m_bStdDoc=TRUE;
				CXRDStdFrame *pCalFrame =(CXRDStdFrame *)
						 pMainFrame->GetFrame(RUNTIME_CLASS(CXRDStdFrame));
				pCalFrame->OnCloseDlg(); // minimise this window				
				m_LastCalFile=strDoc;				
				}
		}

	// simple command line parsing
	if (m_lpCmdLine[0] == '\0')
	{
		strDoc=GetDocPathFromIniFile();
		if(strDoc.IsEmpty() )
		{
		// create a new (empty) document
				if( m_bStdDoc && m_bRefDoc)
					OnFileNew();
		}
		else
		{// open the last document
		if(m_bStdDoc && m_bRefDoc && _access(strDoc,0)==0)
			{
    		OpenDocumentFile(strDoc,XRD_DOC);
    		m_LastDataFile=strDoc;
    		}
    	}
		
	}
	else if ((m_lpCmdLine[0] == '-' || m_lpCmdLine[0] == '/') &&
		(m_lpCmdLine[1] == 'e' || m_lpCmdLine[1] == 'E'))
	{
		// program launched embedded - wait for DDE or OLE open
	}
	else
	{
		if( m_bStdDoc && m_bRefDoc)
			{
		// open an existing document 
			strDoc=m_lpCmdLine;
			if(_access(strDoc,0)==0)
				{
				OpenDocumentFile(strDoc,XRD_DOC);
	    		m_LastDataFile=strDoc;
				}
			}
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CQntxrdApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CQntxrdApp commands
static char BASED_CODE szIniFileCalib[] = "Most Recent Calibration File";  
static char BASED_CODE szIniFileRef[]="Most Recent Minerals Reference File"; 
static char BASED_CODE szIniFileDocPath[]="Most recent data file";
static char BASED_CODE szIniFileEntry[] = "File";
static char BASED_CODE szIniIntStd[]=" Internal Standard";
// routines associtade with saveing calibration files etc
void CQntxrdApp::UpdateIniFileWithCalibPath(const char* pszPathName)
{
	WriteProfileString(szIniFileCalib, szIniFileEntry, pszPathName);
}
 void CQntxrdApp::UpdateIniFileWithRefPath(const char* pszPathName)
{
	WriteProfileString(szIniFileRef, szIniFileEntry, pszPathName);
}
 void CQntxrdApp::UpdateIniFileWithDocPath(const char* pszPathName)
{
	WriteProfileString(szIniFileDocPath, szIniFileEntry, pszPathName);
}  
 void CQntxrdApp::UpdateIniFileWithIntStd(const char* pszIntStd)
{
	WriteProfileString(szIniIntStd, szIniFileEntry, pszIntStd);
}  
// routines for loading the calibration file etc
CString CQntxrdApp::GetCalibPathFromIniFile()
{
	return GetProfileString(szIniFileCalib, szIniFileEntry, NULL);
} 

 CString CQntxrdApp::GetRefPathFromIniFile()
{
	return GetProfileString(szIniFileRef, szIniFileEntry, NULL);
}
 CString CQntxrdApp::GetDocPathFromIniFile()
{
	return GetProfileString(szIniFileDocPath, szIniFileEntry, NULL);
}
 CString CQntxrdApp::GetIntStdFromIniFile()
{
	CString str=GetProfileString(szIniIntStd, szIniFileEntry, NULL);
	if(str.IsEmpty()) str="quartz";
	return str;
}

BOOL CQntxrdApp::OpenFileRef(void)
{
	// prompt the user (with all document templates)
	if (!DoPromptFileName(m_LastRefFile, IDS_OPEN_REF,
	  OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, m_pRefViewTemplate))
		return (m_bRefDoc=FALSE); // open cancelled                       
		
	if(OpenDocumentFile(m_LastRefFile, REF_DOC) ==NULL) 
			return (m_bRefDoc=FALSE);
		else return (m_bRefDoc=TRUE);
}
//---------------------------------------------------------------------------------
BOOL CQntxrdApp::OpenFileCal(void)
{    //retusn true if opened ok
	// prompt the user (with all document templates)
	if (!DoPromptFileName(m_LastCalFile, IDS_OPEN_CAL,
	  OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, m_pStdViewTemplate))
		return (m_bStdDoc=FALSE); // open cancelled                       
		
	if(OpenDocumentFile(m_LastCalFile,CALIB_DOC) == NULL) 
			return (m_bStdDoc=FALSE);
		else return (m_bStdDoc=TRUE);
}
//-----------------------------------------------------------------------------------------------------
CDocument* CQntxrdApp::OpenDocumentFile(const char *szPath, int type)
{
	// find the highest confidence
	POSITION pos = GetFirstDocTemplatePosition(); 
	CDocTemplate::Confidence bestMatch = CDocTemplate::noAttempt;
	CDocTemplate* pBestTemplate = NULL;
	CDocument* pOpenDocument = NULL;  
	BOOL firstpass={TRUE};
	ASSERT(type >=1 || type <=3);
	while (pos)
	{
		CDocTemplate* pTemplate = GetNextDocTemplate(pos);
		ASSERT(pTemplate->IsKindOf(RUNTIME_CLASS(CDocTemplate)));

		CDocTemplate::Confidence match;
		ASSERT(pOpenDocument == NULL);
		match = pTemplate->MatchDocType(szPath, pOpenDocument);
		if(firstpass && type ==CALIB_DOC) 
			{match=CDocTemplate::noAttempt;
			firstpass=FALSE;}
		if (match > bestMatch)
		{
			bestMatch = match;
			pBestTemplate = pTemplate;
		}
		if (match == CDocTemplate::yesAlreadyOpen)
			break;      // stop here
	}

	if (pOpenDocument != NULL)
	{
		POSITION pos = pOpenDocument->GetFirstViewPosition();
		if (pos != NULL)
		{
			CView* pView = pOpenDocument->GetNextView(pos); // get first one
			ASSERT_VALID(pView);
			CFrameWnd* pFrame = pView->GetParentFrame();
			if (pFrame != NULL)
				pFrame->ActivateFrame();
			else
				TRACE0("Error: Can not find a frame for document to activate");
			CFrameWnd* pAppFrame;
			if (pFrame != (pAppFrame = (CFrameWnd*)AfxGetApp()->m_pMainWnd))
			{
				ASSERT(pAppFrame->IsKindOf(RUNTIME_CLASS(CFrameWnd)));
				pAppFrame->ActivateFrame();
			}
		}
		else
		{
			TRACE0("Error: Can not find a view for document to activate");
		}
		return pOpenDocument;
			// file already open (even if we can't activate it)
	}

	if (pBestTemplate == NULL)
	{
		TRACE0("Error: can't open document\n");
		return NULL;
	}
	pOpenDocument=pBestTemplate->OpenDocumentFile(szPath);
		// now update the appropriate inifile
	if(pOpenDocument !=NULL) 
	{
	switch ( type) 
		{
		case CALIB_DOC:
				UpdateIniFileWithCalibPath(szPath);
				pCal=(CMinCalibration *) pOpenDocument;
				break;
		case REF_DOC:
				UpdateIniFileWithRefPath(szPath);
				pRef=(CMinData *) pOpenDocument;
				break;
		case XRD_DOC:
						UpdateIniFileWithDocPath(szPath);break;
		default: TRACE0("Bad type in theApp::OpenDocumentFile\n");
			}
	}
	return pOpenDocument;

}
//---------------------------------------------------------------------------------------------
void CQntxrdApp::OnFileNew()
{
	if (GetFirstDocTemplatePosition()== NULL)
	{
		TRACE0("Error : no document templates registered with CWinApp\n");
		AfxMessageBox(AFX_IDP_FAILED_TO_CREATE_DOC);
		return;
	}
	if(!CheckRefDocExist()) return;
	if(!CheckStdDocExist()) return;
	 m_pXrdTemplate->OpenDocumentFile(NULL);
		// if returns NULL, the user has already been alerted
}
//--------------------------------------------------------------------------------------------------------
void CQntxrdApp::OnFileOpenData()
{
	if(!CheckRefDocExist()) return;
	if(!CheckStdDocExist()) return;
	if (!DoPromptFileName(m_LastDataFile, IDS_OPEN_DATA,
	  OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, m_pXrdTemplate))
		return; // open cancelled                       
		
	if(OpenDocumentFile(m_LastDataFile,XRD_DOC) == NULL) return;
		else return;
}

void CQntxrdApp::OnFileCloseData()
{
	// TODO: Add your command handler code here
	
}

BOOL CQntxrdApp::CheckRefDocExist(void)
{
if( !m_bRefDoc)
		{
		AfxMessageBox("A Minerals reference database MUST be\n Open to initiate a new or old XRD dataset");
		return FALSE;
		}
		else return TRUE;
}
BOOL CQntxrdApp::CheckStdDocExist()
{
	if( !m_bStdDoc)
		{
		AfxMessageBox("A Calibration database MUST be\n Open to initiate a new or old XRD dataset");
		return FALSE;
		}
		else return TRUE;
}
CQntxrdDoc* CQntxrdApp::ActivateResultsView(CQntxrdDoc *pDoc)
{
// search for a view of results type attached to doc
ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CQntxrdDoc)));
ASSERT(pDoc !=NULL);
CView *pView;
for(POSITION pos = pDoc->GetFirstViewPosition(); pos !=NULL;)
	{
	pView = pDoc->GetNextView( pos );
	if(pView->IsKindOf(RUNTIME_CLASS(CQntxrdView)))
		{// found one, so activate it
		CFrameWnd *pFrame=pView->GetParentFrame();
		pFrame->ActivateFrame();        // make visible
		pFrame->SetActiveView(pView);// set focus to this view
		return pDoc;
		}
	}
//

// no active frame found of right type, so create a new one
CMDIChildWnd *pNewFrame= 
		(CMDIChildWnd *)m_pResTemplate->CreateNewFrame(pDoc,NULL);
if (pNewFrame ==NULL)
		return pDoc;
ASSERT(pNewFrame->IsKindOf(RUNTIME_CLASS(CMDIChildWnd))) ;
	// if the frame does not have an active view, set to first pane
	if (pNewFrame->GetActiveView() == NULL)
	{
		CWnd* pWnd = pNewFrame->GetDescendantWindow(AFX_IDW_PANE_FIRST);
		if (pWnd != NULL && pWnd->IsKindOf(RUNTIME_CLASS(CView)))
			pNewFrame->SetActiveView((CView*)pWnd);
	}
	// finally, activate the frame
	// (send the default show command unless the main desktop window)
	int nCmdShow = -1;      // default
	if (pNewFrame == AfxGetApp()->m_pMainWnd)
		nCmdShow = AfxGetApp()->m_nCmdShow; // use the parameter from WinMain
	pNewFrame->ActivateFrame(nCmdShow);

	// now that the frame is visible - update frame counts
	pDoc->UpdateFrameCounts();

	// at this point the frame should be properly linked to the document
	ASSERT(pNewFrame->GetActiveDocument() == pDoc);
//m_pResTemplate->InitialUpdateFrame(pNewFrame,pDoc);
return pDoc;		
}
 
