// qntxrd.h : main header file for the QNTXRD application
//
/* dependencies
	linked libs: dbfutils.lib general.lib 
	paths: \geophys\utilclas\general\release,
			\geophys\dbfutil\dbfutils\release
	linked dll's mwh1.lib
		paths: \geophys\UTILCLAS\mwh1dll\release\
*/

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

/////////////////////////////////////////////////////////////////////////////
// CQntxrdApp:
// See qntxrd.cpp for the implementation of this class
//

class CQntxrdApp : public CWinApp
{
private:
	CMinData *pRef;// holds pointer to 1 copy of ref doc
	CMinCalibration *pCal;// pointer to cal documet
	BOOL ResViewActive;// true if results view active
	CString m_LastDataFile;
	CString m_LastRefFile;
	CString m_LastCalFile;
public:
	BOOL m_bRefDoc; // set to yes when document loaded
	BOOL m_bStdDoc; // true when doc loaded
public:
	CQntxrdApp();
	CMultiDocTemplate *m_pRefViewTemplate;
	CMultiDocTemplate *m_pStdViewTemplate;
	CMultiDocTemplate *m_pXrdTemplate;
	CMultiDocTemplate *m_pResTemplate;
	void UpdateIniFileWithCalibPath(const char* pszPathName);
 	void UpdateIniFileWithRefPath(const char* pszPathName);
 	void UpdateIniFileWithDocPath(const char* pszPathName);    
 	void UpdateIniFileWithIntStd(const char *IntStd);
	CString GetCalibPathFromIniFile(void) ;
 	CString GetRefPathFromIniFile(void) ;
 	 CString GetDocPathFromIniFile(void);
 	 CString GetIntStdFromIniFile(void);
 CDocument * OpenDocumentFile( const char * szPath, int type);
 BOOL OpenFileCal(void);
 BOOL OpenFileRef(void);
 BOOL GetRefDocStatus(void){ return m_bRefDoc;};
BOOL GetStdDocStatus(void) {return m_bStdDoc;};
CMinData *GetRefDocPtr(void) {return pRef;};
CMinCalibration *GetCalDocPtr(void) {return pCal;};
BOOL CheckRefDocExist(void);
BOOL CheckStdDocExist(void);
CQntxrdDoc* ActivateResultsView(CQntxrdDoc *pDoc);
void SetDlgBkColor(COLORREF col) {SetDialogBkColor(col);};
// Overrides
	virtual BOOL InitInstance();

// Implementation

	//{{AFX_MSG(CQntxrdApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileNew();
	afx_msg void OnFileOpenData();
	afx_msg void OnFileCloseData();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
extern CQntxrdApp theApp;


/////////////////////////////////////////////////////////////////////////////
