// qxrddoc.cpp : implementation of the CQntxrdDoc class
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "qxrddoc.h"
#include "qntxrd.h"

#include "..\utilclas\general.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQntxrdDoc

IMPLEMENT_DYNCREATE(CQntxrdDoc, CDocument)
#define new DEBUG_NEW

BEGIN_MESSAGE_MAP(CQntxrdDoc, CDocument)
	//{{AFX_MSG_MAP(CQntxrdDoc)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_CLOSE_DATA, OnFileCloseData)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQntxrdDoc construction/destruction

CQntxrdDoc::CQntxrdDoc()
{
	m_nMins=0;
	m_InitFail=FALSE;
	m_RefDoc="";
	m_CalDoc="";
	m_DataName="";
	m_Comment="";
}

CQntxrdDoc::~CQntxrdDoc()
{
}

BOOL CQntxrdDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
// the two calibration/ref docs must exist previously
	if(!theApp.CheckRefDocExist()) return FALSE;
	if(!theApp.CheckStdDocExist()) return FALSE;
	GetIntStdData();	
	return TRUE;
}
BOOL CQntxrdDoc::OnOpenDocument(const char *pszPathname)
{
if(! CDocument::OnOpenDocument(pszPathname))
		return FALSE;
	if(m_InitFail) return FALSE;   // thrown error up from serialise
	GetIntStdData();	
	return TRUE;
}
                                                                                 
/////////////////////////////////////////////////////////////////////////////
// CQntxrdDoc serialization
void CQntxrdDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	m_RefDoc=theApp.GetRefDocPtr()->GetPathName();
	ar << m_RefDoc;
	m_CalDoc=theApp.GetCalDocPtr()->GetPathName();
	ar << m_CalDoc;
	ar << m_DataName;
	ar << m_Comment;
	SerializeMap(ar);
	SerializeRatios(ar);
	}
	else
	{// may need to load the ref/cal  docs ??, or at least see if the same
	if(!theApp.CheckRefDocExist()) return;
	if(!theApp.CheckStdDocExist()) return;
	DeleteContents();//make sure doc is empty
	ar >> m_RefDoc;
	ar >> m_CalDoc;
	// ask user if docs are different that ok to ignore
	CString curref=theApp.GetRefDocPtr()->GetPathName();
	if(curref.CompareNoCase(m_RefDoc) !=0)
		{
		curref="Current Minerals Reference database is different to\n";
		curref+="that used previously with this file\n";
		curref+=" old reference= ";
		curref+=m_RefDoc+"\n\n   Continue ??";
		if(AfxMessageBox(curref,MB_YESNO) == IDNO)
				{m_InitFail=TRUE;return;}
		}
	curref=theApp.GetCalDocPtr()->GetPathName();
	if(curref.CompareNoCase(m_CalDoc) !=0)
		{
		curref="Current Calibration  database is different to\n";
		curref+="that used previously with this file\n";
		curref+=" old Calibration= ";
		curref+=m_CalDoc+"\n\n   Continue ??";
		if(AfxMessageBox(curref,MB_YESNO) == IDNO)
				{m_InitFail=TRUE;return;}
		}
	ar >> m_DataName;
	ar >> m_Comment;
	SerializeMap(ar);
	SerializeRatios(ar);
	SetModifiedFlag(FALSE);
	}
}
//--------------------------------------------------------------------------------
void CQntxrdDoc::SerializeMap(CArchive& ar)
{
DWORD w;
CString Mineral,hkl;


if (ar.IsStoring())
	{  
	CObject *pmap;
	POSITION pos,pos2;
	void *pvoid;
	CMapStringToPtr *pkmap;
	w=(DWORD) m_Data.GetCount();
	ar <<w; // save number of minerals
	for(pos=m_Data.GetStartPosition(); pos !=NULL;)
		{
	     m_Data.GetNextAssoc(pos, Mineral,  pmap);
 		ASSERT(pmap !=NULL);
        // now get the 
		pkmap=(CMapStringToPtr *) pmap;
 		w=(DWORD) pkmap->GetCount();
 		ar << w;// save number of hkl values with data
 		ar <<Mineral; // save this mineral name
 		for(pos2=pkmap->GetStartPosition(); pos2 !=NULL;)
 			{
 			pkmap->GetNextAssoc(pos2,hkl,pvoid);// now got ptr to PEAK
			ASSERT(pvoid !=NULL);
			ASSERT(hkl.GetLength() >0);
			ar << ( (PEAK *) pvoid)->pkarea;
			ar << hkl;
			}
		}
	}
	else
	{ // get data from archive
	float pkarea;
	ar >>w;
	UINT nummins= (UINT) w;// number of minerals stored
	for(UINT i=0; i<nummins; i++)
		{
		ar >>w;// number of hkl values
		ar >> Mineral; // mineral name
		for(int k=0; k<(int) w;k++)
			{
			ar >>pkarea;
			ar >>hkl;
			VERIFY(AddPeak(Mineral, hkl, pkarea));
			}
		}
	}
}
//-----------------------------------------------------------------------------
void CQntxrdDoc::SerializeRatios(CArchive& ar)
{
int numratios;
CString Mineral;
BOOL use;
if (ar.IsStoring())
	{
	CObject *pmap;
	for(POSITION pos=m_Data.GetStartPosition(); pos !=NULL;)
		{
	     m_Data.GetNextAssoc(pos, Mineral,  pmap);
 		ASSERT(pmap !=NULL);
        // now get the ratios
        numratios=GetNumUsageValues(Mineral);
 		ar << (DWORD) numratios;// save number of hkl values with data
 		ar <<Mineral; // save this mineral name
        if(numratios >0)
        	{// internal stad will have no usage indexes set
 			for(int index=1; index <=numratios; index++)
	 				 ar <<(DWORD) GetUsage(Mineral, index);
	 		}		 
		}
	}
	else
	{  
	DWORD w;
	for(UINT i=0; i<m_nMins; i++)
		{
		ar >> w;numratios=(int) w;// get numer of ratios
		ar >> Mineral;
		if( numratios >0)
			{
			for(int index=1; index <=numratios; index++)
				{ 
				ar >>w;use=(BOOL) w;
				UpDateUsage(Mineral, index, use);
				}
			}
		}
	}
}
/////////////////////////////////////////////////////////////////////////////
// CQntxrdDoc diagnostics

#ifdef _DEBUG
void CQntxrdDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CQntxrdDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQntxrdDoc commands
BOOL CQntxrdDoc::AddPeak( const char *pMineral, const char *pHkl, float pkarea)
{ // adds the peak info to the data records, returns FALSE if error
ASSERT(strlen(pMineral) >0);
CObject *pObj;
if( m_Data.Lookup(pMineral, pObj) )
	{// found mineral in map
	AddPeakToObj((CMapStringToPtr *) pObj, pHkl, pkarea);
	}
	else
	{// not found mineral in map, so we need to allocate new CMapStringToPtr
	CMapStringToPtr *pmap=new CMapStringToPtr;// create new CMapStringtoPtr
	m_nMins++; // increment mineral counter
	ASSERT(pmap !=NULL);
	m_Data[pMineral]=pmap; //adds to object map
	AddPeakToObj(pmap, pHkl, pkarea); // adds to , or updates ptr map
	// now add new ratio array
	BOOL *ratio=PutNewRatios(pMineral);
	m_Ratios[pMineral]=ratio;
	}
SetModifiedFlag();
return TRUE;
}
//---------------------------------------------------------------
void CQntxrdDoc::AddPeakToObj( CMapStringToPtr *pmap, 
				const  char *pHkl, float pkarea)
{ // adds a peaks data to the map, checking if this exists first
void *pvoid;
if( pmap->Lookup(pHkl, pvoid) )
			{// found it in here, so replace it
			ASSERT(pvoid !=NULL);
			PEAK *pp=(PEAK *) pvoid;
			pp->pkarea;
			pp->HKL=pHkl;
			}
			else
			{// not found to create a new PEAK strcuture
			PEAK *pp=PutNewPeaks(pHkl, pkarea);// copy into new PEAK strcuture
			ASSERT(pp !=NULL);
			pmap->SetAt(pHkl, pp);// add to map
			}
SetModifiedFlag();
}
//---------------------------------------------------------------------------------
PEAK *CQntxrdDoc::PutNewPeaks(const char *pHkl, float pkarea)
{ // dynamically allocate the PEAK structure
PEAK *pp= new PEAK;
if( pp ==NULL) return NULL;
pp->pkarea=pkarea;
pp->HKL=pHkl;
return pp;
}
//----------------------------------------------------------------------------------
BOOL CQntxrdDoc::RemovePeak(const char *pMineral, const char *pHkl)
{// returns TRUE if removed data
CObject *pmap;
if( m_Data.Lookup(pMineral, pmap) )
	{
	void *pvoid;
	if( ((CMapStringToPtr*) pmap)->Lookup(pHkl, pvoid) )
		{
		delete (PEAK *) pvoid;
		((CMapStringToPtr*) pmap)->RemoveKey(pHkl);
		if(((CMapStringToPtr*) pmap)->IsEmpty() )
				{ // ptr map is now empty, so remove it from mineral map
				delete ((CMapStringToPtr*) pmap);
				RemoveMineral(pMineral);
				}
		SetModifiedFlag();
		return TRUE;
		}
		else TRACE0("CQntxrdDoc::RemovePeak, not found expected HKL string\n");
	}
	else
	{ // not found mineral
	TRACE0("CQntxrdDoc::RemovePeak, not found expected mineral name\n");
	}
return FALSE;
}
//-----------------------------------------------------------------------------
void CQntxrdDoc::RemoveMineral(const char *min)
{// removes references to the mineral min from the data
void *pvoid;
m_Data.RemoveKey(min);
// remove ratios also
m_Ratios.Lookup(min, pvoid);
ASSERT(pvoid !=NULL);
delete [] (BOOL *) pvoid;
m_Ratios.RemoveKey(min);
m_nMins--;// decrement mineral counter
SetModifiedFlag();
}
//--------------------------------------------------------------------------------------
PEAK *CQntxrdDoc::GetPeak(const char *pMineral, const char *pHkl)
{// returns a pointer to the PEAK structure index by arguments
// returns NULL if not found
CObject *pmap;
if( m_Data.Lookup(pMineral,  pmap) )
	{
	void *pvoid;
	ASSERT(pmap !=NULL);
	if (((CMapStringToPtr *) pmap)->Lookup(pHkl, pvoid))
		{
		ASSERT(pvoid !=NULL);
		return (PEAK *) pvoid;
		}
	}
// if cannot find the referenced peak end up here
TRACE0("CQntxrd::GetPeak , NOT found indexed peak ");
TRACE1("min=%s ", pMineral);
TRACE1(" hkl = %s\n",pHkl);
return NULL; // not found
}
//--------------------------------------------------------------------------------
void CQntxrdDoc::DeleteContents(void)
{
CString mineral,hkl;
CObject *pmap;
POSITION pos2;
void *pvoid;
for(POSITION pos=m_Data.GetStartPosition(); pos !=NULL;)
	{
	m_Data.GetNextAssoc(pos, mineral, pmap);
	 for(pos2=((CMapStringToPtr *)pmap)->GetStartPosition(); pos2 !=NULL;)
	 	{
	 	((CMapStringToPtr *)pmap) ->GetNextAssoc(pos2, hkl, pvoid);// gets ptr to PEAK strcuture
	 	delete (PEAK *) pvoid;
	 	}
	 ((CMapStringToPtr *)pmap) ->RemoveAll();
	 delete pmap;
	 RemoveMineral(mineral);
	}
m_nMins=0;
for(pos =m_intstd.GetStartPosition(); pos !=NULL;)
	{
	m_intstd.GetNextAssoc(pos,hkl,mineral);
	mineral.Empty();
	}
m_intstd.RemoveAll();
m_nMins=0;	m_InitFail=FALSE;
m_RefDoc="";	m_CalDoc="";	m_DataName="";	m_Comment="";
SetModifiedFlag();
}
//-------------------------------------------------------------------------------------------------
BOOL *CQntxrdDoc::PutNewRatios(const char *pMineral)
{//creates a new array to store the "USE" indicators for the ratios for this mineral
// stores the size in first element, treats the int std differently
ASSERT(strlen(pMineral)  >0);
CMinCalibration *cal=theApp.GetCalDocPtr(); // gets ptr to calibration data
CString str=pMineral;
if(str.CompareNoCase(INT_STD) ==0)
	{// mineral is internal std, no array allocated for this, just one value
	// with zero in it
	BOOL *use=new BOOL[1];
	ASSERT(use !=NULL);	use[0]=0;
	return use;	
	}
	else
	{
	int nc=cal->GetNumCalibrationPoints(pMineral);
	BOOL *use= new BOOL[nc+1];	ASSERT(use !=NULL);
// now initialise it
	use[0]=nc;
	for(int i=1; i<=nc; i++)
		use[i]=TRUE;
	return use;	
	}
SetModifiedFlag();
}
//-----------------------------------------------------------------------------
int CQntxrdDoc::GetNumUsageValues(const char *pMineral)
{
void *pvoid;
VERIFY(m_Ratios.Lookup(pMineral ,pvoid) );
BOOL *ratio=(BOOL *) pvoid;
return ratio[0];
}
//--------------------------------------------------------------------------------
void CQntxrdDoc::UpDateUsage(const char *pMineral, int index, BOOL value)
{// sets the on/off value of the ratio
void *pvoid;
VERIFY(m_Ratios.Lookup(pMineral ,pvoid) );
BOOL *ratio=(BOOL *) pvoid;
ASSERT(index <= ratio[0] && index >0); // number of values stored in start of array
ratio[index]=value;
SetModifiedFlag();
}                                
//----------------------------------------------------------------------------------
BOOL CQntxrdDoc::GetUsage(const char *pMineral, int index)
{// retuns ratio switch at index
void *pvoid;
VERIFY(m_Ratios.Lookup(pMineral ,pvoid) );
BOOL *ratio=(BOOL *) pvoid;
ASSERT(index <= ratio[0] && index >0); // number of values stored in start of array
return ratio[index];
}
//-----------------------------------------------------------------------------------------------
BOOL CQntxrdDoc::CheckForValidIntStd(void)
{// checks if internal standard data entered, displays error box if not
//lets see if data fro int std entered first
if(!IsThisValid(INT_STD ))
	{
	DisplayDBFError(INTSTD_FIRST);
	return FALSE;
	}
	else return TRUE;
}
//------------------------------------------------------------
BOOL CQntxrdDoc::IsThisValid(const char *pMineral)
{
CObject *pObj;
if(!m_Data.Lookup(pMineral, pObj) )
	return FALSE;
	else return TRUE;
}
//----------------------------------------------------------------------------------------------
CString CQntxrdDoc::GetHRatioString(const char  *pMineral, int runno)
{ // returns the H-ratio string to the ratio dialog, of the ratio for the current data
CString str;
//lets see if data fro int std entered first
if( !CheckForValidIntStd()) return str;
str=pMineral;// make sure not asking for int std
if( str.CompareNoCase(INT_STD) == 0) 
		{TRACE0(" internal standard passed to CQntxrdDoc::GetUsageString\n");
		return (str="");}
float ratio=GetHRatioValue(pMineral, runno);
if (ratio <0.0)
	{TRACE1(" error in accessing ratio string for minerl=%s",pMineral);
	TRACE1("  run number =%d",runno);
	return str;
	}
char buf[50];int dp={3};
ftoa(&ratio,buf,&dp);
return(str=buf);
}
//---------------------------------------------------------------
float CQntxrdDoc::GetHRatioValue(const char *pMineral, int runno)
{// returns the value of the calibration h-ratio for runnumber runno
// we must pass the peaks we want ratios calc for, the mineral, and the run number
// to GetCalRatio
// if error returns a negative number
float pkratio=GetPkAreaRatio(pMineral, runno);
if(pkratio <0) return(-1.0);
CMinCalibration *cal=theApp.GetCalDocPtr();
// get the qtz/mineral wt% ratio
CString b_std=cal->GenerateBinName(pMineral);
float propratio=cal->GetProportionRatio(b_std, (WORD) runno);
ASSERT(propratio >0);
return(propratio/pkratio);
}
//-------------------------------------------------------------------------------------
float CQntxrdDoc::GetHRatioMean(const char *pMineral)
{// determines the mean ratio, given the use arrays are set to
// indicate which calibration points to use, and which hkl values
// have been selected with values, also calcualtes the stdev of the mean
// returns : -ve value if an error
// 
if(!CheckForValidIntStd() ) return (-1.0);
int numU=GetNumUsageValues(pMineral);
float *h_ratio= new float[numU];
float mean={0.0};
int num={0};
for(int i=1; i<=numU; i++)
// checks if usage flag is set for this run, if so add the ratio
	{
	 if(GetUsage(pMineral, i) ) 
	 		{mean +=(h_ratio[i-1]=GetHRatioValue(pMineral, i));
	 		num++;}
	 		else
	 		h_ratio[i-1]= -1.0;// indicate to next bit no valid h_ratio
	}
mean=mean/(float) num;	
ASSERT(mean >0.0);
// now the  standard devviation
h_ratio_stdev=0.0;
for(i=0; i<numU;i++)
	{
	if(h_ratio[i] >0)
		h_ratio_stdev+= (h_ratio[i]-mean)*(h_ratio[i]-mean);
	}
h_ratio_stdev = (float) sqrt(  (double) h_ratio_stdev)/num ;
delete [] h_ratio;
return mean;
}
//----------------------------------------------------------------------------------------------
float CQntxrdDoc::GetPkAreaRatio(const char *pMineral, int runno)
{// returns the value of the calibration pkarea ratios for runnumber runno
// we must pass the peaks we want ratios calc for, the mineral, and the run number
// to GetCalRatio
// if error returns a negative number
CMapStringToPtr *qmap, *smap;
CStringArray q_hkl, s_hkl;// hold hkl values from entered datafile
CObject *pObj;
VERIFY(m_Data.Lookup(INT_STD,pObj));
qmap=(CMapStringToPtr *) pObj;
VERIFY(runno >0 && runno <=GetNumUsageValues(pMineral));
CString str=pMineral;
if(str.CompareNoCase(INT_STD) == 0) return (-1.0);// error if internal std
VERIFY(m_Data.Lookup(pMineral, pObj));
smap=(CMapStringToPtr *) pObj;
void *pvoid;
// copy qtz hkl strings into string array
for(POSITION pos=qmap->GetStartPosition(); pos !=NULL;)
	{
	qmap->GetNextAssoc(pos, str, pvoid);
	q_hkl.Add(str);
	}
// copy unknown hkl strings
for(pos=smap->GetStartPosition(); pos !=NULL;)
	{
	smap->GetNextAssoc(pos, str, pvoid);
	s_hkl.Add(str);
	}
CMinCalibration *cal=theApp.GetCalDocPtr();
// gets pkarea qtz/min pkarea ratio
return (cal->GetCalRatio(q_hkl, s_hkl, pMineral, runno));
}
//-------------------------------------------------------------------------------------
CString CQntxrdDoc::GetPkAreaString(const char  *pMineral, int runno)
{ // returns the H-ratio string to the ratio dialog, of the ratio for the current data
CString str;
//lets see if data fro int std entered first
if( !CheckForValidIntStd()) return str;
str=pMineral;// make sure not asking for int std
if( str.CompareNoCase(INT_STD) == 0) 
		{TRACE0(" internal standard passed to CQntxrdDoc::GetUsageString\n");
		return (str="");}
float ratio=GetPkAreaRatio(pMineral, runno);
if (ratio <0.0)
	{TRACE1(" error in accessing ratio string for minerl=%s",pMineral);
	TRACE1("  run number =%d",runno);
	return str;
	}
char buf[50];int dp={3};
ftoa(&ratio,buf,&dp);
return(str=buf);
}
//------------------------------------------------------------------------------------
BOOL CQntxrdDoc::GetHKLs(const char *pMineral, CStringArray &hkl)
{// retusn hkl values for this mineral in hkl
// retusn value=FALSE if error,
// we must treat the internal standard as a special case
if(hkl.GetSize() >0 ) hkl.RemoveAll();
CString min=pMineral;
if(min.CompareNoCase(INT_STD)==0 )
	{
		// the m_intstd map should  contain the strings we want, so extract then
		ASSERT( m_intstd.GetCount() >0);
		CString hklstr,spacing;
		for(POSITION pos=m_intstd.GetStartPosition(); pos !=NULL;)
			{
			m_intstd.GetNextAssoc(pos,hklstr, spacing);
			hkl.Add(hklstr);
			}
	}
	else
	{// is not internal std
	BINARYREF *data=GetCalData(pMineral); // get the ptr to the data
	if( data ==NULL) return FALSE;
// check that is for same mineral
	if((data->Unknown.Mineral.CompareNoCase(pMineral)) !=0) return FALSE;
	for(int i=0; i<=data->Unknown.Hkl.GetUpperBound(); i++)
		// transfer into the supplied array
				hkl.Add(data->Unknown.Hkl.GetAt(i));	
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------
BINARYREF *CQntxrdDoc::GetCalData(const char *pMineral)
{
if (strlen(pMineral) ==0) return NULL;
CMinData *ref=theApp.GetRefDocPtr();
if(ref ==NULL) return NULL;
// construct the binary name
CString b_name=INT_STD;
b_name=b_name+"/";b_name=b_name+pMineral;
BINARYREF *data=ref->GetBinaryRef(b_name);// get the ptr to the data
return data;
}
//-------------------------------------------------------------------------------
void CQntxrdDoc::GetIntStdData()
{
	// for internal standard, we must find all the hkl's from all the
	// binary standards, and supply as a list, we will collect them
	// into a CMapStringToString - m_intstd, which maps hkl values to d-spacings
	// as strings
	CMinData *pDoc=theApp.GetRefDocPtr();
	ASSERT(pDoc !=NULL);
	CStringArray *pBin=pDoc->GetBinaryNames();
	BINARYREF *pref;
	for(int i=0;i<=pBin->GetUpperBound(); i++)
			{
			pref=pDoc->GetBinaryRef (pBin->GetAt(i));
			// this adds the hkl strings, it works because the map recognises
			// any duplicate strings
			for(int k=0;k<=pref->IntStd.Hkl.GetUpperBound(); k++) 
						
						m_intstd[pref->IntStd.Hkl[k]] =ConvertSpacing(pref->IntStd.Ds[k]);
			}
}
//------------------------------------------------------------------------------------------------
BOOL CQntxrdDoc::GetD_Space(const char *pMineral, CStringArray &ds)
{ // retuns d-spacings , as strings in ds
// retusn value=FALSE if error, 
if(ds.GetSize() >0 ) ds.RemoveAll();
CString min=pMineral;
if(min.CompareNoCase(INT_STD)==0 )
	{
		// the m_intstd map should  contain the strings we want, so extract then
		ASSERT( m_intstd.GetCount() >0);
		CString hklstr,spacing;
		for(POSITION pos=m_intstd.GetStartPosition(); pos !=NULL;)
			{
			m_intstd.GetNextAssoc(pos,hklstr, spacing);
			ds.Add(spacing);
			}
	}
	else
	{
	BINARYREF *data=GetCalData(pMineral); ;// get the ptr to the data
	if( data ==NULL) return FALSE;
// check that is for same mineral
	if((data->Unknown.Mineral.CompareNoCase(pMineral)) !=0) return FALSE;
	for(int i=0; i<=data->Unknown.Hkl.GetUpperBound(); i++)
	// transfer into the supplied array
				ds.Add(ConvertSpacing(data->Unknown.Ds[i]));	
	}
return TRUE;
}
//-----------------------------------------------------------------------------------
CString CQntxrdDoc::ConvertSpacing(float dspace)
{// converts the d-spaing into a CString object
char buf[50];int dp={2};
CString str;
ftoa(&dspace,buf,&dp);
return (str=buf);
}
//------------------------------------------------------------------------------------
void CQntxrdDoc::GetMineralsFromDBF(CStringArray &mins)
{// fills the array with all the minerals names in the dbf
 mins.Add(INT_STD); // add standrad
 CMinData *pRef=theApp.GetRefDocPtr();
 CStringArray *b_stds=pRef->GetBinaryNames();
 ASSERT(b_stds->GetSize() >0);
BINARYREF *pdata; 
 for(int i=0; i<=b_stds->GetUpperBound(); i++)
 	{
 	pdata=pRef->GetBinaryRef(b_stds->GetAt(i));// ptr to binary refvstructure
 	mins.Add(pdata->Unknown.Mineral);
 	}
}
void CQntxrdDoc::OnFileSave()
{
	CDocument::OnFileSave();
	CString str=GetPathName();
	theApp.UpdateIniFileWithDocPath(str);
}

void CQntxrdDoc::OnFileSaveAs()
{
	CDocument::OnFileSaveAs();
	CString str=GetPathName();
	theApp.UpdateIniFileWithDocPath(str);
}
//-----------------------------------------------------------------------------------------
void CQntxrdDoc::DisplayDBFError(int type)
{
CString str;
switch (type)
	{
	case   NO_CAL_DBF:
	str="No Calibration data base found !!\n The program cannot continue without this\n";
	str+="Please load the Calibration Database\n";break;
	case NO_REF_DBF:
	str="No Minerals Reference  data base found !!\n The program cannot continue without this\n";
	str+="Please load the Reference Database\n";break;
	case INTSTD_FIRST:
	str="Data for internal standard:\n";str=str+INT_STD;
	str=str+" must be entered first"; break;
	case HALT_INTSTD:
	str="Silly Billy !!\n";str+="Cannot view the ratios for internal standard\n";
	str=str+" since the minerals are ratioed with the internal standard";break;
	case NO_DATA_FOR_MINERAL:
	str="No Data has been entered for\n";
	str=str+" the mineral currently on the form";break;
	case INSUF_DATA:
	str=" Insufficient data to calculate results !\n Only Internal Standard data entered\n";
	break;
	}
AfxMessageBox(str);	
}
//---------------------------------------------------------------------------------
void CQntxrdDoc::ClearResults(CMapStringToPtr &RMap)
{// clears the results from the possible empty map
POSITION pos;
CString Mineral;
void *ptr;
if(RMap.GetCount() >0) 
		{// cleans the data from map
		// : supplied map is not empty\n");
		for(pos=RMap.GetStartPosition(); pos !=NULL;)
			{
			RMap.GetNextAssoc(pos,Mineral, ptr);
			delete (XRDRESULTS *) ptr;
			}
			RMap.RemoveAll();
		}
}
//--------------------------------------------------------------------------------------
BOOL CQntxrdDoc::CalculateResults(CMapStringToPtr &RMap)
{ // calulates the xrd results, using the current state of results stored
//    should be called with a pointer to map, which is filled with data
POSITION pos;
CString Mineral;
void *ptr;
if(RMap.GetCount() >0) 
		{// cleans the data from map
		TRACE0("Doc::CalculateResults : supplied map is not empty\n");
		ClearResults(RMap);
		}
// now lets add strings maps, and craete the XRDRESULTS strcutures
CObject *pObj;                                                       
XRDRESULTS *pres;
for(pos=m_Data.GetStartPosition(); pos !=NULL;)
	{
	m_Data.GetNextAssoc(pos,Mineral,pObj);
	 pres= new XRDRESULTS;
	 ASSERT(pres !=NULL);
	 RMap.SetAt(Mineral, pres);// adds the maps, but no data yest
	}
// now do the hard work of calculating the results
// go through each mineral, calculat the mean ratio, possibly excludeing one for more
// and calc the raw % values to put into strcutures
TRACE0("CQntxrdDoc::CalculateResults()\n");
CMinCalibration *pCal=theApp.GetCalDocPtr();
float sumhi={0};float sumerr={0};
for(pos=RMap.GetStartPosition(); pos !=NULL;)
	{
	RMap.GetNextAssoc(pos,Mineral, ptr);
	pres=(XRDRESULTS *) ptr;
	if(Mineral.CompareNoCase(INT_STD) ==0)
			{// is internal std
			pres->h_ratio=1.0;
			pres->esterror=0.0;// initally set to zero
			}
			else
			{// not int std
			pres->h_ratio=GetHRatioMean(Mineral);
			pres->esterror=h_ratio_stdev/pres->h_ratio;// converts to % of h-ratio
			}
	 pres->sumarea=GetSumPeakArea(Mineral);//the summed pk area
	 sumhi+=(pres->h_ratio *pres->sumarea); // the H-ratio times the pk area
	 sumerr+=pres->esterror;// used to calc av sd for internal std
	TRACE1("%s :",Mineral);
	TRACE1("  Mean h-ratio =%f ",pres->h_ratio);
	TRACE1( ",   pkarea=%f", pres->sumarea);
	TRACE1(", esterror(stdevv) =%f\n", pres->esterror);
	}
// error estimate for internal std is average of others (as %)
RMap.Lookup(INT_STD, ptr);
pres=(XRDRESULTS *) ptr;
pres->esterror=sumerr/(RMap.GetCount() -1);
// now determined the  wt% fractions
for(pos=RMap.GetStartPosition(); pos !=NULL;)
	{
	RMap.GetNextAssoc(pos, Mineral, ptr);
	pres=(XRDRESULTS *) ptr;
	pres->per=((pres->h_ratio * pres->sumarea) /sumhi)*100.0F;
	pres->esterror=pres->per*pres->esterror; //absolute error in % of total
	TRACE1(" %s :",Mineral);
	TRACE1(" wt%= %f ",pres->per);
	TRACE1("    %f\n", pres->esterror);
	}
return TRUE;
}
//-------------------------------------------------------------------------------------
float CQntxrdDoc::GetSumPeakArea(const char * pMineral)
{
CObject *pObj;
CMapStringToPtr *pmap;
float peaksum={0.0};
if( m_Data.Lookup(pMineral,  pObj) )
	{
	void *pvoid;
	CString hkl;
	ASSERT(pObj !=NULL);
	pmap=(CMapStringToPtr *) pObj;
	for(POSITION pos=pmap->GetStartPosition(); pos !=NULL;)
		{
		pmap->GetNextAssoc(pos, hkl,pvoid);
		ASSERT(hkl.GetLength() >0);
		 peaksum+=( (PEAK *) pvoid)->pkarea;
		}
	}
	else
		{
		TRACE("Doc:GetSumPeakArea() minerals not found= %s\n",pMineral);
		ASSERT(FALSE);
		}
return peaksum;
}


void CQntxrdDoc::OnFileCloseData()
{
	OnCloseDocument(); 
	
}
void CQntxrdDoc::OnCloseDocument()
{ // all document termination is done through this
BOOL mod;
if( (mod=IsModified()) !=0)
	{
	if(SaveModified() ) 
		{OnFileSave();
		SetModifiedFlag(FALSE);// have now save data}
		}
	}
CDocument::OnCloseDocument();
}
