// qxrddoc.h : interface of the CQntxrdDoc class
//
// various errors detected by the document and view
#define NO_CAL_DBF	1 
#define NO_REF_DBF	2
#define INTSTD_FIRST	3
#define HALT_INTSTD	4
#define NO_DATA_FOR_MINERAL	5
#define INSUF_DATA	6
/////////////////////////////////////////////////////////////////////////////       
// the structure holding data about each peak
struct  PEAK
		{
	     float pkarea;  // the peak area
	     CString HKL;// the hkl string which uniquely identifies the peak
        };
struct XRDRESULTS
	{ // holds the computed results for a mineral
	float h_ratio; // mean h ratio
	float sumarea;// the summed pk area for this mineral
	float per; // adjusted %, accounting for other mins
	float esterror; //error estimate, derived from stdev of h-ratio
	};
class CQntxrdDoc : public CDocument
{
protected: // create from serialization only
	CQntxrdDoc();
	DECLARE_DYNCREATE(CQntxrdDoc)
/* data is stored as dynamically allocated PEAK structures, which are referenced
by  two maps 
a)m_Data contains the mineral names, which is used as a map to the CmapStringToPtr
 objects (pmaps) which are dynamically created.
b) The pmaps stored pointers to PEAK structures, which are accessed by
the HKL string

The informtion about which calibration runs are used to calcualte the 
mean ratio is stored in the m_Ratios, which is a companion map
to m_Data. (contain the same number of entries)
We alos keep track of the ref/cal dbf files., since these are linked to the
data, and cannot be changed whilst this document is active
*/
	BOOL m_InitFail; // is set to true if error in loading file
	CString m_RefDoc; // holds the reference dbf use
	CString m_CalDoc; // the calibration doc used
	CString m_DataName; // the data name
	CString m_Comment; // comment field
	UINT m_nMins; // number of different minerals with recorded data
	CMapStringToOb m_Data; // Maps mineral names to CMapStringToPtr objects
	CMapStringToPtr m_Ratios; // maps strings to arrays of  BOOL ratio values   
	CMapStringToString m_intstd; // this contains the internal std hkl (maps) and d-spacing
	float h_ratio_stdev; // h-ratio standrad deviation

// Attributes
public:
// for accessing, setting header data
/*	void SetRefDBF(const char *pdbf){ m_RefDoc=pdbf;}; // sets linked ref/cal documents
	void SetCalDBF(const char *pdbf){ m_CalDoc=pdbf;};
	CString GetRefDBF(void) { return m_RefDoc;}; // gets linked ref/cal docs
	CString GetCalDBF(void) { return m_CalDoc;};*/
	void DisplayDBFError(int type);
	void SetName(const char *str) {m_DataName=str;SetModifiedFlag();};
	void SetComment(const char *str) {m_Comment =str;SetModifiedFlag();};
	CString Getname(void) {return m_DataName;};
	CString GetComment(void) {return m_Comment;};
// to do with accessing , updating the peak ratio data
	BOOL GetHKLs(const char *pMineral, CStringArray &hkl);
	BOOL GetD_Space(const char *pMineral, CStringArray &ds);
// to do with calculation fo the wt% and reading the entered pk area
	BOOL CalculateResults(CMapStringToPtr &pmap); // 
    void ClearResults(CMapStringToPtr &RMap); // clearing allocated results
	UINT GetNumMins(void) { return m_nMins;};
	BOOL AddPeak(const char *pMineral, const char *pHkl, float pkarea);
	BOOL RemovePeak(const char *pMineral, const char *pHkl);
	PEAK *GetPeak(const char *pMineral, const char *pHkl);      
// to do with accessing Usage BOOL values- transfer to ratio dlg etc
	int GetNumUsageValues(const char *pMineral);
	void UpDateUsage(const char *pMineral, int index, BOOL value);
	BOOL GetUsage(const char *pMineral, int index);
// to do with accessing calibration H-ratios values
	CString GetHRatioString(const char  *pMineral, int runno);
	CMapStringToOb *GetMineralMap(void) {return &m_Data;};  
	void GetMineralsFromDBF(CStringArray &mins);
	float GetHRatioValue(const char *pMineral, int runno);
	float GetHRatioMean(const char *pMineral);
// accesssing the pkarea ratio data
	CString GetPkAreaString(const char *curmin, int runno);
	float GetPkAreaRatio(const char *Curmin, int runno);
// various checking routines
	BOOL CheckForValidIntStd();// sees if valid int std data when gettting ratios
	BOOL IsThisValid(const char *pMineral); // sees if any data for this mineral, treu=ok
	
	void UpdateResultsView(CView *psender, LPARAM lhint, CObject *phint)
							{UpdateAllViews(psender, lhint, phint);};

// Operations
private:
// pk ratio access, creatinn
PEAK *PutNewPeaks(const char *pHkl, float pkarea);
void AddPeakToObj( CMapStringToPtr *pmap,const  char *pHkl, float pkarea);
void RemoveMineral(const char *min);
float GetSumPeakArea(const char *pmin); // sums peaks area sfor supplied mineral
// accessing calibration ratios, d-spacings
BINARYREF *GetCalData(const char *pMineral);
CString ConvertSpacing(float dspace);
void GetIntStdData();
// serialissation
void SerializeMap(CArchive& ar);
void SerializeRatios(CArchive& ar);

// ratio access , creation
BOOL *PutNewRatios(const char *pMineral);

// Implementation
public:
	virtual ~CQntxrdDoc();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
    virtual void DeleteContents(void);
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
protected:
	virtual	BOOL	OnNewDocument();
	virtual BOOL OnOpenDocument(const char *pszPathname);
public:
	virtual void OnCloseDocument();

// Generated message map functions
protected:
	//{{AFX_MSG(CQntxrdDoc)
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileCloseData();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
