// qxrdvw.cpp : implementation of the CQntxrdView class
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
#include "..\utilclas\general.h"

#include "qxrddoc.h"
#include "qntxrd.h"
#include "qxrdvw.h"
#include "datavw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
	#define MINERAL_COL 	2
	#define H_RATIO_COL		15
	#define AREA_COL		25
	#define PERCENT_COL		38

/////////////////////////////////////////////////////////////////////////////
// CQntxrdView

IMPLEMENT_DYNCREATE(CQntxrdView, CView)
#define new DEBUG_NEW

BEGIN_MESSAGE_MAP(CQntxrdView, CView)
	//{{AFX_MSG_MAP(CQntxrdView)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQntxrdView construction/destruction

CQntxrdView::CQntxrdView()
{
	// TODO: add construction code here
}

CQntxrdView::~CQntxrdView()
{
CQntxrdDoc* pDoc = GetDocument();
pDoc->ClearResults(results);
}

/////////////////////////////////////////////////////////////////////////////
// CQntxrdView drawing

void CQntxrdView::OnDraw(CDC* pDC)
{
	CQntxrdDoc* pDoc = GetDocument();

	CBrush brushBackground;

	// save colors for drawing selected item on the screen
	COLORREF crOldText = 0;
	COLORREF crOldBackground = 0;

	if (!pDC->IsPrinting())
	{
		brushBackground.CreateSolidBrush(::GetSysColor(COLOR_WINDOW));
		CRect rectSelection;
		pDC->GetClipBox(&rectSelection);
		rectSelection.top = 1;
		rectSelection.bottom = 1+pDoc->GetNumMins();
		pDC->FillRect(&rectSelection, &brushBackground);
	}

	TEXTMETRIC tm;
	pDC->GetTextMetrics(&tm);
	int RowHeight=tm.tmHeight;
	int y=RowHeight;
	CString str="  ";

	char num[33];
	// display the data name along the top
	// display the column titles
		pDC->TextOut(5*tm.tmAveCharWidth, y, pDoc->Getname());  
		y=y+RowHeight;
		pDC->TextOut(1,y,str);
		strcpy(num,"Mineral");
		y=y+RowHeight;
		pDC->TextOut(MINERAL_COL*tm.tmAveCharWidth, y, num,strlen(num));
		strcpy(num,"H-ratio");
		pDC->TextOut(H_RATIO_COL*tm.tmAveCharWidth,y,num,strlen(num));
		strcpy(num,"Peak Area");
		pDC->TextOut(AREA_COL*tm.tmAveCharWidth,y,num,strlen(num));
		strcpy(num,"Weight %");
		pDC->TextOut(PERCENT_COL*tm.tmAveCharWidth,y,num,strlen(num));

	// calculate the values 
		
		pDoc->CalculateResults(results);
		// now draw the values
		CString Mineral;
		void *pvoid;
		XRDRESULTS *res;
		int decimalplace=3; 
		y=y+(2*RowHeight);
		for(POSITION pos=results.GetStartPosition(); pos !=NULL;)
			{
			results.GetNextAssoc(pos, Mineral, pvoid);
			res=(XRDRESULTS *) pvoid;
			pDC->TextOut(MINERAL_COL*tm.tmAveCharWidth, y, Mineral);
			ftoa(&(res->h_ratio),num,&decimalplace);
			pDC->TextOut(H_RATIO_COL*tm.tmAveCharWidth, y, num,strlen(num));
			decimalplace=1;
			ftoa(&(res->sumarea),num, &decimalplace);
			pDC->TextOut(AREA_COL*tm.tmAveCharWidth, y, num, strlen(num));
			ftoa(&(res->per),num, &decimalplace); 
			str=strcat(num,"   ");
			ftoa(&(res->esterror), num, &decimalplace);
			str+=num;
			pDC->TextOut(PERCENT_COL*tm.tmAveCharWidth, y, str );
			y+=RowHeight;
			}
     pDoc->ClearResults(results);
	// Restore the DC.
	if (!pDC->IsPrinting() )
	{
		pDC->SetBkColor(crOldBackground);
		pDC->SetTextColor(crOldText);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CQntxrdView printing

BOOL CQntxrdView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CQntxrdView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CQntxrdView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}




/////////////////////////////////////////////////////////////////////////////
// CQntxrdView diagnostics

#ifdef _DEBUG
void CQntxrdView::AssertValid() const
{
	CView::AssertValid();
}

void CQntxrdView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CQntxrdDoc* CQntxrdView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CQntxrdDoc)));
	return (CQntxrdDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQntxrdView message handlers

 void CQntxrdView::OnUpdate(CView *psender, LPARAM lhint, CObject *pHint)
 {
 if (psender->IsKindOf(RUNTIME_CLASS(CDataVw)) && lhint==2)
 	{
 	// sent from the calculate button to update the results- re-draw entire screen
 	Invalidate();
 	}
 	
 }

