// ratiodlg.cpp : implementation file
//

#include "stdafx.h"
#include "..\dbfutil\readdbf.h"
#include "..\dbfutil\mineral.h"
 #include "qxrddoc.h"
#include "qntxrd.h"
#include "ratiodlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define USE_RATIO	0
#define NOT_USE_RATIO	1
#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// CRatioDlg dialog

CRatioDlg::CRatioDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRatioDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRatioDlg)
	m_Mean = 0;
	m_CalUse = -1;
	//}}AFX_DATA_INIT
}

void CRatioDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRatioDlg)
	DDX_Control(pDX, IDC_RATIO_LIST, m_Ratio);
	DDX_Text(pDX, IDC_MEAN, m_Mean);
	DDX_Radio(pDX, IDC_CAL_USE, m_CalUse);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRatioDlg, CDialog)
	//{{AFX_MSG_MAP(CRatioDlg)
	ON_BN_CLICKED(IDC_CAL_IG, OnClickedCalUse)
	ON_BN_CLICKED(IDC_CAL_USE, OnClickedCalUse)
	ON_LBN_SELCHANGE(IDC_RATIO_LIST, OnSelchangeRatioList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRatioDlg message handlers

void CRatioDlg::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CRatioDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CRatioDlg::OnClickedCalUse()
{
	UpdateData(TRUE);
	if(m_CalUse== USE_RATIO) m_Selected=TRUE;
			else m_Selected=FALSE;
	pDoc->UpDateUsage(m_CurMin, m_CurSel+1, m_Selected);
	SetUsage();
	UpdateData(FALSE);
}
 
 BOOL CRatioDlg::OnInitDialog(void)
 {
 CDialog::OnInitDialog();
 // now update the dialog before display
 CString blank="                                                                           ";
 CString ratio;
 CMinCalibration *pCal= theApp.GetCalDocPtr();
 CString bin= pCal->GenerateBinName(m_CurMin);
 for(int i=1; i<=pDoc->GetNumUsageValues(m_CurMin);i++)
 	{
 	ratio=pDoc->GetPkAreaString(m_CurMin,i);
 	ratio+=blank.Left(20-ratio.GetLength());// adds variable blank
 	ratio+=pDoc->GetHRatioString(m_CurMin, i);
 	ratio+=blank.Left(36-ratio.GetLength());// adds variable blank
 	ratio+=pCal->GetPropStrings(bin, (WORD) i);
 	 m_Ratio.AddString(ratio);// ads to list box
 	}
m_Ratio.SetCurSel(0);
m_CurSel=0;
SetUsage();
UpdateData(FALSE);
return TRUE;
}
//--------------------------------------------------------------------
void CRatioDlg::SetUsage(void)
{
m_Mean=pDoc->GetHRatioMean(m_CurMin); 
m_Selected=pDoc->GetUsage(m_CurMin,m_CurSel+1);
if(m_Selected) m_CalUse=USE_RATIO;
		else m_CalUse=NOT_USE_RATIO;
 }
 
 void CRatioDlg::SetData(CQntxrdDoc *doc, const char *pMineral)
 {
 m_CurMin=pMineral;
 pDoc=doc;
 }
void CRatioDlg::OnSelchangeRatioList()
{
	UpdateData(TRUE);// copy radio button data to document
	pDoc->UpDateUsage(m_CurMin, m_CurSel+1, m_Selected);
// now get new selected field			
	m_CurSel=m_Ratio.GetCurSel();
	SetUsage();
	UpdateData(FALSE);
}

