.cens.nll.uv.Linf <-
  function(theta,Vmod,uvexc,n.nexc,thresh,maxlam=1,ncore)
  {
    # assign parameters
    
    if(Vmod=="beta"){a<-theta[2]; rangea<- a<0.05}
    else if(Vmod=="logistic"){a<-theta[2]; rangea<-(a<0.01||a>0.995)}
    else if(Vmod=="lp"){a<-theta[2]; rangea<-(a<1)}
    
    lam<-theta[1]
    
    # give impossible parameters high negative log-likelihoods
    
    if(lam>maxlam||rangea){return(10e10)}
    
    else{
      # apply censoring
      
      # contribution of censored components
      up<-((1/(0.1*0.05))^lam-1)/lam 
      if(length(thresh)==1)
      {
        puvnexc<-tryCatch(.Cop.lam.Linf.diag(u=c(thresh),lam=lam,a=a,b=b,Vmod=Vmod,up=up), error=function(e) e)
      }
      else
      {
        puvnexc<-tryCatch(.Cop.lam.Linf(uv=c(thresh),lam=lam,a=a,b=b,Vmod=Vmod,up=up), error=function(e) e)
      }
      
      if(is.element("error",class(puvnexc)))
      {
        warning(paste("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",",round(a,4),
                      "\n NA returned to optimization"))
        return(NA)
      }
      
      # apply probability integral transform to margins
      
      # link upper limit to be just above highest needed quantile -- speed up computation
      
      hq<-1-0.95*(1-max(uvexc))
      up<-tryCatch(.Q.lam.Linf(hq,lam=lam,a=a,b=b,Vmod=Vmod,up=10e10),error=function(e) e)
      
      if(is.element("error",class(up)))
      {
        warning(paste("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",",round(a,4),
                      "\n NA returned to optimization"))
        return(NA)
      }
      
      if(ncore>1)
      {
        suppressWarnings(x<-tryCatch(multicore::mclapply(uvexc[,1],.Q.lam.Linf,lam=lam,a=a,b=b,Vmod=Vmod,up=up,mc.cores=ncore),error=function(e) e))
        suppressWarnings(y<-tryCatch(multicore::mclapply(uvexc[,2],.Q.lam.Linf,lam=lam,a=a,b=b,Vmod=Vmod,up=up,mc.cores=ncore),error=function(e) e))
      }
      
      else{
        x<-tryCatch(lapply(uvexc[,1],.Q.lam.Linf,lam=lam,a=a,b=b,Vmod=Vmod,up=up),error=function(e) e)
        y<-tryCatch(lapply(uvexc[,2],.Q.lam.Linf,lam=lam,a=a,b=b,Vmod=Vmod,up=up),error=function(e) e)
      }
      
      if(is.element("error",class(x))||is.element("error",class(y))||is.element("try-error",sapply(x,class))||is.element("try-error",sapply(y,class)))
      {
        warning("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",", round(a,4),
                "\n NA returned to optimization")
        return(NA)
      }
      
      x<-unlist(x)
      y<-unlist(y)
      
      # for AI data get values of u near 0 in 1 or both margins
      # u never = 0 so x should not = 0; sometimes this is returned by Q.lam, and this causes problems in fx as end up with E(1/W), which is divergent for beta shape param <1
      # therefore change 0s to other small values
      
      if(sum(x==0)+sum(y==0) >0)
      {
        x[x==0]<-min(x[x>0])/2
        y[y==0]<-min(y[y>0])/2
        
        warning("Some values of x or y numerically 0; replaced with value 0.5*(smallest positive value)")
      }
      # define transformed coordinates
      w<-x/(x+y)
      r<-x+y
      L<-.Linf2(x,y)
      
      if(lam<0 && any(-lam>1/L)){return(10e10)}
      else{
        ld1<-log(.vdens(w,Vmod,a,b))
        
        # lambda>0 
        if(abs(lam)>1e-10)
        {
          ld2<-(-1/lam-1)*log(1+L*lam) +log(L) - 2*log(r) # -log(r) needed as margins depend on parameters here
        }
        
        # lambda=0
        else{ld2<- - L +log(L) -2*log(r)}
        if(ncore>1)
        { 
          d3x<- suppressWarnings(tryCatch(multicore::mclapply(x,.fx.Linf,a=a,b=b,Vmod=Vmod,lam=lam,mc.cores=ncore), error=function(e) e))
          d3y<- suppressWarnings(tryCatch(multicore::mclapply(y,.fx.Linf,a=a,b=b,Vmod=Vmod,lam=lam,mc.cores=ncore), error=function(e) e))
        }
        
        else{
          d3x<- tryCatch(lapply(x,.fx.Linf,a=a,b=b,Vmod=Vmod,lam=lam), error=function(e) e)
          d3y<- tryCatch(lapply(y,.fx.Linf,a=a,b=b,Vmod=Vmod,lam=lam), error=function(e) e)
        }
        
        if(is.element("error",class(d3x))||is.element("error",class(d3y))||is.element("try-error",sapply(d3x,class))||is.element("try-error",sapply(d3y,class)))
        {
          warning("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",", round(a,4),
                  "\n NA returned to optimization")
          return(NA)
        }
        
        d3x<-unlist(d3x)
        d3y<-unlist(d3y)
        
        ld3<- -log(d3x)-log(d3y)
        
        # negative log-likelihood for censored / uncensored components
        
        nll<--log(puvnexc)*n.nexc-sum(ld1+ld2+ld3)
        
        
        return(nll)
      }
    }
  }

.cens.nll.uv.Lp <-
function(theta,p,Vmod,uvexc,n.nexc,thresh,maxlam=1,ncore)
  {
    # assign parameters
    
    if(Vmod=="beta"){a<-theta[2]; rangea<- a<0.05}
    else if(Vmod=="logistic"){a<-theta[2]; rangea<-(a<0.01||a>0.995)}
    else if(Vmod=="lp"){a<-theta[2]; rangea<-(a<1)}
    
    lam<-theta[1]
    
    # give impossible parameters high negative log-likelihoods
    
    if(lam>maxlam||rangea){return(10e10)}
    else{
      
      
      # contribution of censored components
      if(length(thresh)==1)
      {
        puvnexc<-.Cop.lam.Lp.diag(u=c(thresh),lam=lam,a=a,b=b,Vmod=Vmod,p=p)
      }
      else{
        puvnexc<-.Cop.lam.Lp(uv=c(thresh),lam=lam,a=a,b=b,Vmod=Vmod,p=p)
      }
      
      # apply probability integral transform to margins
      
      
      # link upper limit to be just above highest needed quantile -- speed up computation
      
      hq<-1-0.95*(1-max(uvexc))
      up<-tryCatch(.Q.lam.Lp(hq,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=10e10),error=function(e) e)
      
      if(is.element("error",class(up)))
      {
        warning(paste("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",",round(a,4),
                      "\n NA returned to optimization"))
        return(NA)
      }
      
      if(ncore>1)
      {
        suppressWarnings(x<-tryCatch(multicore::mclapply(uvexc[,1],.Q.lam.Lp,p=p,lam=lam,a=a,b=b,Vmod=Vmod,up=up,mc.cores=ncore),error=function(e) e))
        suppressWarnings(y<-tryCatch(multicore::mclapply(uvexc[,2],.Q.lam.Lp,p=p,lam=lam,a=a,b=b,Vmod=Vmod,up=up,mc.cores=ncore),error=function(e) e))
      }
      
      else{
        x<-tryCatch(lapply(uvexc[,1],.Q.lam.Lp,lam=lam,a=a,b=b,p=p,Vmod=Vmod,up=up),error=function(e) e)
        y<-tryCatch(lapply(uvexc[,2],.Q.lam.Lp,lam=lam,a=a,b=b,p=p,Vmod=Vmod,up=up),error=function(e) e)
      }
      
      if(is.element("error",class(x))||is.element("error",class(y))||is.element("try-error",sapply(x,class))||is.element("try-error",sapply(y,class)))
      {
        warning("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",", round(a,4),
                "\n NA returned to optimization")
        return(NA)
      }
      
      x<-unlist(x)
      y<-unlist(y)
      
      # for AI data get values of u near 0 in 1 or both margins
      # u never = 0 so x should not = 0; sometimes this is returned by Q.lam, and this causes problems in fx as end up with E(1/W), which is divergent for beta shape param <1
      # therefore change 0s to other small values
      
      if(sum(x==0)+sum(y==0) >0)
      {
        #   x[x==0]<-min(x[x>0])/2
        #  y[y==0]<-min(y[y>0])/2
        x[x==0]<-1e-5
        y[y==0]<-1e-5
        warning("Some values of x or y numerically 0; replaced with value 0.5*(smallest positive value)")
      }
      
      # define transformed coordinates
      w<-x/(x+y)
      r<-x+y
      L<-.Lp2(x,y,p=p)
      
      if(lam<0 && any(-lam>1/L)){return(10e10)}
      else{
        ld1<-log(.vdens(w,Vmod,a,b))
        
        # lambda>0 
        if(abs(lam)>1e-10)
        {
          ld2<-(-1/lam-1)*log(1+L*lam) +log(L) - 2*log(r) # -log(r) needed as margins depend on parameters here
        }
        
        # lambda=0
        else{ld2<- - L +log(L) -2*log(r)}
        
        if(ncore>1)
        { 
          d3x<- suppressWarnings(tryCatch(multicore::mclapply(x,.fx.Lp,p=p,a=a,b=b,Vmod=Vmod,lam=lam,mc.cores=ncore), error=function(e) e))
          d3y<- suppressWarnings(tryCatch(multicore::mclapply(y,.fx.Lp,p=p,a=a,b=b,Vmod=Vmod,lam=lam,mc.cores=ncore), error=function(e) e))
        }
        
        else{
          d3x<- tryCatch(lapply(x,.fx.Lp,p=p,a=a,b=b,Vmod=Vmod,lam=lam), error=function(e) e)
          d3y<- tryCatch(lapply(y,.fx.Lp,p=p,a=a,b=b,Vmod=Vmod,lam=lam), error=function(e) e)
        }
        
        
        if(is.element("error",class(d3x))||is.element("error",class(d3y))||is.element("try-error",sapply(d3x,class))||is.element("try-error",sapply(d3y,class)))
        {
          warning("Numerical difficulties (probably an integration error) occured at parameter values:", round(lam,4),",", round(a,4),
                  "\n NA returned to optimization")
          return(NA)
        }
        
        d3x<-unlist(d3x)
        d3y<-unlist(d3y)
        
        ld3<- -log(d3x)-log(d3y)
        
        # negative log-likelihood for censored / uncensored components
        
        nll<--log(puvnexc)*n.nexc-sum(ld1+ld2+ld3)
        
        return(nll)
      }
    }
  }

.chi.bar.plot <-
  function(x, umin, umax=0.99, lseq=50, emp=TRUE,...)
  {
    useq<-seq(umin,umax,len=lseq)
    
    chi<-NULL
    if(x$Norm=="Linf")
    {
      for(i in 1:length(useq))
      {
        chi[i]<- 2*log(1-useq[i])/log(.Surv.Cop.lam.Linf.diag(u=useq[i],lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel))-1
      }
    }
    
    else if(x$Norm=="Lp")
    {
      for(i in 1:length(useq))
      {
        chi[i]<- 2*log(1-useq[i])/log(.Surv.Cop.lam.Lp.diag(u=useq[i],lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p))-1
      }
    }
    
    ylim<-c(min(chi),max(chi))
    
    if(emp)
    {
      minu<-apply(x$uv,1,min)
      empchi<-empvar<-NULL
      
      for(i in 1:length(useq))
      {
        empchi[i]<-2*log(1-useq[i])/log(sum(minu>useq[i])/length(minu))-1
        pu<-sum(minu>useq[i])/length(minu)
        n<-length(minu)
        empvar[i]<-(1-pu)*(2*log(1-useq[i]))^2/(n*pu*(log(pu))^4)
      }
      if(any(is.na(empvar)))
      {
        warning("Some chi bar estimates = -1; no confidence interval available")
      }
      ylim<-c(min(min(empchi[empchi>-1]-2*sqrt(empvar[empchi>-1]), min(chi))), max(max(empchi[empchi>-1]+2*sqrt(empvar[empchi>-1])), max(chi)))
    }
    
    plot(useq, chi,xlab="u",ylab=expression(bar(chi)),ylim=ylim,typ="l",col=2,...)
    if(emp)
    {
      lines(useq,empchi,lty=2)
      lines(useq[empchi>-1],empchi[empchi>-1]+qnorm(0.975)*sqrt(empvar[empchi>-1]),lty=2)
      lines(useq[empchi>-1],empchi[empchi>-1]-qnorm(0.975)*sqrt(empvar[empchi>-1]),lty=2) 
    }
  }
.chi.plot <-
  function(x, umin, umax=0.99, lseq=50, emp=TRUE,...)
  {
    useq<-seq(umin,umax,len=lseq)
    
    chi<-NULL
    if(x$Norm=="Linf")
    {
      for(i in 1:length(useq))
      {
        chi[i]<-.Surv.Cop.lam.Linf.diag(u=useq[i],lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)/(1-useq[i])
      }
    }
    
    else if(x$Norm=="Lp")
    {
      for(i in 1:length(useq))
      {
        chi[i]<-.Surv.Cop.lam.Lp.diag(u=useq[i],lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)/(1-useq[i])
      }
    }
    
    ylim<-c(min(chi),max(chi))
    
    if(emp)
    {
      minu<-apply(x$uv,1,min)
      empchi<-empvar<-NULL
      for(i in 1:length(useq))
      {
        empchi[i]<-(sum(minu>useq[i])/length(minu))/(1-useq[i])
        empvar[i]<-empchi[i]*(1-empchi[i]) / sum(minu>useq[i]) 
      }
      if(any(empchi>1))
      {
        warning("Some chi estimates > 1; only plotting values <= 1")
        empvar<-empvar[empchi<=1] 
        useq1<-useq[empchi<=1] 
        empchi<-empchi[empchi<=1]
      }
      else if(any(empchi==0)){
        warning("Some chi estimates = 0; no confidence interval available")
        useq1<-useq
      }
      else{useq1<-useq}
      
      ylim<-c(min(min(empchi[empchi>0]-2*sqrt(empvar[empchi>0])), min(chi)), max(max(empchi[empchi>0]+2*sqrt(empvar[empchi>0])), max(chi)))
    }
    
    
    
    plot(useq, chi,xlab="u",ylab=expression(chi),ylim=ylim,typ="l",col=2,...)
    if(emp)
    {
      lines(useq1,empchi,lty=2)
      lines(useq1,empchi+qnorm(0.975)*sqrt(empvar),lty=2)
      lines(useq1,empchi-qnorm(0.975)*sqrt(empvar),lty=2) 
    }
  }
.Cop.lam.Linf <-
function(uv,lam,a,b,Vmod,up=10e10)
{
  u<-uv[1]
  v<-uv[2]
  u+v-1+.Joint.lam2.Linf(x=.Q.lam.Linf(u,lam=lam,a=a,b=b,Vmod=Vmod,up=up),y=.Q.lam.Linf(v,lam=lam,a=a,b=b,Vmod=Vmod,up=up),lam=lam,a=a,b=b,Vmod=Vmod)
}
.Cop.lam.Linf.diag <-
function(u,lam,a,b,Vmod,up=10e10)
{
  x<-.Q.lam.Linf(u,lam=lam,a=a,b=b,Vmod=Vmod,up=up)
  2*u-1+.Joint.lam2.Linf(x=x,y=x,lam=lam,a=a,b=b,Vmod=Vmod)
}
.Cop.lam.Lp <-
function(uv,lam,a,b,Vmod,p,up=10e10)
{
  u<-uv[1]
  v<-uv[2]
  u+v-1+.Joint.lam2.Lp(x=.Q.lam.Lp(u,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=up),y=.Q.lam.Lp(v,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=up),lam=lam,a=a,b=b,Vmod=Vmod,p=p)
}
.Cop.lam.Lp.diag <-
function(u,lam,a,b,Vmod,p,up=10e10)
{
  x<-.Q.lam.Lp(u,lam=lam,a=a,b=b,Vmod=Vmod,p=p)
  2*u-1+.Joint.lam2.Lp(x=x,y=x,lam=lam,a=a,b=b,Vmod=Vmod,p=p)
}
.fx0.Linf <-
function(x,a,b,Vmod)
{
  to.int<-function(w,x,a,b,Vmod,inf)
  {
    exp(-(x*.Linf(w)/w))*(.Linf(w)/w)* .vdens(w,Vmod,a,b)
  }
  
  int<-NULL
  for(i in 1:length(x))
  {
    int[i]<-integrate(to.int,0,1,x=x[i],a=a,b=b,Vmod=Vmod,abs.tol=0)$val
  }
  return(int)
}
.fx0.Lp <-
function(x,a,b,Vmod,p)
{
  to.int<-function(w,x,a,b,Vmod,p)
  {
    exp(-(x*.Lp(w,p)/w))*(.Lp(w,p)/w)*.vdens(w,Vmod,a,b)
  }
  
  int<-NULL
  for(i in 1:length(x))
  {
    int[i]<-integrate(to.int,0,1,x=x[i],a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
  }
  return(int)
}
.fx.Linf <-
function(x,a,b,Vmod,lam)
{
  if(abs(lam)<1e-10)
  {
    return(.fx0.Linf(x=x,a=a,b=b,Vmod=Vmod))
  }
  else{
    to.int<-function(w,x,lam,a,b,Vmod)
    {
      .vdens(w,Vmod,a,b)*(.Linf(w)/w)*(lam*x*.Linf(w)/w+1)^(-1/lam-1)
    }
    
    if(lam>0)
    {lower<-rep(0,length(x))}
    else{lower<- -x*lam/(1-lam*x)} # lower based on max norm and lam<0
    
    int<-NULL
    for(i in 1:length(x))
    {      
      int[i]<-integrate(to.int,lower[i],1,x=x[i],lam=lam,a=a,b=b,Vmod=Vmod,abs.tol=0)$val
    }
    return(int)
  }
}
.fx.Lp <-
function(x,a,b,Vmod,lam,p)
{
  if(abs(lam)<1e-10)
  {
    return(.fx0.Lp(x=x,a=a,b=b,Vmod=Vmod,p=p))
  }
  else{
    to.int<-function(w,x,lam,a,b,Vmod,p)
    {
      .vdens(w,Vmod,a,b)*(.Lp(w,p)/w)*(lam*x*.Lp(w,p)/w+1)^(-1/lam-1)
    }
    
    if(lam>0)
    {lower<-rep(0,length(x))}
    else{lower<-(1+((-lam*x)^(-p)-1)^(1/p))^(-1)}
    
    
    int<-NULL
    for(i in 1:length(x))
    {      
      int[i]<-integrate(to.int,lower[i],1,x=x[i],lam=lam,a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
    }
    return(int)
  }
}
.Joint.02.Linf <-
function(x,y,a,b,Vmod)
{
  to.int<-function(w,x,y,a,b,Vmod)
  {
    vl<-exp(-pmax(x*.Linf(w)/w,y*.Linf(w)/(1-w)))*.vdens(w,Vmod,a,b) 
    return(vl)
  }
  
  int<-integrate(to.int,0,1,x=x,y=y,a=a,b=b,Vmod=Vmod,abs.tol=0)$val
  return(int)
}
.Joint.02.Lp <-
function(x,y,a,b,Vmod,p)
{
  to.int<-function(w,x,y,a,b,Vmod,p)
  {
    vl<-exp(-pmax(x*.Lp(w,p)/w,y*.Lp(w,p)/(1-w)))* .vdens(w,Vmod,a,b)
    return(vl)
  }
  
  int<-integrate(to.int,0,1,x=x,y=y,a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
  
  return(int)
}
.Joint.lam2.Linf <-
function(x,y,lam,a,b,Vmod)
{
  if(abs(lam)<1e-10)
  {
    return(.Joint.02.Linf(x=x,y=y,a=a,b=b,Vmod=Vmod))
  }
  else{
    to.int<-function(w,x,y,lam,a,b,Vmod)
    {
      vl<-pmin((lam*x*.Linf(w)/w+1)^(-1/lam), (lam*y*.Linf(w)/(1-w)+1)^(-1/lam)) * .vdens(w,Vmod,a,b)
      return(vl)
    }
    
  }
  
  if(lam>0){
    lower<-0
    upper<-1}
  else{
    lower<- -x*lam/(1-lam*x)
    upper<-1/(1-lam*y)
    if(lower>upper){
      return(0)
    }
  }
  
  int<-integrate(to.int,lower,upper,x=x,y=y,lam=lam,a=a,b=b,Vmod=Vmod,abs.tol=0)$val
  
  return(int)
  
}
.Joint.lam2.Lp <-
function(x,y,lam,a,b,Vmod,p)
{
  if(abs(lam)<1e-10)
  {
    return(.Joint.02.Lp(x=x,y=y,a=a,b=b,Vmod=Vmod,p=p))
  }
  else{
    to.int<-function(w,x,y,lam,a,b,Vmod,p=p)
    {
      vl<-pmin((lam*x*.Lp(w,p)/w+1)^(-1/lam), (lam*y*.Lp(w,p)/(1-w)+1)^(-1/lam)) *.vdens(w,Vmod,a,b)
      return(vl)
    }
    
  }
  
  if(lam>0){
    lower<-0
    upper<-1}
  else{    
    lower<-(1+((-lam*x)^(-p)-1)^(1/p))^(-1)
    upper<-(1+((-lam*y)^(-p)-1)^(-1/p))^(-1)
    
    if(lower>upper){
      return(0)
    }
  }
  
  int<-integrate(to.int,lower,upper,x=x,y=y,lam=lam,a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
  
  return(int)
  
}
.Linf <-
function(w){return(pmax(w,1-w))}
.Linf2 <-
function(x,y){return(pmax(x,y))}
.logisticdens <-
function(w,a)
{
  0.5*(1/a-1)*w^(1/a-2)*(1-w)^(1/a-2)*(w^(1/a) + (1-w)^(1/a))^(a-2)
}
.Lp <-
function(w,p){(w^p+(1-w)^p)^(1/p)}
.Lp2 <-
function(x,y,p){(x^p+y^p)^(1/p)}
.Marg.0.Linf <-
function(x,a,b,Vmod)
{
  to.int<-function(w,x,a,b,Vmod)
  {
    exp(-(x*.Linf(w)/w))* .vdens(w,Vmod,a,b)
  }
  
  if(length(x)>1){stop("x should be scalar")}
  
  int<-integrate(to.int,0,1,x=x,a=a,b=b,Vmod=Vmod,abs.tol=0)$val
  
  return(int)
}
.Marg.0.Lp <-
function(x,a,b,Vmod,p)
{
  to.int<-function(w,x,a,b,Vmod,p)
  {
    exp(-(x*.Lp(w,p)/w))*.vdens(w,Vmod,a,b)
  }
  
  if(length(x)>1){stop("x should be scalar")}
  
  int<-integrate(to.int,0,1,x=x,a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
  
  return(int)
}
.Marg.lam.Linf <-
function(x,lam,a,b,Vmod)
{
  if(abs(lam)<1e-10)
  {
    return(.Marg.0.Linf(x=x,a=a,b=b,Vmod=Vmod))
  }
  else{
    to.int<-function(w,x,lam,a,b,Vmod)
    {
      out<-.vdens(w,Vmod,a,b)*pmax((.Linf(w)*lam*x/w+1)^(-1/lam),0)
      out[out<1e-300]<-0 # to prevent numerical integration failure
      return(out)
    }
    
    int<-NULL
    if(lam>0){lower<-0}
    else{lower<- -x*lam/(1-lam*x)}
    
    if(length(x)>1){stop("x should be scalar")}
    if(x<0){stop("x should be positive")}  
    
    int<-integrate(to.int,lower,1,x=x,lam=lam,a=a,b=b,Vmod=Vmod,abs.tol=0)$val
    
    return(int)
  }
}
.Marg.lam.Lp <-
function(x,lam,a,b,Vmod,p)
{
  if(abs(lam)<1e-10)
  {
    return(.Marg.0.Lp(x=x,a=a,b=b,Vmod=Vmod,p=p))
  }
  else{
    to.int<-function(w,x,lam,a,b,Vmod,p)
    {
      out<-.vdens(w,Vmod,a,b)*pmax((.Lp(w,p)*lam*x/w+1),0)^(-1/lam)
      out[out<1e-300]<-0 # to prevent numerical integration failure
      return(out)
    }
    
    int<-NULL
    if(lam>0){lower<-0}
    else{lower<-(1+((-lam*x)^(-p)-1)^(1/p))^(-1)}
    
    if(1-lower<= 1e-9){return(0)} # preventing numerical failure when upper limit essentially = lower limit
    
    if(length(x)>1){stop("x should be scalar")}
    if(x<0){stop("x should be positive")}  
    
    int<-integrate(to.int,lower,1,x=x,lam=lam,a=a,b=b,Vmod=Vmod,p=p,abs.tol=0)$val
    
    return(int)
  }
}
.Q.lam.Linf <-
function(u,lam,a,b,Vmod,low=0,up=10e10)
{
  dummy<-function(x,u,lam,a,b,Vmod)
  {
    1-.Marg.lam.Linf(x,lam=lam,a=a,b=b,Vmod=Vmod) - u
  }
  
 if(lam<0){up<-(-1/lam)*(1-1e-10)}
  ur<-uniroot(dummy,interval=c(low,up),u=u,lam=lam,a=a,b=b,Vmod=Vmod)
  return(ur$root)
}
.Q.lam.Lp <-
function(u,lam,a,b,Vmod,p,low=0,up=10e10)
{
  dummy<-function(x,u,lam,a,b,Vmod,p)
  {
    1-.Marg.lam.Lp(x,lam=lam,a=a,b=b,Vmod=Vmod,p=p) - u
  }
  
  if(lam<0){up<-(-1/lam)*(1-1e-10)}
  ur<-uniroot(dummy,interval=c(low,up),u=u,lam=lam,a=a,b=b,Vmod=Vmod,p=p)
  return(ur$root)
}
.sv.plot <-
function(x, sthresh=NULL,ncore=1,...)
  {
    if(is.null(sthresh)&&length(x$Thresh)==1){sthresh<-x$Thresh}
    else if(is.null(sthresh)){stop("Please provide a threshold for the uniform S-V plot (argument: `sthresh')")}
    
    if(ncore>1)
    {
      requireNamespace("multicore")
      if(x$Norm=="Linf")
      {
        afit<-multicore::mclapply(x$uv[,1],.Q.lam.Linf,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,mc.cores=ncore)
        bfit<-multicore::mclapply(x$uv[,2],.Q.lam.Linf,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,mc.cores=ncore)
      }
      else if(x$Norm=="Lp")
      {
        afit<-multicore::mclapply(x$uv[,1],.Q.lam.Lp,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p,mc.cores=ncore)
        bfit<-multicore::mclapply(x$uv[,2],.Q.lam.Lp,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p,mc.cores=ncore)
      }
    }
    else
    {
      if(x$Norm=="Linf")
      {
        afit<-lapply(x$uv[,1],.Q.lam.Linf,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)
        bfit<-lapply(x$uv[,2],.Q.lam.Linf,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)
      }
      else if(x$Norm=="Lp")
      {
        afit<-lapply(x$uv[,1],.Q.lam.Lp,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)
        bfit<-lapply(x$uv[,2],.Q.lam.Lp,lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)
      }
      
    }
    
    afit<-unlist(afit)
    bfit<-unlist(bfit)
    
    if(x$Norm=="Linf"){sfit<-pmax(afit,bfit)}
    else if(x$Norm=="Lp"){sfit<-.Lp2(afit,bfit,p=x$p)}
    
    vfit<-afit/(afit+bfit)
    
    us<-unif(sfit[sfit>quantile(sfit,sthresh)])
    uv<-unif(vfit[sfit>quantile(sfit,sthresh)])
    
    plot(uv,us,xlab="Uniform V", ylab="Uniform S",...)
  }
.StartingValues <-
function(uv,thresh,norm,Vmod)
{
  xye<--log(1-uv)
  xyem<-apply(xye,1,min)
  t<-quantile(xyem,thresh)
  eta<-mean((xyem-t)[xyem>t])
  
  if(norm=="Lp"){LS<-eta-0.5}
  else if(norm=="Linf"){LS<-min(-(1/eta)+1.2,0.9)}
  
  xyp<-exp(xye)
  if(abs(LS)>1e-3)
  {
    bcxy<-((xyp)^LS-1)/LS
  }
  else{bcxy<-xye}
  bcxy.w<-bcxy[,1]/(bcxy[,1]+bcxy[,2])
  bcxy.w<-bcxy.w[uv[,1]>thresh|uv[,2]>thresh]
  
  if(Vmod=="beta"||Vmod=="logistic"||Vmod=="lp")
  {
    nll1d<-function(a,w,Vmod){
      return(-sum(log(.vdens(w=w,a=a,Vmod=Vmod))))
    }
    if(Vmod=="beta"){range<-c(0.05,20)}
    if(Vmod=="logistic"){range<-c(0.05,0.95)}
    if(Vmod=="lp"){range<-c(1,20)}
    AS<-optimize(nll1d,w=bcxy.w,range,Vmod=Vmod)$min
  }
  
  else if(Vmod=="abeta")
  {
    nll2d<-function(ab,w,Vmod){-sum(log(.vdens(w=w,a=ab[1],b=ab[2],Vmod=Vmod)))}
    AS<-optim(nll2d,w=bcxy.w,par=c(1,1),Vmod=Vmod)$par
  }

  return(c(LS,AS))
}
.Surv.Cop.lam.Linf <-
function(uv,lam,a,b,Vmod,up=10e10)
{
  u<-uv[1]
  v<-uv[2]
  .Joint.lam2.Linf(x=.Q.lam.Linf(u,lam=lam,a=a,b=b,Vmod=Vmod,up=up),y=.Q.lam.Linf(v,lam=lam,a=a,b=b,Vmod=Vmod,up=up),lam=lam,a=a,b=b,Vmod=Vmod)
}
.Surv.Cop.lam.Linf.diag <-
function(u,lam,a,b,Vmod,up=10e10)
{
  x<-.Q.lam.Linf(u,lam=lam,a=a,b=b,Vmod=Vmod,up=up)
  .Joint.lam2.Linf(x=x,y=x,lam=lam,a=a,b=b,Vmod=Vmod)
}
.Surv.Cop.lam.Lp <-
function(uv,lam,a,b,Vmod,p=p,up=10e10)
{
  u<-uv[1]
  v<-uv[2]
  .Joint.lam2.Lp(x=.Q.lam.Lp(u,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=up),y=.Q.lam.Lp(v,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=up),lam=lam,a=a,b=b,Vmod=Vmod,p=p)
}
.Surv.Cop.lam.Lp.diag <-
function(u,lam,a,b,Vmod,p=p,up=10e10)
{
  x<-.Q.lam.Lp(u,lam=lam,a=a,b=b,Vmod=Vmod,p=p,up=up)
  .Joint.lam2.Lp(x=x,y=x,lam=lam,a=a,b=b,Vmod=Vmod,p=p)
}
.vdens <-
function(w,Vmod,a,b)
{
  if(Vmod=="beta"){dbeta(w,a,a)}
  else if(Vmod=="logistic"){.logisticdens(w,a)}
  else if(Vmod=="lp"){.vdens.Lpnorm(w,a)}
}
.vdens.Lpnorm <-
function(w,a)
{
  (a)*w^(a-1)*(1-w)^(a-1) / (w^a+(1-w)^a)^2
}
.cens.nll.uv.Linf.lamfixed <-
  function(a,lam,maxlam=1.5,...)
{
  .cens.nll.uv.Linf(theta=c(lam,a),maxlam=maxlam,...)
}
.cens.nll.uv.Lp.lamfixed <-
  function(a,lam,maxlam=1.5,...)
{
  .cens.nll.uv.Lp(theta=c(lam,a),maxlam=maxlam,...)
}
.cens.nll.uv.Linf.afixed <-
  function(lam,a,maxlam=1.5,...)
{
  .cens.nll.uv.Linf(theta=c(lam,a),maxlam=maxlam,...)
}
.cens.nll.uv.Lp.afixed<-
  function(lam,a,maxlam=1.5,...)
{
  .cens.nll.uv.Lp(theta=c(lam,a),maxlam=maxlam,...)
}