Lik.Surface2D <-
  function(x,lamrange,arange,n=20,plot=TRUE,rtn=FALSE,ncore=1,...)
{
  lam<-x$Parameters[1]
  a<-x$Parameters[2]
  
  uv<-x$uv 
  marg.thresh<-x$Thresh
  norm<-x$Norm
  if(norm=="Lp"){p<-x$p}
  Vmod<-x$Vmodel
  
  if(length(marg.thresh)==2){mt<-marg.thresh}
  else if(length(marg.thresh)==1){mt<-rep(marg.thresh,2)}
  
  #############################################################################################
  if(ncore>1){
    IP<-installed.packages()
    if(!is.element("multicore",IP[,1])){stop("Package multicore must be installed in order to use > 1 core")}
    requireNamespace("multicore")
  }
  #############################################################################################
  
  uvexc<-uv[uv[,1]>mt[1]|uv[,2]>mt[2],]
  n.nexc<-dim(uv)[1]-dim(uvexc)[1]
  
  pargrid<-expand.grid(seq(lamrange[1],lamrange[2],len=n),seq(arange[1],arange[2],len=n))
  
  PL<-NULL
  if(norm=="Linf")
  {
    for(i in 1:dim(pargrid)[1])
    {
      PL[i]<- .cens.nll.uv.Linf(uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, theta=as.numeric(pargrid[i,]), Vmod=Vmod,
                                thresh=marg.thresh, maxlam=max(lamrange[2],1)) 
      cat(paste(rep("\b",4),collapse=""))
      cat(c(round(i/n^2,2)))  
    }
  }
  
  
  if(norm=="Lp")
  {    for(i in 1:dim(pargrid)[1])
  {
    PL[i]<- .cens.nll.uv.Lp(uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, theta=as.numeric(pargrid[i,]), p=p, Vmod=Vmod,
                            thresh=marg.thresh, maxlam=max(lamrange[2],1)) 
    cat(paste(rep("\b",4),collapse=""))
    cat(c(round(i/n^2,2)))
  }
  }
  
  if(any(is.na(PL))&&rtn)
  {
    df<-data.frame(cbind(pargrid,PL))
    names(df)<-c("lambda","alpha","NLL")
    return(df)
  }
  
  if(plot)
  {
    contour(seq(lamrange[1],lamrange[2],len=n),seq(arange[1],arange[2],len=n),matrix(PL,n,n),levels=min(PL)+c(1:20)/2,
            xlab=expression(lambda),ylab=expression(alpha),...)
    points(x$Parameters[1],x$Parameters[2],col=2,pch="X")
  }
  
  if(rtn){
    df<-data.frame(cbind(pargrid,PL))
    names(df)<-c("lambda","alpha","NLL")
    return(df)
  }
}