plot.EV.copula <-
function(x, umin=0.9, ncore=1, which=c(1,2,3), sthresh=0.9,...)
{
  if(ncore>1){
    IP<-installed.packages()
    if(!is.element("multicore",IP[,1])){stop("Package multicore must be installed in order to use > 1 core")}
    requireNamespace("multicore")
  }
  par(mfrow=c(1,length(which)))
  if(is.element(1,which)){.chi.plot(x=x,umin=umin,...)}
  if(is.element(2,which)){.chi.bar.plot(x=x,umin=umin,...)}
  if(is.element(3,which)){.sv.plot(x=x, ncore=ncore, sthresh=sthresh,...)}
}
