\name{EVcopula-package}
\alias{EVcopula-package}
\alias{EVcopula}
\docType{package}
\title{
Fit asymptotically motivatated bivariate copulas to asymptotically independent or asymptotically dependent data
}
\description{
 Provides functionality to fit various asymptotically motivatated bivariate copulas, diagnostic plots to help check model fits, and methods to estimate extreme probabilities from fitted models.
}
\details{
\tabular{ll}{
Package: \tab EVcopula\cr
Type: \tab Package\cr
Version: \tab 0.1\cr
Date: \tab 2015-05-14\cr
License: \tab GPL-3\cr
}
}
\author{
Jenny Wadsworth

Maintainer: Jenny Wadsworth <j.wadsworth@lancaster.ac.uk>
}
\references{
Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+).
Modelling across extremal dependence classes. Preprint.
}

\keyword{package}
\seealso{}
\examples{

library(evd)
x<-rbvevd(1000, model="log", dep=0.3, mar1=c(1,1,1))
u<-apply(x, 2, function(x) exp(-1/x))

# NB only use ncore > 1 if you have multiple cores and the package `multicore' installed

\dontrun{
fit.Linf<-fit.EV.copula(uv=u, norm="Linf", Vmod="beta", marg.thresh=0.95, ncore=2)
fit.Linf

fit.Lp<-fit.EV.copula(uv=u, norm="Lp", Vmod="beta", p=1, marg.thresh=0.95, ncore=2)
fit.Lp

plot(fit.Linf, which=c(1,2))
plot(fit.Lp, ncore=2)

Prob.Est(fit.Linf, uvec=c(0.8,0.9), vvec=c(0.99,0.999))
Prob.Est(fit.Lp, uvec=c(0.8,0.9), vvec=c(0.99,0.999))
}

}
