\name{Lik.Surface2D}
\alias{Lik.Surface2D}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Negative log-likelihood surface for two-dimensional parameter 
  %%  ~~function to do ... ~~
}
\description{
  Produces a contour plot of the negative log-likelihood for \eqn{(\lambda,\alpha)} from the copula model fitted using \link{fit.EV.copula}
  %%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
  Lik.Surface2D(x,lamrange,arange,n=20,plot=TRUE,rtn=FALSE,ncore=1,...)
  
  }
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{An object of class EV.copula (fitted using \link{fit.EV.copula})}
  %%     ~~Describe \code{uv} here~~
    
    \item{lamrange}{A vector of length two giving the endpoints of an interval in which to plot the likelihood for \eqn{\lambda}.}
  %%     ~~Describe \code{\dots} here~~
    
    \item{arange}{A vector of length two giving the endpoints of an interval in which to plot the likelihood for \eqn{\alpha}.}
  
  \item{n}{The number of points at which to evaluate the likelihood in each direction; the total grid will thus comprise \eqn{n^2} parameters.}
  
  \item{plot}{Logical. Plot the negative log likelihood surface?}
  
  \item{rtn}{Logical. If TRUE, returns the parameter grid and negative log likelihood values.}
  
  \item{ncore}{Number of cores to use on a computer. Defaults to 1, which requires no additional packages. If you have multiple cores on your computer and have the package "multicore" installed, then this number can be set to the number of cores you would like to use. Fitting these models can be slow, hence this option can be used to speed up computations.}
  
  \item{...}{Additional arguments to be passed to contour}
}
\details{
By default produces a plot of the 2D negative log likelihood. The function can be slow if many likelihood evaluations are required, and so a progress report (numbers ranging from 0 to 1) is printed in the console as the function is running.
  %%  ~~ If necessary, more details than the description above ~~
}
\value{
  Either simply a contour plot, or a matrix of parameter values (first and second columns) and negative log-likelihood values (final column). 
}
\references{
  Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+).
  Modelling across extremal dependence classes. Preprint.
}
\author{
  Jenny Wadsworth
  %%  ~~who you are~~
}
\note{
  
  The likelihood relies heavily on numerical integration techniques implemented with the function stats::integrate. Occasionally (and more often for weakly / negatively dependent data) this can cause errors, which are attempted to be dealt with internally by returning NA to the optimization if an error occurs. If such instances occur, they are catalogued as warnings, and returned when the fit has finished.
  
  A further numerical fix arised with the handling of quantiles returned as exactly zero, which are replaced by positive values lower than the next smallest value returned. Again, if such instances occur, they are catalogued as warnings, and returned when the fit has finished.
  
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
  
  \seealso{
    \code{\link{fit.EV.copula}}
    \code{\link{Proflik1D}}
    \code{\link{contour}}
    %% ~~objects to See Also as \code{\link{help}}, ~~~
  }
\examples{
  \dontrun{
    uv<-cbind(runif(1000),runif(1000))
    
    # NB change ncore argument depending upon number of cores you have / wish to use
    
    fit<-fit.EV.copula(uv,marg.thresh=0.95,norm="Lp",Vmod="beta",ncore=2)
    fit
    
    # NB: recommended to try small n first to assess where important areas are, then larger n for a better picture 
    
    Lik.Surface2D(fit,lamrange=c(-0.4,0.4),arange=c(0.2,2),n=10) 
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}
