\name{Proflik1D}
\alias{Proflik1D}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Profile likelihood for one-dimensional parameter 
  %%  ~~function to do ... ~~
}
\description{
  Produces a plot of the profile likelihood for a specified parameter from the copula model fitted using \link{fit.EV.copula}
  %%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
  Proflik1D(x, whichpar, parrange, npts, plot=TRUE,rtn=FALSE, ncore=1)
  
  }
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{An object of class EV.copula (fitted using \link{fit.EV.copula})}
  %%     ~~Describe \code{uv} here~~
    
    \item{whichpar}{A character vector specifying which parameter to plot the profile likeihood for. Currently either "lambda" or "alpha".}
  %%     ~~Describe \code{\dots} here~~
    
    \item{parrange}{A vector of length two giving the endpoints of an interval in which to plot the profile likelihood.}
  
  \item{npts}{The number of points at which to evaluate the profile likelihood (more points = smoother plot, but takes longer)}
  
  \item{plot}{Logical. Plot the profile likelihood?}
  
  \item{rtn}{Logical. If TRUE, returns the parameter grid and profile likelihood values.}
  
  \item{ncore}{Number of cores to use on a computer. Defaults to 1, which requires no additional packages. If you have multiple cores on your computer and have the package "multicore" installed, then this number can be set to the number of cores you would like to use. Fitting these models can be slow, hence this option can be used to speed up computations.}
}
\details{
By default produces a plot of the 1D profile negative log likelihood. The function can be slow if many likelihood evaluations are required, and so a progress report (numbers ranging from 0 to 1) is printed in the console as the function is running.
  %%  ~~ If necessary, more details than the description above ~~
}
\value{
  Either simply a plot, or a matrix of parameter values (first column) and negative log-likelihood values (second column). A horizonal line is plotted at the minumum likelihood value + 1.92, indicating a 95\% profile likelihood based confidence interval.
}
\references{
  Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+).
  Modelling across extremal dependence classes. Preprint.
}
\author{
  Jenny Wadsworth
  %%  ~~who you are~~
}
\note{
  
  The likelihood relies heavily on numerical integration techniques implemented with the function stats::integrate. Occasionally (and more often for weakly / negatively dependent data) this can cause errors, which are attempted to be dealt with internally by returning NA to the optimization if an error occurs. If such instances occur, they are catalogued as warnings, and returned when the fit has finished.
  
  A further numerical fix arised with the handling of quantiles returned as exactly zero, which are replaced by positive values lower than the next smallest value returned. Again, if such instances occur, they are catalogued as warnings, and returned when the fit has finished.
  
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
  
  \seealso{
    \code{\link{fit.EV.copula}}
    \code{\link{Lik.Surface2D}}
    %% ~~objects to See Also as \code{\link{help}}, ~~~
  }
\examples{
  \dontrun{
    uv<-cbind(runif(1000),runif(1000))
    
    # NB change ncore argument depending upon number of cores you have / wish to use
    
    fit<-fit.EV.copula(uv,marg.thresh=0.95,norm="Lp",Vmod="beta",ncore=2)
    fit
    
    Proflik1D(fit,whichpar="lambda",parrange=c(-0.4,0.4),npts=10)
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}
