\name{plot.EV.copula}
\alias{plot.EV.copula}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot diagnostics for a fitted model of class EV.copula
%%  ~~function to do ... ~~
}
\description{
Plots any or all of: \eqn{\chi(u)}{chi(u)}, \eqn{\bar{\chi}(u)}{chibar(u)}, and fitted S versus fitted V (the latter on a uniform scale). See details.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
\method{plot}{EV.copula}(x, umin = 0.9, ncore = 1, which = c(1, 2, 3), ...)
%plot.EV.copula(x, umin = 0.9, ncore = 1, which = c(1, 2, 3), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{Object of class EV.copula (i.e., output from fit.EV.copula)}
  \item{umin}{Value of u from which to plot chi(u), and chibar(u)}
  \item{ncore}{Number of cores to use (if package `multicore' is installed)}
  \item{which}{Vector denoting which items to plot. 1 - chi plot, 2 - chi bar plot, 3 - fitted S vs V plot. }
  \item{sthresh}{Threshold (on a qunatile scale) for S. If S-V plot is shown, then points will correspond to S and V where S exceeds its sthresh quantile}
  \item{...}{Additional arguments to be passed to plot}
}
\details{
The function \eqn{\chi(u)}{chi(u)} is defined as \eqn{\chi(u) = \Pr(U>u,V>u)/(1-u)}{chi(u) = P(U>u,V>u)/(1-u)}.

The function \eqn{\bar{\chi(u)}}{chibar(u)} is defined as \eqn{\chi(u) = 2\log(1-u)/\log \Pr(U>u,V>u) -1.}{chi(u) = 2 log(1-u)/log P(U>u, V>u) -1}

The fitted S and V are defined using the fitted model, and then put onto a uniform scale using the rank transform. If the model fits well then there should be no obvious association.

The fitted S-V plot is more time-consuming than the others, hence the option to use multiple cores.

%%  ~~ If necessary, more details than the description above ~~
}
\value{
Only plots the requested diagnostics.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Jenny Wadsworth
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
\dontrun{
uv<-cbind(runif(1000),runif(1000))

# NB change ncore argument depending upon number of cores you have / wish to use

fit<-fit.EV.copula(uv,marg.thresh=0.95,norm="Linf",Vmod="beta",ncore=2)
fit

plot(fit,which=c(1,2))
plot(fit, ncore=4)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
