EV.copula.default <-
function(uv, marg.thresh, norm="Linf", p=1, Vmod="beta", start=NULL, se.hess=FALSE, ncore=1, maxlam=1)
{
  #############################################################################################
  # check on marginal threshold
  if(!is.numeric(marg.thresh))
  {
    stop("marg.thresh should be a numeric vector")
  }
  if(length(marg.thresh)==2){mt<-marg.thresh}
  else if(length(marg.thresh)==1){mt<-rep(marg.thresh,2)}
  else if(length(marg.thresh)>2)
  {
    warning("marg.thresh contains more than two elements; only the first two will be used")
    mt<-marg.thresh[1:2]
  }
  #############################################################################################
  if(norm=="Lp" && p<1){stop("p must be >= 1 to define a norm")}
  #############################################################################################
  if(ncore>1){
    IP<-installed.packages()
    if(!is.element("multicore",IP[,1])){stop("Package multicore must be installed in order to use > 1 core")}
    requireNamespace("multicore")
  }
  #############################################################################################
  
  uvexc<-uv[uv[,1]>mt[1]|uv[,2]>mt[2],]
  n.nexc<-dim(uv)[1]-dim(uvexc)[1]
  
  if(is.null(start))
  {
  start<-.StartingValues(uv,thresh=mean(mt),norm=norm,Vmod=Vmod)
  }
  
  if(norm=="Linf")
  {
  opt<-optim(.cens.nll.uv.Linf, uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, par=start, Vmod=Vmod, hessian=se.hess,
             thresh=marg.thresh, control=list(reltol=1e-5), maxlam=maxlam) 
  }
  
  
  if(norm=="Lp")
  {
  opt<-optim(.cens.nll.uv.Lp, uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, p=p, par=start, Vmod=Vmod, hessian=se.hess,
            thresh=marg.thresh, control=list(reltol=1e-5), maxlam=maxlam) 
  }
  
  mod<-list()
  if(Vmod=="abeta"){beta<-"beta"}
  else{beta<-NULL}
  mod$ParamNames<-c("lambda","alpha",beta)
  mod$Parameters<-opt$par
  if(se.hess)
  {
    mod$Cov.Mat<-solve(opt$hessian) 
    mod$Std.Err<-sqrt(diag(mod$Cov.Mat))
  }
  mod$Vmodel<-Vmod
  mod$Norm<-norm
  mod$uv<-uv
  mod$Thresh<-marg.thresh
  mod$AIC<-2*opt$val +2*length(mod$Parameters)
  mod$Conv<-opt$conv

  if(norm=="Lp"){mod$p<-p}
  
  mod$call<-match.call()
  
  class(mod)<-"EV.copula"
  
  return(mod)
}
