
Prob.Est.default<-
  function(x, uvec, vvec,...)
{
  if(length(uvec)>2 || length(vvec)>2){stop("Length of `uvec' and `vvec' should be <= 2")}
  
  u1<-min(uvec)
  v1<-min(vvec)
  if(x$Norm=="Linf")
  {p11<-.Surv.Cop.lam.Linf(uv=c(u1,v1),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)}
  else if(x$Norm=="Lp")
  {p11<-.Surv.Cop.lam.Lp(uv=c(u1,v1),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)}
  
  prob<-p11
  u12<-c(u1,1)
  v12<-c(v1,1)
  
  if(length(uvec)>1)
  {
    u2<-max(uvec)
    if(x$Norm=="Linf")
    {p21<-.Surv.Cop.lam.Linf(uv=c(u2,v1),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)}
    else if(x$Norm=="Lp")
    {p21<-.Surv.Cop.lam.Lp(uv=c(u2,v1),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)}
    
    prob<-p11-p21
    u12<-c(u1,u2)
  }  
  if(length(vvec)>1)
  {
    v2<-max(vvec)
    if(x$Norm=="Linf")  
    {p12<-.Surv.Cop.lam.Linf(uv=c(u1,v2),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)}
    else if(x$Norm=="Lp")
    {p12<-.Surv.Cop.lam.Lp(uv=c(u1,v2),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)}
    prob<-p11-p12
    v12<-c(v1,v2)
  }
  if(length(uvec)>1 && length(vvec)>1)
  {
    if(x$Norm=="Linf")  
    {p22<-.Surv.Cop.lam.Linf(uv=c(u2,v2),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel)}
    else if(x$Norm=="Lp")
    {p22<-.Surv.Cop.lam.Lp(uv=c(u2,v2),lam=x$Parameters[1],a=x$Parameters[2],b=x$Parameters[3],Vmod=x$Vmodel,p=x$p)}
    prob<-p11-p12-p21+p22
  }
  
  if(prob<0){warning("Probability estimated as <0; resolved to 0")}
  if(abs(prob)<.Machine$double.eps){warning("Probability estimated as less than 2 x machine epsilon; resolved to 0")}
  
  if(prob<0||abs(prob)<.Machine$double.eps){prob<-0}
  
  Prob<-list()
  
  Prob$probability<-prob
  Prob$set<-list(u=u12,v=v12)
  
  class(Prob)<-"Prob.EV.copula"
  return(Prob)
}

