Proflik1D <-
  function(x, whichpar, parrange, npts, plot=TRUE,rtn=FALSE, ncore=1)
{
  uv<-x$uv 
  marg.thresh<-x$Thresh
  norm<-x$Norm
  if(norm=="Lp"){p<-x$p}
  Vmod<-x$Vmodel
  
  if(Vmod=="beta"||Vmod=="lp"){ainterval<-c(0.05,200)}
  else if(Vmod=="logistic"){ainterval<-c(0.01,0.99)}
  
  if(length(marg.thresh)==2){mt<-marg.thresh}
  else if(length(marg.thresh)==1){mt<-rep(marg.thresh,2)}
  
  #############################################################################################
  if(ncore>1){
    IP<-installed.packages()
    if(!is.element("multicore",IP[,1])){stop("Package multicore must be installed in order to use > 1 core")}
    requireNamespace("multicore")
  }
  #############################################################################################
  
  uvexc<-uv[uv[,1]>mt[1]|uv[,2]>mt[2],]
  n.nexc<-dim(uv)[1]-dim(uvexc)[1]
  
  opt<-otherpar<-NULL
  parseq<-seq(parrange[1],parrange[2],length=npts)
  
  if(norm=="Linf")
  {
    if(whichpar=="alpha")
    {
      for(j in 1:npts)
      {
        ll<-optimize(.cens.nll.uv.Linf.afixed, interval=c(-1.5,2.5), a=parseq[j], uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, Vmod=Vmod,
                         thresh=marg.thresh,maxlam=2.5)
        opt[j]<-ll$obj
        otherpar[j]<-ll$min
        
        cat(paste(rep("\b",4),collapse=""))
        cat(c(round(j/npts,2)))
      }
    }
    if(whichpar=="lambda")
    {
      for(j in 1:npts)
      {
        ll<-optimize(.cens.nll.uv.Linf.lamfixed, interval=ainterval, lam=parseq[j], uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, Vmod=Vmod,
                         thresh=marg.thresh,maxlam=max(parseq[j],2.5))
        opt[j]<-ll$obj
        otherpar[j]<-ll$min
        
        cat(paste(rep("\b",4),collapse=""))
        cat(c(round(j/npts,2)))
      }
    }
    
  }
  
  
  if(norm=="Lp")
  {
    if(whichpar=="alpha")
    {
      for(j in 1:npts)
      {
        ll<-optimize(.cens.nll.uv.Lp.afixed, interval=c(-1.5,2.5), a=parseq[j], p=p, uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, Vmod=Vmod,
                         thresh=marg.thresh,maxlam=2.5)
        opt[j]<-ll$obj
        otherpar[j]<-ll$min
        
        cat(paste(rep("\b",4),collapse=""))
        cat(c(round(j/npts,2)))
      }
    }
    if(whichpar=="lambda")
    {
      for(j in 1:npts)
      {
        ll<-optimize(.cens.nll.uv.Lp.lamfixed, interval=ainterval, lam=parseq[j], p=p, uvexc=uvexc, n.nexc=n.nexc, ncore=ncore, Vmod=Vmod,
                         thresh=marg.thresh,maxlam=max(parseq[j],2.5))
        
        opt[j]<-ll$obj
        otherpar[j]<-ll$min
        
        cat(paste(rep("\b",4),collapse=""))
        cat(c(round(j/npts,2)))
      }
    }
  }
  
  if(plot)
  {
    if(whichpar=="alpha"){plot(parseq,opt,typ="l",xlab=expression(alpha),ylab="Profile Neg Log Likelihood")}
    else if(whichpar=="lambda"){plot(parseq,opt,typ="l",xlab=expression(lambda),ylab="Profile Neg Log Likelihood")}
    abline(h=(x$AIC-2*length(x$Parameters))/2+qchisq(0.95,df=1)/2,col=2)
  }
  
  if(rtn){
    df<-data.frame(cbind(parseq,otherpar,opt))
    names(df)<-c(whichpar,c("lambda","alpha")[c("lambda","alpha")!=whichpar],"NLL")
    return(df)
  }
}