\name{Prob.Est}
\alias{Prob.Est}
\alias{Prob.Est.default}
\alias{print.Prob.EV.copula}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Estimate probabilities of lying in joint survivor or rectangular shaped sets from objects of class EV.copula
%%  ~~function to do ... ~~
}
\description{
Takes a fitted model (an object of class EVcopula) and returns the fitted probability of lying in a specified joint survivor or rectangular shaped set.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
\method{Prob.Est}{default}(x, uvec, vvec,...)
\method{print}{Prob.EV.copula}(x,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{Object of class EV.copula (i.e., output from fit.EV.copula)
%%     ~~Describe \code{x} here~~
}
  \item{uvec, vvec}{Vectors of length 1 or 2 giving the u-coordinates (respectively v-coordinates) for the rectangular region. If length=1, then the other coordinate is assumed to be 1.}
  
  \item{...}{Not used; for matching generic only.}
%%     ~~Describe \code{uvec} here~~
}


\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
Prints the probability of lying in the given set according to the fitted model. Returns an object of class Prob.EV.copula, with elements "probabilty" and "set".
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
  Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+).
  Modelling across extremal dependence classes. Preprint.
%% ~put references to the literature/web site here ~
}
\author{
Jenny Wadsworth
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
    \code{\link{fit.EV.copula}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
\dontrun{
uv<-cbind(runif(1000),runif(1000))
fit<-fit.EV.copula(uv,marg.thresh=0.95,norm="Linf",Vmod="beta")

Prob.Est(fit, uvec=c(0.98,0.99), vvec=c(0.99,0.995))
Prob.Est(fit, uvec=c(0.98), vvec=c(0.99,0.995))
Prob.Est(fit, uvec=c(0.98), vvec=c(0.99))
}
}

