\name{fit.EV.copula}
\alias{fit.EV.copula}
\alias{print.EV.copula}
\alias{EV.copula.default}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fit a bivariate extreme value copula to asymptotically (in)dependent data
%%  ~~function to do ... ~~
}
\description{
Fits a copula to extremes of a bivariate dataset in uniform margins. The fitting is done by maximum likelihood, and the class of models available includes both asymptotically dependent and asymptotically independent extremal behaviour.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
\method{EV.copula}{default}(uv, marg.thresh, norm="Linf", p = 1, Vmod="beta", 
    start = NULL, se.hess = FALSE, ncore = 1, maxlam=1)

%fit.EV.copula(uv, marg.thresh, norm="Linf", p = 1, Vmod="beta", 
%    start = NULL, se.hess = FALSE, ncore = 1, maxlam=1)
%\method{plot}{EV.copula}(x,...)
\method{print}{EV.copula}(x,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{uv}{A matrix with two columns, containing all original data on uniform(0,1) margins.}
%%     ~~Describe \code{uv} here~~

  \item{marg.thresh}{The threshold at which to censor (should lie between 0 and 1). If this is a scalar, then the data (u,v) for which u > marg.thresh OR v > marg.thresh will be uncensored, whilst those failing this condition will be censored. If this is a vector of length two, then the first value will be the threshold for u, and the second for v. If a vector of length > 2 is supplied then the first two elements will be used, and a warning produced.}
%%     ~~Describe \code{\dots} here~~

 \item{norm}{The norm to use in the model. Should be one of the character strings "Linf" for the L-infinity or "max" norm; or "Lp" for an L-p norm \eqn{(x^p + y^p)^{1/p}}{(x^p + y^p)^1/p}, for finite \eqn{p \ge 1}{p>=1}.}
 
 \item{p}{The value of p for the L-p norm, if selected.}
 
 \item{Vmod}{Character string to specify model for the V distribution. Must be one of "beta" for the symmetric beta, "logistic" for the symmetric logistic, or "lp" (see details)}
 
 \item{start}{Optional vector of starting values for the optimization. If NULL (the default), then the function will attempt to find reasonable starting values, but it may be wise to try different values.}
 
 \item{se.hess}{Logical: should the Hessian be computed numerically to give approximate standard errors? May not always work well.}
 
 \item{ncore}{Number of cores to use on a computer. Defaults to 1, which requires no additional packages. If you have multiple cores on your computer and have the package "multicore" installed, then this number can be set to the number of cores you would like to use. Fitting these models can be slow, hence this option can be used to speed up computations.}
 
 \item{maxlam}{Maximum value of \eqn{\lambda}{lambda}. Defaults to one. Allowing high values may occasionally cause numerical issues.}
 
 \item{x}{(For use with "print") Object of class EV.copula}
 
   \item{...}{Not used; for matching generic only.}
}
\details{
The copula fitted is that of \deqn{
(A,B) = S (V,1-V)/\|(V,1-V)\|
}{(A,B) = S (V,1-V)/||(V,1-V)||}
where S has a generalized Pareto distribution with scale parameter 1 and shape parameter lambda (to be estimated), and V has distribution given in the argument Vmod (with S and V independent). Currently the options are the symmetric beta distribution (Vmod="beta"), the symmetric logistc distribution (Vmod="logistic"), and the distribution with density
\deqn{
f(v;a) = a v^{a-1} (1-v)^{a-1} / (v^a+(1-v)^a)^2
}{f(v;a) = a*v^(a-1)*(1-v)^(a-1) / (v^a+(1-v)^a)^2}
(Vmod="lp").

%%  ~~ If necessary, more details than the description above ~~
}
\value{
An object of class EV.copula
}
\references{
Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+).
Modelling across extremal dependence classes. Preprint.
}
\author{
Jenny Wadsworth
%%  ~~who you are~~
}
\note{

The likelihood relies heavily on numerical integration techniques implemented with the function stats::integrate. Occasionally (and more often for weakly / negatively dependent data) this can cause errors, which are attempted to be dealt with internally by returning NA to the optimization if an error occurs. If such instances occur, they are catalogued as warnings, and returned when the fit has finished.

A further numerical fix arised with the handling of quantiles returned as exactly zero, which are replaced by positive values lower than the next smallest value returned. Again, if such instances occur, they are catalogued as warnings, and returned when the fit has finished.

}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{plot.EV.copula}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
\dontrun{
uv<-cbind(runif(1000),runif(1000))

# NB change ncore argument depending upon number of cores you have / wish to use

fit<-fit.EV.copula(uv,marg.thresh=0.95,norm="Linf",Vmod="beta",ncore=2)
fit

plot(fit,which=c(1,2))
plot(fit)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}

