\name{wavesurge}
\alias{wavesurge}
\docType{data}
\title{
Newlyn wave data
}
\description{
Dataset of wave height, period and surge collected at Newlyn, UK.
}
\usage{data("wavesurge")}
\format{
  A data frame with 2894 observations on the following 3 variables.
  \describe{
    \item{\code{Height}}{a numeric vector of wave height measurements}
    \item{\code{Period}}{a numeric vector of wave period measurements}
    \item{\code{Surge}}{a numeric vector of surge measurements}
  }
}
\details{
Data contain several ties, which may in some circumstances affect optimisation. Use of functions Lik.Surface2D and Proflik1D advised to assess the shape of the log likelihood.
}
\source{
%%  ~~ reference to a publication or URL from which the data were obtained ~~
}
\references{
Wadsworth, J. L., Tawn, J. A, Davison, A. C. and Elton, D. M. (2015+). Modelling across extremal dependence classes. Preprint.
}
\examples{
data(wavesurge)

# Transform to copula scale using empirical PIT

U.Height<-unif(wavesurge$Height)
U.Period<-unif(wavesurge$Period)
U.Surge<-unif(wavesurge$Surge)

plot(U.Height,U.Surge)

\dontrun{
fit.HS<-fit.EV.copula(uv=cbind(U.Height,U.Surge), norm="Linf", marg.thresh=0.95, ncore=4)
plot(fit.HS)
}
}
\keyword{datasets}
