\name{SpatialADAI-package}
\alias{SpatialADAI}
\docType{package}

\title{Fit asymptotically motivatated spatial copulas to asymptotically independent or asymptotically dependent data}

\description{
 Provides functionality to fit the asymptotically motivatated spatial and bivariate copulas of Huser and Wadsworth (2017+)
}


\author{
Raphael Huser <raphael.huser@kaust.edu.sa>

Jenny Wadsworth <j.wadsworth@lancaster.ac.uk>

}

\keyword{package}
\seealso{}
\examples{

library(evd)
x<-rbvevd(1000, model="log", dep=0.3, mar1=c(1,1,1))
u<-apply(x, 2, function(x) exp(-1/x))

# NB only use ncore > 1 if you have multiple cores and the package `multicore' installed

\dontrun{
fit1<-fit.cop.2dim(u=u, par=c(0.5,0.5), thresh=0.9, cens.type="partial", model="IEVL", ncore=2)
fit1
}

}
