% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalFunctions.R
\name{chiu.est}
\alias{chiu.est}
\title{empirical estimation of chi_u function, with (block) bootstrap confidence intervals}
\usage{
chiu.est(x, u = NULL, k, q1, q2 = 1, pmar = c(5.5, 7, 3, 3),
  rtn = FALSE, nbs, blocklength, ...)
}
\arguments{
\item{x}{data in an n by D matrix. Any marginals is fine: a nonparametric transformation will be applied.}

\item{u}{optionally a sequence of values at which to estimate chi}

\item{k}{if u is not supplied, k is the number of points at which to estimate chi}

\item{q1}{if u is not supplied, q1 is the lowest quantile at which chi will be estimated}

\item{q2}{if u is not supplied, q2 set the upper limit of chi estimation, however, the true upper limit will be that given by seq(q1,q2,len=k+1)[-(k+1)]}

\item{pmar}{margins for plotting}

\item{rtn}{logical; if TRUE will output estimates and bootstrap sampling distribution. Else will only plot estimate.}

\item{nbs}{number of bootstrap samples for creation of confidence intervals}

\item{blocklength}{length of block. If set equal to 1 then standard bootstrap; else this is a (non-overlapping) block bootstrap}
}
\value{
plots the estimate and approx 95\% CI. If rtn=TRUE then a list with objects chi (estimate of chi_u at the sequence u), chiBS (bootstrap sample estimates of the same), eta (estimate of the coefficient of tail dependence, eta above the thresholds defined by u), etaBS (bootstrap sample distribtuion of the same)
}
\description{
empirical estimation of chi_u function, with (block) bootstrap confidence intervals
}
\author{
Jenny Wadsworth
}

