% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalFunctions.R
\name{chiuD.QMC}
\alias{chiuD.QMC}
\title{calculates model-based chi_u in D dimensions, assuming W to have a Gaussian copula with powered exponential covariance function. Uses
faster QMC computation than chiuD.}
\usage{
chiuD.QMC(u, cov.par, dist, delta, prime = 127, rel.tol = NULL)
}
\arguments{
\item{u}{sequence of values at which to calculate chi}

\item{cov.par}{scale and shape parameter (respectively) of the powered exponential covariance function}

\item{dist}{distance matrix between sites}

\item{delta}{value of delta}

\item{prime}{prime number for the QMC calculation of multivariate Gaussian probabilities}
}
\value{
returns a vector corresponding to the value of chiu at each value of u
}
\description{
calculates model-based chi_u in D dimensions, assuming W to have a Gaussian copula with powered exponential covariance function. Uses
faster QMC computation than chiuD.
}
\details{
Behaves like chiuD, except typically much faster
}
\author{
Raphael Huser and Jenny Wadsworth
}
\references{
de Fondeville and Davison (2016) High-dimensional peaks-over-threshold inference for the Brown-Resnick process. https://arxiv.org/abs/1605.08558
}

