% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalFunctions.R
\name{fit.Gauss.Ddim.QMC}
\alias{fit.Gauss.Ddim.QMC}
\title{Fit the Gaussian copula above a threshold via censored likelihood. Uses faster QMC computation than fit.Gauss.Ddim.}
\usage{
fit.Gauss.Ddim.QMC(datU, coord, thresh, model = "pexp", init.val,
  fixed = rep(FALSE, 2), std.err = FALSE, optim = TRUE,
  method = "Nelder-Mead", sum = TRUE, print = FALSE, prime = 127, ...)
}
\arguments{
\item{datU}{n*D matrix of data (on the uniform scale): n obs of a D dimensional vector}

\item{coord}{D*2 matrix of spatial coordinates}

\item{thresh}{quantile at which to censor, for example 0.95}

\item{model}{character vector specifying model for the correlation matrix of the Gaussian process W. AT THIS POINT ONLY THE POWERED EXPONENTIAL MODEL IS IMPLEMENTED}

\item{init.val}{gives the initial values for all parameters: first the parameter delta of R, and second the parameters of the model for the correlation function}

\item{fixed}{(must be same length as init) sets some parameters fixed to their initial values. This is used to optimize the likelihood function only with respect to some of the parameters.}

\item{std.err}{logical. If TRUE, optim will return the hessian}

\item{optim}{logical. If optim=FALSE, the function returns nllik(init.val) (no optimization). Can be useful to evaluate the calculation time for likelihood evaluation}

\item{method}{character vector specifying optimization method for optim}

\item{sum}{logical - if TRUE returns negative log-likelihood for sample; if FALSE then the value of the likelihood for each vector is returned. Not intended to be called by the user.}

\item{prime}{prime number for the QMC multivariate normal calculation}

\item{...}{additional entries for the function optim}
}
\value{
list with objects "mle", "nllik", "convergence", "hessian" and "counts"
}
\description{
Fit the Gaussian copula above a threshold via censored likelihood. Uses faster QMC computation than fit.Gauss.Ddim.
}
\author{
Raphael Huser and Jenny Wadsworth
}

