% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllCopulaFunctions-Delta.R
\name{fit.cop.2dim}
\alias{fit.cop.2dim}
\title{Function to fit the 2-dimensional copula with censored likelihood}
\usage{
fit.cop.2dim(datU, thresh, init.val, cens.type = c("max", "partial"), model,
  optim = TRUE, std.err = FALSE, ncore = 1, reltol = 1e-04, ...)
}
\arguments{
\item{datU}{n * 2 matrix of data on uniform margins}

\item{thresh}{bivariate censoring threshold in (0,1)^2}

\item{init.val}{parameter vector of (delta, theta), where theta is the parameter(s) for the W model}

\item{cens.type}{either "partial" (whereby only components exceeding the threshold in all margins use the full density contribution) or "max"
(whereby components that exceed the threshold in at least one margin use the full density contribution)}

\item{model}{character "IEVL" for inverted extreme value logistic; "IEVct" for inverted extreme value Coles_tawn dirichlet, "Gauss" for BV normal}

\item{optim}{logical. If TRUE then function optimizes; if FALSE then the negative log likelihood is returned.}

\item{std.err}{logical; calculate hessian and return standard errors?}

\item{ncore}{number of cores to use. If >1 then requires multicore package}

\item{reltol}{optimization tolerance. Larger values produce less accurate, but faster, optimization.}

\item{...}{additional arguments to be passed to optim}
}
\value{
if optim=TRUE returns list with objects "mle", "nll" and "convergence"; optionally also "var.cov" and "se". If optim=FALSE returns the negative log-likelihood
}
\description{
Function to fit the 2-dimensional copula with censored likelihood
}
\author{
Jenny Wadsworth
}

