% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools.R
\name{rC}
\alias{rC}
\title{Simulate realizations with the d-dimensional copula R^(delta)*W^(1-delta) for W a Gaussian random field}
\usage{
rC(n, delta, sigma, empirMar = FALSE)
}
\arguments{
\item{n}{number of realizations}

\item{delta}{value of delta}

\item{sigma}{covariance matrix of W (d*d)}

\item{empirMar}{logical; if TRUE translation to uniform scale is done using empirical cdf, else the true cdf is used}
}
\description{
Simulate realizations with the d-dimensional copula R^(delta)*W^(1-delta) for W a Gaussian random field
}
\examples{
set.seed(123)
coord<-cbind(runif(10,0,5),runif(10,0,5))
DM<-as.matrix(dist(coord,upper=T,diag=T))
rC(n=1,delta=0.4,sigma=exp(-DM))
}
\author{
Raphael Huser
}

