% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllCopulaFunctions-Delta.R
\name{rC2}
\alias{rC2}
\title{Simulate realizations of the bivariate copula R^(delta)*W^(1-delta) for different W}
\usage{
rC2(n, delta, theta, model, scale = "unif")
}
\arguments{
\item{n}{number of realizations to simulate}

\item{delta}{parameter delta}

\item{theta}{parameter(s) of W distribution}

\item{model}{character "IEVL" for inverted extreme value logistic; "IEVct" for inverted Coles-Tawn Dirichlet; or "Gauss" for BV normal}

\item{scale}{"unif" for uniform, "y" for Y=d*logR +(1-d)*logW or "x" for exp(y)}
}
\description{
Simulate realizations of the bivariate copula R^(delta)*W^(1-delta) for different W
}
\examples{
rC2(n=1,delta=0.4,theta=-0.5,model="Gauss")
rC2(n=1,delta=0.4,theta=0.5,model="IEVL")
rC2(n=1,delta=0.4,theta=c(1,4),model="IEVct")
}
\author{
Jenny Wadsworth
}

