% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalFunctions.R
\name{score.est.Gauss}
\alias{score.est.Gauss}
\title{Function to calculate an estimate of the score for each contribution to the likelihood for the Gaussian copula}
\usage{
score.est.Gauss(datU, par, thresh, coord, eps, QMC = TRUE, ...)
}
\arguments{
\item{datU}{n*D matrix of data (on the uniform scale): n obs of a D dimensional vector}

\item{par}{parameters of the Gaussian model (log(lambda), nu)}

\item{thresh}{quantile at which fit was censored, for example 0.95}

\item{coord}{D*2 matrix of spatial coordinates}

\item{eps}{value of epsilon for numerical differencing (differences are taken at range 2*epsilon)}

\item{QMC}{logical. If TRUE, faster QMC computation of the multivarite Gaussian probabilities is used.}

\item{...}{additional arguments ("prime") to be passed on if QMC=TRUE}
}
\value{
n x 2 matrix containing the estimated score contribution for each parameter (columns) and datapoint (rows). Ordering is: log(lambda), nu
}
\description{
Function to calculate an estimate of the score for each contribution to the likelihood for the Gaussian copula
}
\author{
Jenny Wadsworth
}

