% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalFunctions.R
\name{score.est}
\alias{score.est}
\title{Function to calculate an estimate of the score for each contribution to the likelihood}
\usage{
score.est(datU, par, thresh, coord, eps, QMC = TRUE, ...)
}
\arguments{
\item{datU}{n*D matrix of data (on the uniform scale): n obs of a D dimensional vector}

\item{par}{parameters of the model (delta, log(lambda), nu)}

\item{thresh}{quantile at which fit was censored, for example 0.95}

\item{coord}{D*2 matrix of spatial coordinates}

\item{eps}{value of epsilon for numerical differencing (differences are taken at range 2*epsilon)}

\item{QMC}{logical. If TRUE then faster implementation of QMC multivariate normal is used.}

\item{...}{additional parameters to be passed on when QMC=TRUE. Specifically "prime" and "ncore" can be changed from the defaults of 127 and 1, respectively}
}
\value{
n x 3 matrix containing the estimated score contribution for each parameter (columns) and datapoint (rows). Ordering is: delta, log(lambda), nu
}
\description{
Function to calculate an estimate of the score for each contribution to the likelihood
}
\details{
This calculates an estimate of the score function for each contribution to the likelihood. The main use is likely to be in the case of temporal dependence, in which case the user will likely want to aggregate score contributions over a certain time period (e.g. a month, year etc.) and use these contributions to estimate the variance of the score. This can then be combined with an estimated Hessian to get an estimate of the sandwich covariance matrix
}
\author{
Jenny Wadsworth
}

